/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

public class RenderSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<dee> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final dfo RENDER_THREAD_TESSELATOR = new dfo();
    public static final float DEFAULTALPHACUTOFF = 0.1f;
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    private static Thread gameThread;
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean bl2) {
        boolean bl3 = \u2603 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || \u2603 == bl2) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(dee dee2) {
        recordingQueue.add(dee2);
    }

    public static void flipFrame(long l2) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        dfo.a().c().g();
        GLFW.glfwSwapBuffers((long)l2);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            dee dee2 = recordingQueue.poll();
            dee2.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int n2) {
        double d2 = lastDrawTime + 1.0 / (double)n2;
        \u2603 = GLFW.glfwGetTime();
        while (\u2603 < d2) {
            GLFW.glfwWaitEventsTimeout((double)(d2 - \u2603));
            \u2603 = GLFW.glfwGetTime();
        }
        lastDrawTime = \u2603;
    }

    @Deprecated
    public static void pushLightingAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a();
    }

    @Deprecated
    public static void pushTextureAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b();
    }

    @Deprecated
    public static void popAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c();
    }

    @Deprecated
    public static void disableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d();
    }

    @Deprecated
    public static void enableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.e();
    }

    @Deprecated
    public static void alphaFunc(int n2, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, f2);
    }

    @Deprecated
    public static void enableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.f();
    }

    @Deprecated
    public static void disableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.g();
    }

    @Deprecated
    public static void enableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.h();
    }

    @Deprecated
    public static void disableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.i();
    }

    @Deprecated
    public static void colorMaterial(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, n3);
    }

    @Deprecated
    public static void normal3f(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(f2, f3, f4);
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.l();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.m();
    }

    public static void enableScissor(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.k();
        dem.a(n2, n3, n4, n5);
    }

    public static void disableScissor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.j();
    }

    public static void depthFunc(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(n2);
    }

    public static void depthMask(boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(bl2);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.o();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.n();
    }

    public static void blendFunc(dem.r r2, dem.j j2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(r2.p, j2.o);
    }

    public static void blendFunc(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(n2, n3);
    }

    public static void blendFuncSeparate(dem.r r2, dem.j j2, dem.r r3, dem.j j3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(r2.p, j2.o, r3.p, j3.o);
    }

    public static void blendFuncSeparate(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(n2, n3, n4, n5);
    }

    public static void blendEquation(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(n2);
    }

    public static void blendColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(f2, f3, f4, f5);
    }

    @Deprecated
    public static void enableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.A();
    }

    @Deprecated
    public static void disableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.B();
    }

    @Deprecated
    public static void fogMode(dem.m m2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.o(m2.d);
    }

    @Deprecated
    public static void fogMode(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.o(n2);
    }

    @Deprecated
    public static void fogDensity(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(f2);
    }

    @Deprecated
    public static void fogStart(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(f2);
    }

    @Deprecated
    public static void fogEnd(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(f2);
    }

    @Deprecated
    public static void fog(int n2, float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, new float[]{f2, f3, f4, f5});
    }

    @Deprecated
    public static void fogi(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.l(n2, n3);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.C();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.D();
    }

    public static void polygonMode(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.m(n2, n3);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.E();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.F();
    }

    public static void enableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.G();
    }

    public static void disableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.H();
    }

    public static void polygonOffset(float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(f2, f3);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.I();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.J();
    }

    public static void logicOp(dem.o o2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.p(o2.q);
    }

    public static void activeTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.q(n2);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.K();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.L();
    }

    public static void texParameter(int n2, int n3, int n4) {
        dem.b(n2, n3, n4);
    }

    public static void deleteTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.r(n2);
    }

    public static void bindTexture(int n2) {
        dem.s(n2);
    }

    @Deprecated
    public static void shadeModel(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.t(n2);
    }

    @Deprecated
    public static void enableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.N();
    }

    @Deprecated
    public static void disableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.O();
    }

    public static void viewport(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.d(n2, n3, n4, n5);
    }

    public static void colorMask(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(bl2, bl3, bl4, bl5);
    }

    public static void stencilFunc(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d(n2, n3, n4);
    }

    public static void stencilMask(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.u(n2);
    }

    public static void stencilOp(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.e(n2, n3, n4);
    }

    public static void clearDepth(double d2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.a(d2);
    }

    public static void clearColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.b(f2, f3, f4, f5);
    }

    public static void clearStencil(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.v(n2);
    }

    public static void clear(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.a(n2, bl2);
    }

    @Deprecated
    public static void matrixMode(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.w(n2);
    }

    @Deprecated
    public static void loadIdentity() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.P();
    }

    @Deprecated
    public static void pushMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.Q();
    }

    @Deprecated
    public static void popMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.R();
    }

    @Deprecated
    public static void ortho(double d2, double d3, double d4, double d5, double d6, double d7) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(d2, d3, d4, d5, d6, d7);
    }

    @Deprecated
    public static void rotatef(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(f2, f3, f4, f5);
    }

    @Deprecated
    public static void scalef(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(f2, f3, f4);
    }

    @Deprecated
    public static void scaled(double d2, double d3, double d4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(d2, d3, d4);
    }

    @Deprecated
    public static void translatef(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(f2, f3, f4);
    }

    @Deprecated
    public static void translated(double d2, double d3, double d4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(d2, d3, d4);
    }

    @Deprecated
    public static void multMatrix(b b2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(b2);
    }

    @Deprecated
    public static void color4f(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d(f2, f3, f4, f5);
    }

    @Deprecated
    public static void color3f(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d(f2, f3, f4, 1.0f);
    }

    @Deprecated
    public static void clearCurrentColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.S();
    }

    public static void drawArrays(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.f(n2, n3, n4);
    }

    public static void lineWidth(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d(f2);
    }

    public static void pixelStore(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        dem.n(n2, n3);
    }

    public static void pixelTransfer(int n2, float f2) {
        dem.b(n2, f2);
    }

    public static void readPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, n3, n4, n5, n6, n7, byteBuffer);
    }

    public static void getString(int n2, Consumer<String> consumer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumer.accept(dem.B(n2));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(n2, bl2);
    }

    public static void setErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(gLFWErrorCallbackI);
    }

    public static void renderCrosshair(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(n2, true, true, true);
    }

    public static void setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._setupNvFogDistance();
    }

    @Deprecated
    public static void glMultiTexCoord2f(int n2, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, f2, f3);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return GLX._getCapsString();
    }

    public static void setupDefaultState(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        dem.K();
        dem.t(7425);
        dem.a(1.0);
        dem.m();
        dem.b(515);
        dem.e();
        dem.a(516, 0.1f);
        dem.w(5889);
        dem.P();
        dem.w(5888);
        dem.d(n2, n3, n4, n5);
    }

    public static int maxSupportedTextureSize() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            int n2 = dem.C(3379);
            for (\u2603 = Math.max(32768, n2); \u2603 >= 1024; \u2603 >>= 1) {
                dem.a(32868, 0, 6408, \u2603, \u2603, 0, 6408, 5121, null);
                \u2603 = dem.c(32868, 0, 4096);
                if (\u2603 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = \u2603;
                return \u2603;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(n2, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int n2, Supplier<Integer> supplier) {
        dem.g(n2, supplier.get());
    }

    public static void glBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        dem.a(n2, byteBuffer, n3);
    }

    public static void glDeleteBuffers(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.j(n2);
    }

    public static void glUniform1i(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.f(n2, n3);
    }

    public static void glUniform1(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, intBuffer);
    }

    public static void glUniform2(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(n2, intBuffer);
    }

    public static void glUniform3(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(n2, intBuffer);
    }

    public static void glUniform4(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d(n2, intBuffer);
    }

    public static void glUniform1(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(n2, floatBuffer);
    }

    public static void glUniform2(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(n2, floatBuffer);
    }

    public static void glUniform3(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.d(n2, floatBuffer);
    }

    public static void glUniform4(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.e(n2, floatBuffer);
    }

    public static void glUniformMatrix2(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(n2, bl2, floatBuffer);
    }

    public static void glUniformMatrix3(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(n2, bl2, floatBuffer);
    }

    public static void glUniformMatrix4(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.c(n2, bl2, floatBuffer);
    }

    public static void setupOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.u();
    }

    public static void teardownOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.v();
    }

    public static void setupOverlayColor(IntSupplier intSupplier, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.k(intSupplier.getAsInt(), n2);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.w();
    }

    public static void setupLevelDiffuseLighting(g g2, g g3, b b2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(g2, g3, b2);
    }

    public static void setupGuiFlatDiffuseLighting(g g2, g g3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.a(g2, g3);
    }

    public static void setupGui3DDiffuseLighting(g g2, g g3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.b(g2, g3);
    }

    public static void mulTextureByProjModelView() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.z();
    }

    public static void setupEndPortalTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.x();
    }

    public static void clearTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        dem.y();
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(dem.q()));
        } else {
            consumer.accept(dem.q());
        }
    }

    public static dfo renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(dem.r.l, dem.j.j, dem.r.e, dem.j.n);
    }

    public static void defaultAlphaFunc() {
        RenderSystem.alphaFunc(516, 0.1f);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnable) {
        boolean bl2 = djz.A();
        if (!bl2) {
            runnable.run();
            return;
        }
        dkd \u26032 = djz.C().k;
        djt \u26033 = \u26032.f;
        \u26032.f = djt.b;
        runnable.run();
        \u26032.f = \u26033;
    }

    private static /* synthetic */ void lambda$setupGui3DDiffuseLighting$71(g g2, g g3) {
        dem.b(g2, g3);
    }

    private static /* synthetic */ void lambda$setupGuiFlatDiffuseLighting$70(g g2, g g3) {
        dem.a(g2, g3);
    }

    private static /* synthetic */ void lambda$setupLevelDiffuseLighting$69(g g2, g g3, b b2) {
        dem.a(g2, g3, b2);
    }

    private static /* synthetic */ void lambda$setupOverlayColor$68(IntSupplier intSupplier, int n2) {
        dem.k(intSupplier.getAsInt(), n2);
    }

    private static /* synthetic */ void lambda$glUniformMatrix4$67(int n2, boolean bl2, FloatBuffer floatBuffer) {
        dem.c(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix3$66(int n2, boolean bl2, FloatBuffer floatBuffer) {
        dem.b(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix2$65(int n2, boolean bl2, FloatBuffer floatBuffer) {
        dem.a(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$64(int n2, FloatBuffer floatBuffer) {
        dem.e(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$63(int n2, FloatBuffer floatBuffer) {
        dem.d(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$62(int n2, FloatBuffer floatBuffer) {
        dem.c(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$61(int n2, FloatBuffer floatBuffer) {
        dem.b(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$60(int n2, IntBuffer intBuffer) {
        dem.d(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$59(int n2, IntBuffer intBuffer) {
        dem.c(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$58(int n2, IntBuffer intBuffer) {
        dem.b(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$57(int n2, IntBuffer intBuffer) {
        dem.a(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1i$56(int n2, int n3) {
        dem.f(n2, n3);
    }

    private static /* synthetic */ void lambda$glDeleteBuffers$55(int n2) {
        dem.j(n2);
    }

    private static /* synthetic */ void lambda$glBindBuffer$54(int n2, Supplier supplier) {
        dem.g(n2, (Integer)supplier.get());
    }

    private static /* synthetic */ void lambda$glMultiTexCoord2f$53(int n2, float f2, float f3) {
        dem.a(n2, f2, f3);
    }

    private static /* synthetic */ void lambda$renderCrosshair$52(int n2) {
        GLX._renderCrosshair(n2, true, true, true);
    }

    private static /* synthetic */ void lambda$getString$51(int n2, Consumer consumer) {
        String string = dem.B(n2);
        consumer.accept(string);
    }

    private static /* synthetic */ void lambda$readPixels$50(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        dem.a(n2, n3, n4, n5, n6, n7, byteBuffer);
    }

    private static /* synthetic */ void lambda$pixelTransfer$49(int n2, float f2) {
        dem.b(n2, f2);
    }

    private static /* synthetic */ void lambda$pixelStore$48(int n2, int n3) {
        dem.n(n2, n3);
    }

    private static /* synthetic */ void lambda$lineWidth$47(float f2) {
        dem.d(f2);
    }

    private static /* synthetic */ void lambda$drawArrays$46(int n2, int n3, int n4) {
        dem.f(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$color3f$45(float f2, float f3, float f4) {
        dem.d(f2, f3, f4, 1.0f);
    }

    private static /* synthetic */ void lambda$color4f$44(float f2, float f3, float f4, float f5) {
        dem.d(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$multMatrix$43(b b2) {
        dem.a(b2);
    }

    private static /* synthetic */ void lambda$translated$42(double d2, double d3, double d4) {
        dem.b(d2, d3, d4);
    }

    private static /* synthetic */ void lambda$translatef$41(float f2, float f3, float f4) {
        dem.c(f2, f3, f4);
    }

    private static /* synthetic */ void lambda$scaled$40(double d2, double d3, double d4) {
        dem.a(d2, d3, d4);
    }

    private static /* synthetic */ void lambda$scalef$39(float f2, float f3, float f4) {
        dem.b(f2, f3, f4);
    }

    private static /* synthetic */ void lambda$rotatef$38(float f2, float f3, float f4, float f5) {
        dem.c(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$ortho$37(double d2, double d3, double d4, double d5, double d6, double d7) {
        dem.a(d2, d3, d4, d5, d6, d7);
    }

    private static /* synthetic */ void lambda$matrixMode$36(int n2) {
        dem.w(n2);
    }

    private static /* synthetic */ void lambda$clear$35(int n2, boolean bl2) {
        dem.a(n2, bl2);
    }

    private static /* synthetic */ void lambda$clearStencil$34(int n2) {
        dem.v(n2);
    }

    private static /* synthetic */ void lambda$clearColor$33(float f2, float f3, float f4, float f5) {
        dem.b(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$clearDepth$32(double d2) {
        dem.a(d2);
    }

    private static /* synthetic */ void lambda$stencilOp$31(int n2, int n3, int n4) {
        dem.e(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$stencilMask$30(int n2) {
        dem.u(n2);
    }

    private static /* synthetic */ void lambda$stencilFunc$29(int n2, int n3, int n4) {
        dem.d(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$colorMask$28(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        dem.a(bl2, bl3, bl4, bl5);
    }

    private static /* synthetic */ void lambda$viewport$27(int n2, int n3, int n4, int n5) {
        dem.d(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$shadeModel$26(int n2) {
        dem.t(n2);
    }

    private static /* synthetic */ void lambda$bindTexture$25(int n2) {
        dem.s(n2);
    }

    private static /* synthetic */ void lambda$deleteTexture$24(int n2) {
        dem.r(n2);
    }

    private static /* synthetic */ void lambda$texParameter$23(int n2, int n3, int n4) {
        dem.b(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$activeTexture$22(int n2) {
        dem.q(n2);
    }

    private static /* synthetic */ void lambda$logicOp$21(dem.o o2) {
        dem.p(o2.q);
    }

    private static /* synthetic */ void lambda$polygonOffset$20(float f2, float f3) {
        dem.a(f2, f3);
    }

    private static /* synthetic */ void lambda$polygonMode$19(int n2, int n3) {
        dem.m(n2, n3);
    }

    private static /* synthetic */ void lambda$fogi$18(int n2, int n3) {
        dem.l(n2, n3);
    }

    private static /* synthetic */ void lambda$fog$17(int n2, float f2, float f3, float f4, float f5) {
        dem.a(n2, new float[]{f2, f3, f4, f5});
    }

    private static /* synthetic */ void lambda$fogEnd$16(float f2) {
        dem.c(f2);
    }

    private static /* synthetic */ void lambda$fogStart$15(float f2) {
        dem.b(f2);
    }

    private static /* synthetic */ void lambda$fogDensity$14(float f2) {
        dem.a(f2);
    }

    private static /* synthetic */ void lambda$fogMode$13(int n2) {
        dem.o(n2);
    }

    private static /* synthetic */ void lambda$fogMode$12(dem.m m2) {
        dem.o(m2.d);
    }

    private static /* synthetic */ void lambda$blendColor$11(float f2, float f3, float f4, float f5) {
        dem.a(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$blendEquation$10(int n2) {
        dem.c(n2);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$9(int n2, int n3, int n4, int n5) {
        dem.b(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$8(dem.r r2, dem.j j2, dem.r r3, dem.j j3) {
        dem.b(r2.p, j2.o, r3.p, j3.o);
    }

    private static /* synthetic */ void lambda$blendFunc$7(int n2, int n3) {
        dem.b(n2, n3);
    }

    private static /* synthetic */ void lambda$blendFunc$6(dem.r r2, dem.j j2) {
        dem.b(r2.p, j2.o);
    }

    private static /* synthetic */ void lambda$depthMask$5(boolean bl2) {
        dem.a(bl2);
    }

    private static /* synthetic */ void lambda$depthFunc$4(int n2) {
        dem.b(n2);
    }

    private static /* synthetic */ void lambda$enableScissor$3(int n2, int n3, int n4, int n5) {
        dem.k();
        dem.a(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$normal3f$2(float f2, float f3, float f4) {
        dem.a(f2, f3, f4);
    }

    private static /* synthetic */ void lambda$colorMaterial$1(int n2, int n3) {
        dem.a(n2, n3);
    }

    private static /* synthetic */ void lambda$alphaFunc$0(int n2, float f2) {
        dem.a(n2, f2);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
    }
}

