/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.providers.DefaultGlyphProvider;
import net.minecraft.client.gui.fonts.providers.GlyphProviderTypes;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FontResourceManager
implements AutoCloseable {
    private static final Logger field_211509_a = LogManager.getLogger();
    public static final ResourceLocation field_238544_a_ = new ResourceLocation("minecraft", "missing");
    private final Font field_238545_c_;
    private final Map<ResourceLocation, Font> field_238546_d_ = Maps.newHashMap();
    private final TextureManager field_211511_c;
    private Map<ResourceLocation, ResourceLocation> field_238547_f_ = ImmutableMap.of();
    private final IFutureReloadListener field_216889_f = new ReloadListener<Map<ResourceLocation, List<IGlyphProvider>>>(){

        @Override
        protected Map<ResourceLocation, List<IGlyphProvider>> func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler2) {
            IProfiler iProfiler2;
            iProfiler2.func_219894_a();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            HashMap \u26032 = Maps.newHashMap();
            for (ResourceLocation resourceLocation2 : iResourceManager.func_199003_a("font", string -> string.endsWith(".json"))) {
                String string2 = resourceLocation2.func_110623_a();
                ResourceLocation \u26033 = new ResourceLocation(resourceLocation2.func_110624_b(), string2.substring("font/".length(), string2.length() - ".json".length()));
                List \u26034 = \u26032.computeIfAbsent(\u26033, resourceLocation -> Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()}));
                iProfiler2.func_194340_a(\u26033::toString);
                try {
                    for (IResource iResource : iResourceManager.func_199004_b(resourceLocation2)) {
                        iProfiler2.func_194340_a(iResource::func_199026_d);
                        try (Closeable closeable = iResource.func_199027_b();
                             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)closeable, StandardCharsets.UTF_8));){
                            iProfiler2.func_76320_a("reading");
                            JsonArray jsonArray = JSONUtils.func_151214_t(JSONUtils.func_193839_a(gson, bufferedReader, JsonObject.class), "providers");
                            iProfiler2.func_219895_b("parsing");
                            for (int i = jsonArray.size() - 1; i >= 0; --i) {
                                JsonObject jsonObject = JSONUtils.func_151210_l(jsonArray.get(i), "providers[" + i + "]");
                                try {
                                    String string3 = JSONUtils.func_151200_h(jsonObject, "type");
                                    GlyphProviderTypes \u26035 = GlyphProviderTypes.func_211638_a(string3);
                                    iProfiler2.func_76320_a(string3);
                                    IGlyphProvider \u26036 = \u26035.func_211637_a(jsonObject).func_211246_a(iResourceManager);
                                    if (\u26036 != null) {
                                        \u26034.add(\u26036);
                                    }
                                    iProfiler2.func_76319_b();
                                    continue;
                                }
                                catch (RuntimeException runtimeException) {
                                    field_211509_a.warn("Unable to read definition '{}' in fonts.json in resourcepack: '{}': {}", (Object)\u26033, (Object)iResource.func_199026_d(), (Object)runtimeException.getMessage());
                                }
                            }
                            iProfiler2.func_76319_b();
                        }
                        catch (RuntimeException runtimeException) {
                            field_211509_a.warn("Unable to load font '{}' in fonts.json in resourcepack: '{}': {}", (Object)\u26033, (Object)iResource.func_199026_d(), (Object)runtimeException.getMessage());
                        }
                        iProfiler2.func_76319_b();
                    }
                }
                catch (IOException iOException) {
                    field_211509_a.warn("Unable to load font '{}' in fonts.json: {}", (Object)\u26033, (Object)iOException.getMessage());
                }
                iProfiler2.func_76320_a("caching");
                IntOpenHashSet intOpenHashSet = new IntOpenHashSet();
                for (Closeable closeable : \u26034) {
                    intOpenHashSet.addAll((IntCollection)closeable.func_230428_a_());
                }
                intOpenHashSet.forEach(n -> {
                    if (n == 32) {
                        return;
                    }
                    Iterator iterator = Lists.reverse((List)\u26034).iterator();
                    while (iterator.hasNext() && (\u2603 = (IGlyphProvider)iterator.next()).func_212248_a(n) == null) {
                    }
                });
                iProfiler2.func_76319_b();
                iProfiler2.func_76319_b();
            }
            iProfiler2.func_219897_b();
            return \u26032;
        }

        @Override
        protected void func_212853_a_(Map<ResourceLocation, List<IGlyphProvider>> map, IResourceManager iResourceManager, IProfiler iProfiler) {
            iProfiler.func_219894_a();
            iProfiler.func_76320_a("closing");
            FontResourceManager.this.field_238546_d_.values().forEach(Font::close);
            FontResourceManager.this.field_238546_d_.clear();
            iProfiler.func_219895_b("reloading");
            map.forEach((resourceLocation, list) -> {
                Font font = new Font(FontResourceManager.this.field_211511_c, (ResourceLocation)resourceLocation);
                font.func_211570_a(Lists.reverse((List)list));
                FontResourceManager.this.field_238546_d_.put(resourceLocation, font);
            });
            iProfiler.func_76319_b();
            iProfiler.func_219897_b();
        }

        @Override
        public String func_225594_i_() {
            return "FontManager";
        }

        @Override
        protected /* synthetic */ Object func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
            return this.func_212854_a_(iResourceManager, iProfiler);
        }
    };

    public FontResourceManager(TextureManager textureManager) {
        this.field_211511_c = textureManager;
        this.field_238545_c_ = Util.func_200696_a(new Font(textureManager, field_238544_a_), font -> font.func_211570_a(Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()})));
    }

    public void func_238551_a_(Map<ResourceLocation, ResourceLocation> map) {
        this.field_238547_f_ = map;
    }

    public FontRenderer func_238548_a_() {
        return new FontRenderer(resourceLocation -> this.field_238546_d_.getOrDefault(this.field_238547_f_.getOrDefault(resourceLocation, (ResourceLocation)resourceLocation), this.field_238545_c_));
    }

    public IFutureReloadListener func_216884_a() {
        return this.field_216889_f;
    }

    @Override
    public void close() {
        this.field_238546_d_.values().forEach(Font::close);
        this.field_238545_c_.close();
    }
}

