/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;

public class GamemodeSelectionScreen
extends Screen {
    private static final ResourceLocation field_238703_a_ = new ResourceLocation("textures/gui/container/gamemode_switcher.png");
    private static final int field_238704_b_ = Mode.values().length * 30 - 5;
    private static final ITextComponent field_238705_c_ = new TranslationTextComponent("debug.gamemodes.select_next", new TranslationTextComponent("debug.gamemodes.press_f4").func_240699_a_(TextFormatting.AQUA));
    private final Optional<Mode> field_238706_p_;
    private Optional<Mode> field_238707_q_ = Optional.empty();
    private int field_238708_r_;
    private int field_238709_s_;
    private boolean field_238710_t_;
    private final List<SelectorWidget> field_238711_u_ = Lists.newArrayList();

    public GamemodeSelectionScreen() {
        super(NarratorChatListener.field_216868_a);
        this.field_238706_p_ = Mode.func_238731_b_(this.func_241608_k_());
    }

    private GameType func_241608_k_() {
        GameType gameType = Minecraft.func_71410_x().field_71442_b.func_178889_l();
        \u2603 = Minecraft.func_71410_x().field_71442_b.func_241822_k();
        if (\u2603 == GameType.NOT_SET) {
            \u2603 = gameType == GameType.CREATIVE ? GameType.SURVIVAL : GameType.CREATIVE;
        }
        return \u2603;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_238707_q_ = this.field_238706_p_.isPresent() ? this.field_238706_p_ : Mode.func_238731_b_(this.field_230706_i_.field_71442_b.func_178889_l());
        for (int i = 0; i < Mode.field_238721_e_.length; ++i) {
            Mode mode = Mode.field_238721_e_[i];
            this.field_238711_u_.add(new SelectorWidget(mode, this.field_230708_k_ / 2 - field_238704_b_ / 2 + i * 30, this.field_230709_l_ / 2 - 30));
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        if (this.func_238718_l_()) {
            return;
        }
        matrixStack.func_227860_a_();
        RenderSystem.enableBlend();
        this.field_230706_i_.func_110434_K().func_110577_a(field_238703_a_);
        int n3 = this.field_230708_k_ / 2 - 62;
        \u2603 = this.field_230709_l_ / 2 - 30 - 27;
        GamemodeSelectionScreen.func_238463_a_(matrixStack, n3, \u2603, 0.0f, 0.0f, 125, 75, 128, 128);
        matrixStack.func_227865_b_();
        super.func_230430_a_(matrixStack, n, n2, f);
        this.field_238707_q_.ifPresent(mode -> GamemodeSelectionScreen.func_238472_a_(matrixStack, this.field_230712_o_, ((Mode)mode).func_238725_a_(), this.field_230708_k_ / 2, this.field_230709_l_ / 2 - 30 - 20, -1));
        GamemodeSelectionScreen.func_238472_a_(matrixStack, this.field_230712_o_, field_238705_c_, this.field_230708_k_ / 2, this.field_230709_l_ / 2 + 5, 0xFFFFFF);
        if (!this.field_238710_t_) {
            this.field_238708_r_ = n;
            this.field_238709_s_ = n2;
            this.field_238710_t_ = true;
        }
        boolean \u26032 = this.field_238708_r_ == n && this.field_238709_s_ == n2;
        for (SelectorWidget selectorWidget : this.field_238711_u_) {
            selectorWidget.func_230430_a_(matrixStack, n, n2, f);
            this.field_238707_q_.ifPresent(mode -> selectorWidget.func_238741_e_(mode == selectorWidget.field_238736_b_));
            if (\u26032 || !selectorWidget.func_230449_g_()) continue;
            this.field_238707_q_ = Optional.of(selectorWidget.field_238736_b_);
        }
    }

    private void func_238717_j_() {
        GamemodeSelectionScreen.func_238713_a_(this.field_230706_i_, this.field_238707_q_);
    }

    private static void func_238713_a_(Minecraft minecraft, Optional<Mode> optional) {
        if (minecraft.field_71442_b == null || minecraft.field_71439_g == null || !optional.isPresent()) {
            return;
        }
        Optional optional2 = Mode.func_238731_b_(minecraft.field_71442_b.func_178889_l());
        Mode \u26032 = optional.get();
        if (optional2.isPresent() && minecraft.field_71439_g.func_211513_k(2) && \u26032 != optional2.get()) {
            minecraft.field_71439_g.func_71165_d(\u26032.func_238730_b_());
        }
    }

    private boolean func_238718_l_() {
        if (!InputMappings.func_216506_a(this.field_230706_i_.func_228018_at_().func_198092_i(), 292)) {
            this.func_238717_j_();
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 293 && this.field_238707_q_.isPresent()) {
            this.field_238710_t_ = false;
            this.field_238707_q_ = this.field_238707_q_.get().func_238733_c_();
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    public class SelectorWidget
    extends Widget {
        private final Mode field_238736_b_;
        private boolean field_238737_c_;

        public SelectorWidget(Mode mode, int n, int n2) {
            super(n, n2, 25, 25, mode.func_238725_a_());
            this.field_238736_b_ = mode;
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int n, int n2, float f) {
            Minecraft minecraft = Minecraft.func_71410_x();
            this.func_238738_a_(matrixStack, minecraft.func_110434_K());
            this.field_238736_b_.func_238729_a_(GamemodeSelectionScreen.this.field_230707_j_, this.field_230690_l_ + 5, this.field_230691_m_ + 5);
            if (this.field_238737_c_) {
                this.func_238740_b_(matrixStack, minecraft.func_110434_K());
            }
        }

        @Override
        public boolean func_230449_g_() {
            return super.func_230449_g_() || this.field_238737_c_;
        }

        public void func_238741_e_(boolean bl) {
            this.field_238737_c_ = bl;
            this.func_230997_f_();
        }

        private void func_238738_a_(MatrixStack matrixStack, TextureManager textureManager) {
            textureManager.func_110577_a(field_238703_a_);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(this.field_230690_l_, this.field_230691_m_, 0.0);
            SelectorWidget.func_238463_a_(matrixStack, 0, 0, 0.0f, 75.0f, 25, 25, 128, 128);
            matrixStack.func_227865_b_();
        }

        private void func_238740_b_(MatrixStack matrixStack, TextureManager textureManager) {
            textureManager.func_110577_a(field_238703_a_);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(this.field_230690_l_, this.field_230691_m_, 0.0);
            SelectorWidget.func_238463_a_(matrixStack, 0, 0, 25.0f, 75.0f, 25, 25, 128, 128);
            matrixStack.func_227865_b_();
        }
    }

    static enum Mode {
        CREATIVE(new TranslationTextComponent("gameMode.creative"), "/gamemode creative", new ItemStack(Blocks.field_196658_i)),
        SURVIVAL(new TranslationTextComponent("gameMode.survival"), "/gamemode survival", new ItemStack(Items.field_151040_l)),
        ADVENTURE(new TranslationTextComponent("gameMode.adventure"), "/gamemode adventure", new ItemStack(Items.field_151148_bJ)),
        SPECTATOR(new TranslationTextComponent("gameMode.spectator"), "/gamemode spectator", new ItemStack(Items.field_151061_bv));

        protected static final Mode[] field_238721_e_;
        final ITextComponent field_238722_f_;
        final String field_238723_g_;
        final ItemStack field_238724_h_;

        private Mode(ITextComponent iTextComponent, String string2, ItemStack itemStack) {
            this.field_238722_f_ = iTextComponent;
            this.field_238723_g_ = string2;
            this.field_238724_h_ = itemStack;
        }

        private void func_238729_a_(ItemRenderer itemRenderer, int n, int n2) {
            itemRenderer.func_180450_b(this.field_238724_h_, n, n2);
        }

        private ITextComponent func_238725_a_() {
            return this.field_238722_f_;
        }

        private String func_238730_b_() {
            return this.field_238723_g_;
        }

        private Optional<Mode> func_238733_c_() {
            switch (this) {
                case CREATIVE: {
                    return Optional.of(SURVIVAL);
                }
                case SURVIVAL: {
                    return Optional.of(ADVENTURE);
                }
                case ADVENTURE: {
                    return Optional.of(SPECTATOR);
                }
            }
            return Optional.of(CREATIVE);
        }

        private static Optional<Mode> func_238731_b_(GameType gameType) {
            switch (gameType) {
                case SPECTATOR: {
                    return Optional.of(SPECTATOR);
                }
                case SURVIVAL: {
                    return Optional.of(SURVIVAL);
                }
                case CREATIVE: {
                    return Optional.of(CREATIVE);
                }
                case ADVENTURE: {
                    return Optional.of(ADVENTURE);
                }
            }
            return Optional.empty();
        }

        static {
            field_238721_e_ = Mode.values();
        }
    }
}

