/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AccessibilityScreen;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.LanguageScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.MultiplayerWarningScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsBridgeScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainMenuScreen
extends Screen {
    private static final Logger field_238656_b_ = LogManager.getLogger();
    public static final RenderSkyboxCube field_213098_a = new RenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation field_213099_c = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation field_213100_d = new ResourceLocation("textures/gui/accessibility.png");
    private final boolean field_213101_e;
    @Nullable
    private String field_73975_c;
    private Button field_73973_d;
    private static final ResourceLocation field_110352_y = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation field_194400_H = new ResourceLocation("textures/gui/title/edition.png");
    private boolean field_183502_L;
    private Screen field_183503_M;
    private int field_193978_M;
    private int field_193979_N;
    private final RenderSkybox field_209101_K = new RenderSkybox(field_213098_a);
    private final boolean field_213102_y;
    private long field_213103_z;

    public MainMenuScreen() {
        this(false);
    }

    public MainMenuScreen(boolean bl) {
        super(new TranslationTextComponent("narrator.screen.title"));
        this.field_213102_y = bl;
        this.field_213101_e = (double)new Random().nextFloat() < 1.0E-4;
    }

    private boolean func_183501_a() {
        return this.field_230706_i_.field_71474_y.field_183509_X && this.field_183503_M != null;
    }

    @Override
    public void func_231023_e_() {
        if (this.func_183501_a()) {
            this.field_183503_M.func_231023_e_();
        }
    }

    public static CompletableFuture<Void> func_213097_a(TextureManager textureManager, Executor executor) {
        return CompletableFuture.allOf(textureManager.func_215268_a(field_110352_y, executor), textureManager.func_215268_a(field_194400_H, executor), textureManager.func_215268_a(field_213099_c, executor), field_213098_a.func_217617_a(textureManager, executor));
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public boolean func_231178_ax__() {
        return false;
    }

    @Override
    protected void func_231160_c_() {
        if (this.field_73975_c == null) {
            this.field_73975_c = this.field_230706_i_.func_213269_at().func_215276_a();
        }
        this.field_193978_M = this.field_230712_o_.func_78256_a("Copyright Mojang AB. Do not distribute!");
        this.field_193979_N = this.field_230708_k_ - this.field_193978_M - 2;
        int n = 24;
        \u2603 = this.field_230709_l_ / 4 + 48;
        if (this.field_230706_i_.func_71355_q()) {
            this.func_73972_b(\u2603, 24);
        } else {
            this.func_73969_a(\u2603, 24);
        }
        this.func_230480_a_(new ImageButton(this.field_230708_k_ / 2 - 124, \u2603 + 72 + 12, 20, 20, 0, 106, 20, Button.field_230687_i_, 256, 256, button -> this.field_230706_i_.func_147108_a(new LanguageScreen((Screen)this, this.field_230706_i_.field_71474_y, this.field_230706_i_.func_135016_M())), new TranslationTextComponent("narrator.button.language")));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, \u2603 + 72 + 12, 98, 20, new TranslationTextComponent("menu.options"), button -> this.field_230706_i_.func_147108_a(new OptionsScreen(this, this.field_230706_i_.field_71474_y))));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 2, \u2603 + 72 + 12, 98, 20, new TranslationTextComponent("menu.quit"), button -> this.field_230706_i_.func_71400_g()));
        this.func_230480_a_(new ImageButton(this.field_230708_k_ / 2 + 104, \u2603 + 72 + 12, 20, 20, 0, 0, 20, field_213100_d, 32, 64, button -> this.field_230706_i_.func_147108_a(new AccessibilityScreen(this, this.field_230706_i_.field_71474_y)), new TranslationTextComponent("narrator.button.accessibility")));
        this.field_230706_i_.func_181537_a(false);
        if (this.field_230706_i_.field_71474_y.field_183509_X && !this.field_183502_L) {
            RealmsBridgeScreen realmsBridgeScreen = new RealmsBridgeScreen();
            this.field_183503_M = realmsBridgeScreen.func_239555_b_(this);
            this.field_183502_L = true;
        }
        if (this.func_183501_a()) {
            this.field_183503_M.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }

    private void func_73969_a(int n3, int n4) {
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, n3, 200, 20, new TranslationTextComponent("menu.singleplayer"), button -> this.field_230706_i_.func_147108_a(new WorldSelectionScreen(this))));
        boolean bl = this.field_230706_i_.func_238216_r_();
        Button.ITooltip \u26032 = bl ? Button.field_238486_s_ : (button, matrixStack, n, n2) -> {
            if (!button.field_230693_o_) {
                this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_(new TranslationTextComponent("title.multiplayer.disabled"), Math.max(this.field_230708_k_ / 2 - 43, 170)), n, n2);
            }
        };
        this.func_230480_a_(new Button((int)(this.field_230708_k_ / 2 - 100), (int)(n3 + n4 * 1), (int)200, (int)20, (ITextComponent)new TranslationTextComponent((String)"menu.multiplayer"), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, func_213095_c(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((MainMenuScreen)this), (Button.ITooltip)\u26032)).field_230693_o_ = bl;
        this.func_230480_a_(new Button((int)(this.field_230708_k_ / 2 - 100), (int)(n3 + n4 * 2), (int)200, (int)20, (ITextComponent)new TranslationTextComponent((String)"menu.online"), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, func_238661_c_(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((MainMenuScreen)this), (Button.ITooltip)\u26032)).field_230693_o_ = bl;
    }

    private void func_73972_b(int n, int n2) {
        boolean bl = this.func_243319_k();
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, n, 200, 20, new TranslationTextComponent("menu.playdemo"), button -> {
            if (bl) {
                this.field_230706_i_.func_238191_a_("Demo_World");
            } else {
                DynamicRegistries.Impl impl = DynamicRegistries.func_239770_b_();
                this.field_230706_i_.func_238192_a_("Demo_World", MinecraftServer.field_213219_c, impl, DimensionGeneratorSettings.func_242752_a(impl));
            }
        }));
        this.field_73973_d = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, n + n2 * 1, 200, 20, new TranslationTextComponent("menu.resetdemo"), button -> {
            SaveFormat saveFormat = this.field_230706_i_.func_71359_d();
            try (SaveFormat.LevelSave levelSave = saveFormat.func_237274_c_("Demo_World");){
                WorldSummary worldSummary = levelSave.func_237296_d_();
                if (worldSummary != null) {
                    this.field_230706_i_.func_147108_a(new ConfirmScreen(this::func_213087_a, new TranslationTextComponent("selectWorld.deleteQuestion"), new TranslationTextComponent("selectWorld.deleteWarning", worldSummary.func_75788_b()), new TranslationTextComponent("selectWorld.deleteButton"), DialogTexts.field_240633_d_));
                }
            }
            catch (IOException iOException) {
                SystemToast.func_238535_a_(this.field_230706_i_, "Demo_World");
                field_238656_b_.warn("Failed to access demo world", (Throwable)iOException);
            }
        }));
        this.field_73973_d.field_230693_o_ = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean func_243319_k() {
        try (SaveFormat.LevelSave levelSave = this.field_230706_i_.func_71359_d().func_237274_c_("Demo_World");){
            boolean bl = levelSave.func_237296_d_() != null;
            return bl;
        }
        catch (IOException iOException) {
            SystemToast.func_238535_a_(this.field_230706_i_, "Demo_World");
            field_238656_b_.warn("Failed to read demo world data", (Throwable)iOException);
            return false;
        }
    }

    private void func_140005_i() {
        RealmsBridgeScreen realmsBridgeScreen = new RealmsBridgeScreen();
        realmsBridgeScreen.func_231394_a_(this);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack2, int n3, int n4, float f) {
        MatrixStack matrixStack2;
        if (this.field_213103_z == 0L && this.field_213102_y) {
            this.field_213103_z = Util.func_211177_b();
        }
        \u2603 = this.field_213102_y ? (float)(Util.func_211177_b() - this.field_213103_z) / 1000.0f : 1.0f;
        MainMenuScreen.func_238467_a_(matrixStack2, 0, 0, this.field_230708_k_, this.field_230709_l_, -1);
        this.field_209101_K.func_217623_a(f, MathHelper.func_76131_a(\u2603, 0.0f, 1.0f));
        int n5 = 274;
        \u2603 = this.field_230708_k_ / 2 - 137;
        \u2603 = 30;
        this.field_230706_i_.func_110434_K().func_110577_a(field_213099_c);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, this.field_213102_y ? (float)MathHelper.func_76123_f(MathHelper.func_76131_a(\u2603, 0.0f, 1.0f)) : 1.0f);
        MainMenuScreen.func_238466_a_(matrixStack2, 0, 0, this.field_230708_k_, this.field_230709_l_, 0.0f, 0.0f, 16, 128, 16, 128);
        float \u26032 = this.field_213102_y ? MathHelper.func_76131_a(\u2603 - 1.0f, 0.0f, 1.0f) : 1.0f;
        \u2603 = MathHelper.func_76123_f(\u26032 * 255.0f) << 24;
        if ((\u2603 & 0xFC000000) == 0) {
            return;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_110352_y);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, \u26032);
        if (this.field_213101_e) {
            this.func_238459_a_(\u2603, 30, (n, n2) -> {
                this.func_238474_b_(matrixStack2, n + 0, (int)n2, 0, 0, 99, 44);
                this.func_238474_b_(matrixStack2, n + 99, (int)n2, 129, 0, 27, 44);
                this.func_238474_b_(matrixStack2, n + 99 + 26, (int)n2, 126, 0, 3, 44);
                this.func_238474_b_(matrixStack2, n + 99 + 26 + 3, (int)n2, 99, 0, 26, 44);
                this.func_238474_b_(matrixStack2, n + 155, (int)n2, 0, 45, 155, 44);
            });
        } else {
            this.func_238459_a_(\u2603, 30, (n, n2) -> {
                this.func_238474_b_(matrixStack2, n + 0, (int)n2, 0, 0, 155, 44);
                this.func_238474_b_(matrixStack2, n + 155, (int)n2, 0, 45, 155, 44);
            });
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_194400_H);
        MainMenuScreen.func_238463_a_(matrixStack2, \u2603 + 88, 67, 0.0f, 0.0f, 98, 14, 128, 16);
        if (this.field_73975_c != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef(this.field_230708_k_ / 2 + 90, 70.0f, 0.0f);
            RenderSystem.rotatef(-20.0f, 0.0f, 0.0f, 1.0f);
            float f2 = 1.8f - MathHelper.func_76135_e(MathHelper.func_76126_a((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2)) * 0.1f);
            f2 = f2 * 100.0f / (float)(this.field_230712_o_.func_78256_a(this.field_73975_c) + 32);
            RenderSystem.scalef(f2, f2, f2);
            MainMenuScreen.func_238471_a_(matrixStack2, this.field_230712_o_, this.field_73975_c, 0, -8, 0xFFFF00 | \u2603);
            RenderSystem.popMatrix();
        }
        String string = "Minecraft " + SharedConstants.func_215069_a().getName();
        string = this.field_230706_i_.func_71355_q() ? string + " Demo" : string + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d());
        if (this.field_230706_i_.func_230151_c_()) {
            string = string + I18n.func_135052_a("menu.modded", new Object[0]);
        }
        MainMenuScreen.func_238476_c_(matrixStack2, this.field_230712_o_, string, 2, this.field_230709_l_ - 10, 0xFFFFFF | \u2603);
        MainMenuScreen.func_238476_c_(matrixStack2, this.field_230712_o_, "Copyright Mojang AB. Do not distribute!", this.field_193979_N, this.field_230709_l_ - 10, 0xFFFFFF | \u2603);
        if (n3 > this.field_193979_N && n3 < this.field_193979_N + this.field_193978_M && n4 > this.field_230709_l_ - 10 && n4 < this.field_230709_l_) {
            MainMenuScreen.func_238467_a_(matrixStack2, this.field_193979_N, this.field_230709_l_ - 1, this.field_193979_N + this.field_193978_M, this.field_230709_l_, 0xFFFFFF | \u2603);
        }
        for (Widget widget : this.field_230710_m_) {
            widget.func_230986_a_(\u26032);
        }
        super.func_230430_a_(matrixStack2, n3, n4, f);
        if (this.func_183501_a() && \u26032 >= 1.0f) {
            this.field_183503_M.func_230430_a_(matrixStack2, n3, n4, f);
        }
    }

    @Override
    public boolean func_231044_a_(double d, double d2, int n) {
        if (super.func_231044_a_(d, d2, n)) {
            return true;
        }
        if (this.func_183501_a() && this.field_183503_M.func_231044_a_(d, d2, n)) {
            return true;
        }
        if (d > (double)this.field_193979_N && d < (double)(this.field_193979_N + this.field_193978_M) && d2 > (double)(this.field_230709_l_ - 10) && d2 < (double)this.field_230709_l_) {
            this.field_230706_i_.func_147108_a(new WinGameScreen(false, Runnables.doNothing()));
        }
        return false;
    }

    @Override
    public void func_231164_f_() {
        if (this.field_183503_M != null) {
            this.field_183503_M.func_231164_f_();
        }
    }

    private void func_213087_a(boolean bl) {
        if (bl) {
            try (SaveFormat.LevelSave levelSave = this.field_230706_i_.func_71359_d().func_237274_c_("Demo_World");){
                levelSave.func_237299_g_();
            }
            catch (IOException iOException) {
                SystemToast.func_238538_b_(this.field_230706_i_, "Demo_World");
                field_238656_b_.warn("Failed to delete demo world", (Throwable)iOException);
            }
        }
        this.field_230706_i_.func_147108_a(this);
    }

    private /* synthetic */ void func_238661_c_(Button button) {
        this.func_140005_i();
    }

    private /* synthetic */ void func_213095_c(Button button) {
        Screen screen = this.field_230706_i_.field_71474_y.field_230152_Z_ ? new MultiplayerScreen(this) : new MultiplayerWarningScreen(this);
        this.field_230706_i_.func_147108_a(screen);
    }
}

