/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network.login;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.login.IClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.server.SCustomPayloadLoginPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.CryptException;
import net.minecraft.util.CryptManager;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLoginNetHandler
implements IClientLoginNetHandler {
    private static final Logger field_147396_a = LogManager.getLogger();
    private final Minecraft field_147394_b;
    @Nullable
    private final Screen field_147395_c;
    private final Consumer<ITextComponent> field_209525_d;
    private final NetworkManager field_147393_d;
    private GameProfile field_175091_e;

    public ClientLoginNetHandler(NetworkManager networkManager, Minecraft minecraft, @Nullable Screen screen, Consumer<ITextComponent> consumer) {
        this.field_147393_d = networkManager;
        this.field_147394_b = minecraft;
        this.field_147395_c = screen;
        this.field_209525_d = consumer;
    }

    @Override
    public void func_147389_a(SEncryptionRequestPacket sEncryptionRequestPacket) {
        CEncryptionResponsePacket \u26036;
        Cipher \u26035;
        Cipher \u26034;
        String \u26033;
        try {
            SecretKey secretKey = CryptManager.func_75890_a();
            PublicKey \u26032 = sEncryptionRequestPacket.func_149608_d();
            \u26033 = new BigInteger(CryptManager.func_75895_a(sEncryptionRequestPacket.func_149609_c(), \u26032, secretKey)).toString(16);
            \u26034 = CryptManager.func_151229_a(2, secretKey);
            \u26035 = CryptManager.func_151229_a(1, secretKey);
            \u26036 = new CEncryptionResponsePacket(secretKey, \u26032, sEncryptionRequestPacket.func_149607_e());
        }
        catch (CryptException cryptException) {
            throw new IllegalStateException("Protocol error", cryptException);
        }
        this.field_209525_d.accept(new TranslationTextComponent("connect.authorizing"));
        HTTPUtil.field_180193_a.submit(() -> {
            ITextComponent iTextComponent = this.func_209522_a(\u26033);
            if (iTextComponent != null) {
                if (this.field_147394_b.func_147104_D() != null && this.field_147394_b.func_147104_D().func_181041_d()) {
                    field_147396_a.warn(iTextComponent.getString());
                } else {
                    this.field_147393_d.func_150718_a(iTextComponent);
                    return;
                }
            }
            this.field_209525_d.accept(new TranslationTextComponent("connect.encrypting"));
            this.field_147393_d.func_201058_a(\u26036, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.field_147393_d.func_244777_a(\u26034, \u26035)));
        });
    }

    @Nullable
    private ITextComponent func_209522_a(String string) {
        try {
            this.func_147391_c().joinServer(this.field_147394_b.func_110432_I().func_148256_e(), this.field_147394_b.func_110432_I().func_148254_d(), string);
        }
        catch (AuthenticationUnavailableException authenticationUnavailableException) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", new TranslationTextComponent("disconnect.loginFailedInfo.serversUnavailable"));
        }
        catch (InvalidCredentialsException invalidCredentialsException) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", new TranslationTextComponent("disconnect.loginFailedInfo.invalidSession"));
        }
        catch (InsufficientPrivilegesException insufficientPrivilegesException) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", new TranslationTextComponent("disconnect.loginFailedInfo.insufficientPrivileges"));
        }
        catch (AuthenticationException authenticationException) {
            return new TranslationTextComponent("disconnect.loginFailedInfo", authenticationException.getMessage());
        }
        return null;
    }

    private MinecraftSessionService func_147391_c() {
        return this.field_147394_b.func_152347_ac();
    }

    @Override
    public void func_147390_a(SLoginSuccessPacket sLoginSuccessPacket) {
        this.field_209525_d.accept(new TranslationTextComponent("connect.joining"));
        this.field_175091_e = sLoginSuccessPacket.func_179730_a();
        this.field_147393_d.func_150723_a(ProtocolType.PLAY);
        this.field_147393_d.func_150719_a(new ClientPlayNetHandler(this.field_147394_b, this.field_147395_c, this.field_147393_d, this.field_175091_e));
    }

    @Override
    public void func_147231_a(ITextComponent iTextComponent) {
        if (this.field_147395_c != null && this.field_147395_c instanceof RealmsScreen) {
            this.field_147394_b.func_147108_a(new DisconnectedRealmsScreen(this.field_147395_c, DialogTexts.field_244280_i, iTextComponent));
        } else {
            this.field_147394_b.func_147108_a(new DisconnectedScreen(this.field_147395_c, DialogTexts.field_244280_i, iTextComponent));
        }
    }

    @Override
    public NetworkManager func_147298_b() {
        return this.field_147393_d;
    }

    @Override
    public void func_147388_a(SDisconnectLoginPacket sDisconnectLoginPacket) {
        this.field_147393_d.func_150718_a(sDisconnectLoginPacket.func_149603_c());
    }

    @Override
    public void func_180464_a(SEnableCompressionPacket sEnableCompressionPacket) {
        if (!this.field_147393_d.func_150731_c()) {
            this.field_147393_d.func_179289_a(sEnableCompressionPacket.func_179731_a());
        }
    }

    @Override
    public void func_209521_a(SCustomPayloadLoginPacket sCustomPayloadLoginPacket) {
        this.field_209525_d.accept(new TranslationTextComponent("connect.negotiating"));
        this.field_147393_d.func_179290_a(new CCustomPayloadLoginPacket(sCustomPayloadLoginPacket.func_209918_a(), null));
    }
}

