/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockModelShapes {
    private final Map<BlockState, IBakedModel> field_178129_a = Maps.newIdentityHashMap();
    private final ModelManager field_178128_c;

    public BlockModelShapes(ModelManager modelManager) {
        this.field_178128_c = modelManager;
    }

    public TextureAtlasSprite func_178122_a(BlockState blockState) {
        return this.func_178125_b(blockState).func_177554_e();
    }

    public IBakedModel func_178125_b(BlockState blockState) {
        IBakedModel iBakedModel = this.field_178129_a.get(blockState);
        if (iBakedModel == null) {
            iBakedModel = this.field_178128_c.func_174951_a();
        }
        return iBakedModel;
    }

    public ModelManager func_178126_b() {
        return this.field_178128_c;
    }

    public void func_178124_c() {
        this.field_178129_a.clear();
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(blockState -> this.field_178129_a.put((BlockState)blockState, this.field_178128_c.func_174953_a(BlockModelShapes.func_209554_c(blockState))));
        }
    }

    public static ModelResourceLocation func_209554_c(BlockState blockState) {
        return BlockModelShapes.func_209553_a(Registry.field_212618_g.func_177774_c(blockState.func_177230_c()), blockState);
    }

    public static ModelResourceLocation func_209553_a(ResourceLocation resourceLocation, BlockState blockState) {
        return new ModelResourceLocation(resourceLocation, BlockModelShapes.func_209552_a(blockState.func_206871_b()));
    }

    public static String func_209552_a(Map<Property<?>, Comparable<?>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Property<?>, Comparable<?>> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            Property<?> property = entry.getKey();
            stringBuilder.append(property.func_177701_a());
            stringBuilder.append('=');
            stringBuilder.append(BlockModelShapes.func_209555_a(property, entry.getValue()));
        }
        return stringBuilder.toString();
    }

    private static <T extends Comparable<T>> String func_209555_a(Property<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }
}

