/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class ChunkRenderCache
implements IBlockDisplayReader {
    protected final int field_212400_a;
    protected final int field_212401_b;
    protected final BlockPos field_212402_c;
    protected final int field_212403_d;
    protected final int field_212404_e;
    protected final int field_212405_f;
    protected final Chunk[][] field_212406_g;
    protected final BlockState[] field_217340_h;
    protected final FluidState[] field_217341_i;
    protected final World field_212408_i;

    @Nullable
    public static ChunkRenderCache func_212397_a(World world, BlockPos blockPos3, BlockPos blockPos2, int n) {
        BlockPos blockPos3;
        int \u26032;
        \u2603 = blockPos3.func_177958_n() - n >> 4;
        \u2603 = blockPos3.func_177952_p() - n >> 4;
        \u2603 = blockPos2.func_177958_n() + n >> 4;
        \u2603 = blockPos2.func_177952_p() + n >> 4;
        Chunk[][] chunkArray = new Chunk[\u2603 - \u2603 + 1][\u2603 - \u2603 + 1];
        for (\u26032 = \u2603; \u26032 <= \u2603; ++\u26032) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                chunkArray[\u26032 - \u2603][\u2603 - \u2603] = world.func_212866_a_(\u26032, \u2603);
            }
        }
        if (ChunkRenderCache.func_241718_a_(blockPos3, blockPos2, \u2603, \u2603, chunkArray)) {
            return null;
        }
        \u26032 = 1;
        \u2603 = blockPos3.func_177982_a(-1, -1, -1);
        \u2603 = blockPos2.func_177982_a(1, 1, 1);
        return new ChunkRenderCache(world, \u2603, \u2603, chunkArray, \u2603, \u2603);
    }

    public static boolean func_241718_a_(BlockPos blockPos, BlockPos blockPos2, int n, int n2, Chunk[][] chunkArray) {
        for (int i = blockPos.func_177958_n() >> 4; i <= blockPos2.func_177958_n() >> 4; ++i) {
            for (\u2603 = blockPos.func_177952_p() >> 4; \u2603 <= blockPos2.func_177952_p() >> 4; ++\u2603) {
                Chunk chunk = chunkArray[i - n][\u2603 - n2];
                if (chunk.func_76606_c(blockPos.func_177956_o(), blockPos2.func_177956_o())) continue;
                return false;
            }
        }
        return true;
    }

    public ChunkRenderCache(World world, int n, int n2, Chunk[][] chunkArray, BlockPos blockPos, BlockPos blockPos2) {
        this.field_212408_i = world;
        this.field_212400_a = n;
        this.field_212401_b = n2;
        this.field_212406_g = chunkArray;
        this.field_212402_c = blockPos;
        this.field_212403_d = blockPos2.func_177958_n() - blockPos.func_177958_n() + 1;
        this.field_212404_e = blockPos2.func_177956_o() - blockPos.func_177956_o() + 1;
        this.field_212405_f = blockPos2.func_177952_p() - blockPos.func_177952_p() + 1;
        this.field_217340_h = new BlockState[this.field_212403_d * this.field_212404_e * this.field_212405_f];
        this.field_217341_i = new FluidState[this.field_212403_d * this.field_212404_e * this.field_212405_f];
        for (BlockPos blockPos3 : BlockPos.func_218278_a(blockPos, blockPos2)) {
            int n3 = (blockPos3.func_177958_n() >> 4) - n;
            \u2603 = (blockPos3.func_177952_p() >> 4) - n2;
            Chunk \u26032 = chunkArray[n3][\u2603];
            \u2603 = this.func_212398_a(blockPos3);
            this.field_217340_h[\u2603] = \u26032.func_180495_p(blockPos3);
            this.field_217341_i[\u2603] = \u26032.func_204610_c(blockPos3);
        }
    }

    protected final int func_212398_a(BlockPos blockPos) {
        return this.func_217339_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    protected int func_217339_a(int n, int n2, int n3) {
        \u2603 = n - this.field_212402_c.func_177958_n();
        \u2603 = n2 - this.field_212402_c.func_177956_o();
        \u2603 = n3 - this.field_212402_c.func_177952_p();
        return \u2603 * this.field_212403_d * this.field_212404_e + \u2603 * this.field_212403_d + \u2603;
    }

    @Override
    public BlockState func_180495_p(BlockPos blockPos) {
        return this.field_217340_h[this.func_212398_a(blockPos)];
    }

    @Override
    public FluidState func_204610_c(BlockPos blockPos) {
        return this.field_217341_i[this.func_212398_a(blockPos)];
    }

    @Override
    public float func_230487_a_(Direction direction, boolean bl) {
        return this.field_212408_i.func_230487_a_(direction, bl);
    }

    @Override
    public WorldLightManager func_225524_e_() {
        return this.field_212408_i.func_225524_e_();
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.func_212399_a(blockPos, Chunk.CreateEntityType.IMMEDIATE);
    }

    @Nullable
    public TileEntity func_212399_a(BlockPos blockPos, Chunk.CreateEntityType createEntityType) {
        int n = (blockPos.func_177958_n() >> 4) - this.field_212400_a;
        \u2603 = (blockPos.func_177952_p() >> 4) - this.field_212401_b;
        return this.field_212406_g[n][\u2603].func_177424_a(blockPos, createEntityType);
    }

    @Override
    public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        return this.field_212408_i.func_225525_a_(blockPos, colorResolver);
    }
}

