/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class TagRegistry<T> {
    private ITagCollection<T> field_232930_b_ = ITagCollection.func_242205_c();
    private final List<NamedTag<T>> field_232931_c_ = Lists.newArrayList();
    private final Function<ITagCollectionSupplier, ITagCollection<T>> field_242184_c;

    public TagRegistry(Function<ITagCollectionSupplier, ITagCollection<T>> function) {
        this.field_242184_c = function;
    }

    public ITag.INamedTag<T> func_232937_a_(String string) {
        NamedTag namedTag = new NamedTag(new ResourceLocation(string));
        this.field_232931_c_.add(namedTag);
        return namedTag;
    }

    public void func_232932_a_() {
        this.field_232930_b_ = ITagCollection.func_242205_c();
        Tag tag = Tag.func_241284_a_();
        this.field_232931_c_.forEach(namedTag -> namedTag.func_232943_a_(resourceLocation -> tag));
    }

    public void func_242188_a(ITagCollectionSupplier iTagCollectionSupplier) {
        ITagCollection iTagCollection = this.field_242184_c.apply(iTagCollectionSupplier);
        this.field_232930_b_ = iTagCollection;
        this.field_232931_c_.forEach(namedTag -> namedTag.func_232943_a_(iTagCollection::func_199910_a));
    }

    public ITagCollection<T> func_232939_b_() {
        return this.field_232930_b_;
    }

    public List<? extends ITag.INamedTag<T>> func_241288_c_() {
        return this.field_232931_c_;
    }

    public Set<ResourceLocation> func_242189_b(ITagCollectionSupplier iTagCollectionSupplier) {
        ITagCollection<T> iTagCollection = this.field_242184_c.apply(iTagCollectionSupplier);
        Set \u26032 = this.field_232931_c_.stream().map(NamedTag::func_230234_a_).collect(Collectors.toSet());
        ImmutableSet \u26033 = ImmutableSet.copyOf(iTagCollection.func_199908_a());
        return Sets.difference(\u26032, (Set)\u26033);
    }

    static class NamedTag<T>
    implements ITag.INamedTag<T> {
        @Nullable
        private ITag<T> field_232942_b_;
        protected final ResourceLocation field_232941_a_;

        private NamedTag(ResourceLocation resourceLocation) {
            this.field_232941_a_ = resourceLocation;
        }

        @Override
        public ResourceLocation func_230234_a_() {
            return this.field_232941_a_;
        }

        private ITag<T> func_232944_c_() {
            if (this.field_232942_b_ == null) {
                throw new IllegalStateException("Tag " + this.field_232941_a_ + " used before it was bound");
            }
            return this.field_232942_b_;
        }

        void func_232943_a_(Function<ResourceLocation, ITag<T>> function) {
            this.field_232942_b_ = function.apply(this.field_232941_a_);
        }

        @Override
        public boolean func_230235_a_(T t) {
            return this.func_232944_c_().func_230235_a_(t);
        }

        @Override
        public List<T> func_230236_b_() {
            return this.func_232944_c_().func_230236_b_();
        }
    }
}

