/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.ResourceLocation;

public class TagRegistryManager {
    private static final Map<ResourceLocation, TagRegistry<?>> field_242190_a = Maps.newHashMap();

    public static <T> TagRegistry<T> func_242196_a(ResourceLocation resourceLocation, Function<ITagCollectionSupplier, ITagCollection<T>> function) {
        TagRegistry<T> tagRegistry = new TagRegistry<T>(function);
        \u2603 = field_242190_a.putIfAbsent(resourceLocation, tagRegistry);
        if (\u2603 != null) {
            throw new IllegalStateException("Duplicate entry for static tag collection: " + resourceLocation);
        }
        return tagRegistry;
    }

    public static void func_242193_a(ITagCollectionSupplier iTagCollectionSupplier) {
        field_242190_a.values().forEach(tagRegistry -> tagRegistry.func_242188_a(iTagCollectionSupplier));
    }

    public static void func_242191_a() {
        field_242190_a.values().forEach(TagRegistry::func_232932_a_);
    }

    public static Multimap<ResourceLocation, ResourceLocation> func_242198_b(ITagCollectionSupplier iTagCollectionSupplier) {
        HashMultimap hashMultimap = HashMultimap.create();
        field_242190_a.forEach((arg_0, arg_1) -> TagRegistryManager.func_242195_a((Multimap)hashMultimap, iTagCollectionSupplier, arg_0, arg_1));
        return hashMultimap;
    }

    public static void func_242197_b() {
        TagRegistry[] tagRegistryArray = new TagRegistry[]{BlockTags.field_199899_c, ItemTags.field_199906_c, FluidTags.field_206961_c, EntityTypeTags.field_219766_c};
        boolean \u26032 = Stream.of(tagRegistryArray).anyMatch(tagRegistry -> !field_242190_a.containsValue(tagRegistry));
        if (\u26032) {
            throw new IllegalStateException("Missing helper registrations");
        }
    }

    private static /* synthetic */ void func_242195_a(Multimap multimap, ITagCollectionSupplier iTagCollectionSupplier, ResourceLocation resourceLocation, TagRegistry tagRegistry) {
        multimap.putAll((Object)resourceLocation, tagRegistry.func_242189_b(iTagCollectionSupplier));
    }
}

