/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootEntryManager;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSizeType;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IPosRuleTests;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Registry<T>
implements Codec<T>,
Keyable,
IObjectIntIterable<T> {
    protected static final Logger field_212616_e = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> field_218376_a = Maps.newLinkedHashMap();
    public static final ResourceLocation field_239706_f_ = new ResourceLocation("root");
    protected static final MutableRegistry<MutableRegistry<?>> field_239707_g_ = new SimpleRegistry(Registry.func_239741_a_("root"), Lifecycle.experimental());
    public static final Registry<? extends Registry<?>> field_212617_f = field_239707_g_;
    public static final RegistryKey<Registry<SoundEvent>> field_239708_i_ = Registry.func_239741_a_("sound_event");
    public static final RegistryKey<Registry<Fluid>> field_239709_j_ = Registry.func_239741_a_("fluid");
    public static final RegistryKey<Registry<Effect>> field_239710_k_ = Registry.func_239741_a_("mob_effect");
    public static final RegistryKey<Registry<Block>> field_239711_l_ = Registry.func_239741_a_("block");
    public static final RegistryKey<Registry<Enchantment>> field_239712_m_ = Registry.func_239741_a_("enchantment");
    public static final RegistryKey<Registry<EntityType<?>>> field_239713_n_ = Registry.func_239741_a_("entity_type");
    public static final RegistryKey<Registry<Item>> field_239714_o_ = Registry.func_239741_a_("item");
    public static final RegistryKey<Registry<Potion>> field_239715_p_ = Registry.func_239741_a_("potion");
    public static final RegistryKey<Registry<ParticleType<?>>> field_239664_B_ = Registry.func_239741_a_("particle_type");
    public static final RegistryKey<Registry<TileEntityType<?>>> field_239667_E_ = Registry.func_239741_a_("block_entity_type");
    public static final RegistryKey<Registry<PaintingType>> field_239668_F_ = Registry.func_239741_a_("motive");
    public static final RegistryKey<Registry<ResourceLocation>> field_239669_G_ = Registry.func_239741_a_("custom_stat");
    public static final RegistryKey<Registry<ChunkStatus>> field_239670_H_ = Registry.func_239741_a_("chunk_status");
    public static final RegistryKey<Registry<IRuleTestType<?>>> field_239673_K_ = Registry.func_239741_a_("rule_test");
    public static final RegistryKey<Registry<IPosRuleTests<?>>> field_239674_L_ = Registry.func_239741_a_("pos_rule_test");
    public static final RegistryKey<Registry<ContainerType<?>>> field_239677_O_ = Registry.func_239741_a_("menu");
    public static final RegistryKey<Registry<IRecipeType<?>>> field_239678_P_ = Registry.func_239741_a_("recipe_type");
    public static final RegistryKey<Registry<IRecipeSerializer<?>>> field_239679_Q_ = Registry.func_239741_a_("recipe_serializer");
    public static final RegistryKey<Registry<Attribute>> field_239680_R_ = Registry.func_239741_a_("attribute");
    public static final RegistryKey<Registry<StatType<?>>> field_239681_S_ = Registry.func_239741_a_("stat_type");
    public static final RegistryKey<Registry<VillagerType>> field_239682_T_ = Registry.func_239741_a_("villager_type");
    public static final RegistryKey<Registry<VillagerProfession>> field_239683_U_ = Registry.func_239741_a_("villager_profession");
    public static final RegistryKey<Registry<PointOfInterestType>> field_239684_V_ = Registry.func_239741_a_("point_of_interest_type");
    public static final RegistryKey<Registry<MemoryModuleType<?>>> field_239685_W_ = Registry.func_239741_a_("memory_module_type");
    public static final RegistryKey<Registry<SensorType<?>>> field_239686_X_ = Registry.func_239741_a_("sensor_type");
    public static final RegistryKey<Registry<Schedule>> field_239687_Y_ = Registry.func_239741_a_("schedule");
    public static final RegistryKey<Registry<Activity>> field_239688_Z_ = Registry.func_239741_a_("activity");
    public static final RegistryKey<Registry<LootPoolEntryType>> field_239695_aa_ = Registry.func_239741_a_("loot_pool_entry_type");
    public static final RegistryKey<Registry<LootFunctionType>> field_239696_ab_ = Registry.func_239741_a_("loot_function_type");
    public static final RegistryKey<Registry<LootConditionType>> field_239697_ac_ = Registry.func_239741_a_("loot_condition_type");
    public static final RegistryKey<Registry<DimensionType>> field_239698_ad_ = Registry.func_239741_a_("dimension_type");
    public static final RegistryKey<Registry<World>> field_239699_ae_ = Registry.func_239741_a_("dimension");
    public static final RegistryKey<Registry<Dimension>> field_239700_af_ = Registry.func_239741_a_("dimension");
    public static final Registry<SoundEvent> field_212633_v = Registry.func_239746_a_(field_239708_i_, () -> SoundEvents.field_187638_cR);
    public static final DefaultedRegistry<Fluid> field_212619_h = Registry.func_239745_a_(field_239709_j_, "empty", () -> Fluids.field_204541_a);
    public static final Registry<Effect> field_212631_t = Registry.func_239746_a_(field_239710_k_, () -> Effects.field_188425_z);
    public static final DefaultedRegistry<Block> field_212618_g = Registry.func_239745_a_(field_239711_l_, "air", () -> Blocks.field_150350_a);
    public static final Registry<Enchantment> field_212628_q = Registry.func_239746_a_(field_239712_m_, () -> Enchantments.field_185308_t);
    public static final DefaultedRegistry<EntityType<?>> field_212629_r = Registry.func_239745_a_(field_239713_n_, "pig", () -> EntityType.field_200784_X);
    public static final DefaultedRegistry<Item> field_212630_s = Registry.func_239745_a_(field_239714_o_, "air", () -> Items.field_190931_a);
    public static final DefaultedRegistry<Potion> field_212621_j = Registry.func_239745_a_(field_239715_p_, "empty", () -> Potions.field_185229_a);
    public static final Registry<ParticleType<?>> field_212632_u = Registry.func_239746_a_(field_239664_B_, () -> ParticleTypes.field_197611_d);
    public static final Registry<TileEntityType<?>> field_212626_o = Registry.func_239746_a_(field_239667_E_, () -> TileEntityType.field_200971_b);
    public static final DefaultedRegistry<PaintingType> field_212620_i = Registry.func_239745_a_(field_239668_F_, "kebab", () -> PaintingType.field_200843_b);
    public static final Registry<ResourceLocation> field_212623_l = Registry.func_239746_a_(field_239669_G_, () -> Stats.field_75953_u);
    public static final DefaultedRegistry<ChunkStatus> field_218360_A = Registry.func_239745_a_(field_239670_H_, "empty", () -> ChunkStatus.field_223226_a_);
    public static final Registry<IRuleTestType<?>> field_218363_D = Registry.func_239746_a_(field_239673_K_, () -> IRuleTestType.field_214911_b);
    public static final Registry<IPosRuleTests<?>> field_239691_aJ_ = Registry.func_239746_a_(field_239674_L_, () -> IPosRuleTests.field_237103_a_);
    public static final Registry<ContainerType<?>> field_218366_G = Registry.func_239746_a_(field_239677_O_, () -> ContainerType.field_221514_h);
    public static final Registry<IRecipeType<?>> field_218367_H = Registry.func_239746_a_(field_239678_P_, () -> IRecipeType.field_222149_a);
    public static final Registry<IRecipeSerializer<?>> field_218368_I = Registry.func_239746_a_(field_239679_Q_, () -> IRecipeSerializer.field_222158_b);
    public static final Registry<Attribute> field_239692_aP_ = Registry.func_239746_a_(field_239680_R_, () -> Attributes.field_233828_k_);
    public static final Registry<StatType<?>> field_212634_w = Registry.func_239746_a_(field_239681_S_, () -> Stats.field_75929_E);
    public static final DefaultedRegistry<VillagerType> field_218369_K = Registry.func_239745_a_(field_239682_T_, "plains", () -> VillagerType.field_221175_c);
    public static final DefaultedRegistry<VillagerProfession> field_218370_L = Registry.func_239745_a_(field_239683_U_, "none", () -> VillagerProfession.field_221151_a);
    public static final DefaultedRegistry<PointOfInterestType> field_218371_M = Registry.func_239745_a_(field_239684_V_, "unemployed", () -> PointOfInterestType.field_221054_b);
    public static final DefaultedRegistry<MemoryModuleType<?>> field_218372_N = Registry.func_239745_a_(field_239685_W_, "dummy", () -> MemoryModuleType.field_220940_a);
    public static final DefaultedRegistry<SensorType<?>> field_218373_O = Registry.func_239745_a_(field_239686_X_, "dummy", () -> SensorType.field_220997_a);
    public static final Registry<Schedule> field_218374_P = Registry.func_239746_a_(field_239687_Y_, () -> Schedule.field_221383_a);
    public static final Registry<Activity> field_218375_Q = Registry.func_239746_a_(field_239688_Z_, () -> Activity.field_221366_b);
    public static final Registry<LootPoolEntryType> field_239693_aY_ = Registry.func_239746_a_(field_239695_aa_, () -> LootEntryManager.field_237410_a_);
    public static final Registry<LootFunctionType> field_239694_aZ_ = Registry.func_239746_a_(field_239696_ab_, () -> LootFunctionManager.field_237429_b_);
    public static final Registry<LootConditionType> field_239704_ba_ = Registry.func_239746_a_(field_239697_ac_, () -> LootConditionManager.field_237458_a_);
    public static final RegistryKey<Registry<DimensionSettings>> field_243549_ar = Registry.func_239741_a_("worldgen/noise_settings");
    public static final RegistryKey<Registry<ConfiguredSurfaceBuilder<?>>> field_243550_as = Registry.func_239741_a_("worldgen/configured_surface_builder");
    public static final RegistryKey<Registry<ConfiguredCarver<?>>> field_243551_at = Registry.func_239741_a_("worldgen/configured_carver");
    public static final RegistryKey<Registry<ConfiguredFeature<?, ?>>> field_243552_au = Registry.func_239741_a_("worldgen/configured_feature");
    public static final RegistryKey<Registry<StructureFeature<?, ?>>> field_243553_av = Registry.func_239741_a_("worldgen/configured_structure_feature");
    public static final RegistryKey<Registry<StructureProcessorList>> field_243554_aw = Registry.func_239741_a_("worldgen/processor_list");
    public static final RegistryKey<Registry<JigsawPattern>> field_243555_ax = Registry.func_239741_a_("worldgen/template_pool");
    public static final RegistryKey<Registry<Biome>> field_239720_u_ = Registry.func_239741_a_("worldgen/biome");
    public static final RegistryKey<Registry<SurfaceBuilder<?>>> field_239717_r_ = Registry.func_239741_a_("worldgen/surface_builder");
    public static final Registry<SurfaceBuilder<?>> field_218378_p = Registry.func_239746_a_(field_239717_r_, () -> SurfaceBuilder.field_215396_G);
    public static final RegistryKey<Registry<WorldCarver<?>>> field_239716_q_ = Registry.func_239741_a_("worldgen/carver");
    public static final Registry<WorldCarver<?>> field_218377_o = Registry.func_239746_a_(field_239716_q_, () -> WorldCarver.field_222709_a);
    public static final RegistryKey<Registry<Feature<?>>> field_239718_s_ = Registry.func_239741_a_("worldgen/feature");
    public static final Registry<Feature<?>> field_218379_q = Registry.func_239746_a_(field_239718_s_, () -> Feature.field_202290_aj);
    public static final RegistryKey<Registry<Structure<?>>> field_239671_I_ = Registry.func_239741_a_("worldgen/structure_feature");
    public static final Registry<Structure<?>> field_218361_B = Registry.func_239746_a_(field_239671_I_, () -> Structure.field_236367_c_);
    public static final RegistryKey<Registry<IStructurePieceType>> field_239672_J_ = Registry.func_239741_a_("worldgen/structure_piece");
    public static final Registry<IStructurePieceType> field_218362_C = Registry.func_239746_a_(field_239672_J_, () -> IStructurePieceType.field_214782_c);
    public static final RegistryKey<Registry<Placement<?>>> field_239719_t_ = Registry.func_239741_a_("worldgen/decorator");
    public static final Registry<Placement<?>> field_218380_r = Registry.func_239746_a_(field_239719_t_, () -> Placement.field_215022_h);
    public static final RegistryKey<Registry<BlockStateProviderType<?>>> field_239721_v_ = Registry.func_239741_a_("worldgen/block_state_provider_type");
    public static final RegistryKey<Registry<BlockPlacerType<?>>> field_239722_w_ = Registry.func_239741_a_("worldgen/block_placer_type");
    public static final RegistryKey<Registry<FoliagePlacerType<?>>> field_239723_x_ = Registry.func_239741_a_("worldgen/foliage_placer_type");
    public static final RegistryKey<Registry<TrunkPlacerType<?>>> field_239724_y_ = Registry.func_239741_a_("worldgen/trunk_placer_type");
    public static final RegistryKey<Registry<TreeDecoratorType<?>>> field_239725_z_ = Registry.func_239741_a_("worldgen/tree_decorator_type");
    public static final RegistryKey<Registry<FeatureSizeType<?>>> field_239663_A_ = Registry.func_239741_a_("worldgen/feature_size_type");
    public static final RegistryKey<Registry<Codec<? extends BiomeProvider>>> field_239665_C_ = Registry.func_239741_a_("worldgen/biome_source");
    public static final RegistryKey<Registry<Codec<? extends ChunkGenerator>>> field_239666_D_ = Registry.func_239741_a_("worldgen/chunk_generator");
    public static final RegistryKey<Registry<IStructureProcessorType<?>>> field_239675_M_ = Registry.func_239741_a_("worldgen/structure_processor");
    public static final RegistryKey<Registry<IJigsawDeserializer<?>>> field_239676_N_ = Registry.func_239741_a_("worldgen/structure_pool_element");
    public static final Registry<BlockStateProviderType<?>> field_229387_t_ = Registry.func_239746_a_(field_239721_v_, () -> BlockStateProviderType.field_227394_a_);
    public static final Registry<BlockPlacerType<?>> field_229388_u_ = Registry.func_239746_a_(field_239722_w_, () -> BlockPlacerType.field_227259_a_);
    public static final Registry<FoliagePlacerType<?>> field_229389_v_ = Registry.func_239746_a_(field_239723_x_, () -> FoliagePlacerType.field_227386_a_);
    public static final Registry<TrunkPlacerType<?>> field_239701_aw_ = Registry.func_239746_a_(field_239724_y_, () -> TrunkPlacerType.field_236920_a_);
    public static final Registry<TreeDecoratorType<?>> field_229390_w_ = Registry.func_239746_a_(field_239725_z_, () -> TreeDecoratorType.field_227426_b_);
    public static final Registry<FeatureSizeType<?>> field_239702_ay_ = Registry.func_239746_a_(field_239663_A_, () -> FeatureSizeType.field_236711_a_);
    public static final Registry<Codec<? extends BiomeProvider>> field_239689_aA_ = Registry.func_239742_a_(field_239665_C_, Lifecycle.stable(), () -> BiomeProvider.field_235202_a_);
    public static final Registry<Codec<? extends ChunkGenerator>> field_239690_aB_ = Registry.func_239742_a_(field_239666_D_, Lifecycle.stable(), () -> ChunkGenerator.field_235948_a_);
    public static final Registry<IStructureProcessorType<?>> field_218364_E = Registry.func_239746_a_(field_239675_M_, () -> IStructureProcessorType.field_214920_b);
    public static final Registry<IJigsawDeserializer<?>> field_218365_F = Registry.func_239746_a_(field_239676_N_, () -> IJigsawDeserializer.field_214931_e);
    private final RegistryKey<? extends Registry<T>> field_239703_b_;
    private final Lifecycle field_239705_c_;

    private static <T> RegistryKey<Registry<T>> func_239741_a_(String string) {
        return RegistryKey.func_240904_a_(new ResourceLocation(string));
    }

    public static <T extends MutableRegistry<?>> void func_239738_a_(MutableRegistry<T> mutableRegistry) {
        mutableRegistry.forEach(mutableRegistry2 -> {
            if (mutableRegistry2.func_148742_b().isEmpty()) {
                field_212616_e.error("Registry '{}' was empty after loading", (Object)mutableRegistry.func_177774_c(mutableRegistry2));
                if (SharedConstants.field_206244_b) {
                    throw new IllegalStateException("Registry: '" + mutableRegistry.func_177774_c(mutableRegistry2) + "' is empty, not allowed, fix me!");
                }
            }
            if (mutableRegistry2 instanceof DefaultedRegistry) {
                ResourceLocation resourceLocation = ((DefaultedRegistry)mutableRegistry2).func_212609_b();
                Validate.notNull(mutableRegistry2.func_82594_a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + resourceLocation), (Object[])new Object[0]);
            }
        });
    }

    private static <T> Registry<T> func_239746_a_(RegistryKey<? extends Registry<T>> registryKey, Supplier<T> supplier) {
        return Registry.func_239742_a_(registryKey, Lifecycle.experimental(), supplier);
    }

    private static <T> DefaultedRegistry<T> func_239745_a_(RegistryKey<? extends Registry<T>> registryKey, String string, Supplier<T> supplier) {
        return Registry.func_239744_a_(registryKey, string, Lifecycle.experimental(), supplier);
    }

    private static <T> Registry<T> func_239742_a_(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Supplier<T> supplier) {
        return Registry.func_239743_a_(registryKey, new SimpleRegistry(registryKey, lifecycle), supplier, lifecycle);
    }

    private static <T> DefaultedRegistry<T> func_239744_a_(RegistryKey<? extends Registry<T>> registryKey, String string, Lifecycle lifecycle, Supplier<T> supplier) {
        return Registry.func_239743_a_(registryKey, new DefaultedRegistry(string, registryKey, lifecycle), supplier, lifecycle);
    }

    private static <T, R extends MutableRegistry<T>> R func_239743_a_(RegistryKey<? extends Registry<T>> registryKey, R r, Supplier<T> supplier, Lifecycle lifecycle) {
        ResourceLocation resourceLocation = registryKey.func_240901_a_();
        field_218376_a.put(resourceLocation, supplier);
        MutableRegistry<MutableRegistry<?>> \u26032 = field_239707_g_;
        return \u26032.func_218381_a(registryKey, r, lifecycle);
    }

    protected Registry(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle) {
        this.field_239703_b_ = registryKey;
        this.field_239705_c_ = lifecycle;
    }

    public RegistryKey<? extends Registry<T>> func_243578_f() {
        return this.field_239703_b_;
    }

    public String toString() {
        return "Registry[" + this.field_239703_b_ + " (" + this.field_239705_c_ + ")]";
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> dynamicOps, U u) {
        if (dynamicOps.compressMaps()) {
            return dynamicOps.getNumberValue(u).flatMap(number -> {
                Object object = this.func_148745_a(number.intValue());
                if (object == null) {
                    return DataResult.error((String)("Unknown registry id: " + number));
                }
                return DataResult.success((Object)object, (Lifecycle)this.func_241876_d(object));
            }).map(object -> Pair.of((Object)object, (Object)dynamicOps.empty()));
        }
        return ResourceLocation.field_240908_a_.decode(dynamicOps, u).flatMap(pair -> {
            T t = this.func_82594_a((ResourceLocation)pair.getFirst());
            if (t == null) {
                return DataResult.error((String)("Unknown registry key: " + pair.getFirst()));
            }
            return DataResult.success((Object)Pair.of(t, (Object)pair.getSecond()), (Lifecycle)this.func_241876_d(t));
        });
    }

    public <U> DataResult<U> encode(T t, DynamicOps<U> dynamicOps, U u) {
        ResourceLocation resourceLocation = this.func_177774_c(t);
        if (resourceLocation == null) {
            return DataResult.error((String)("Unknown registry element " + t));
        }
        if (dynamicOps.compressMaps()) {
            return dynamicOps.mergeToPrimitive(u, dynamicOps.createInt(this.func_148757_b(t))).setLifecycle(this.field_239705_c_);
        }
        return dynamicOps.mergeToPrimitive(u, dynamicOps.createString(resourceLocation.toString())).setLifecycle(this.field_239705_c_);
    }

    public <U> Stream<U> keys(DynamicOps<U> dynamicOps) {
        return this.func_148742_b().stream().map(resourceLocation -> dynamicOps.createString(resourceLocation.toString()));
    }

    @Nullable
    public abstract ResourceLocation func_177774_c(T var1);

    public abstract Optional<RegistryKey<T>> func_230519_c_(T var1);

    @Override
    public abstract int func_148757_b(@Nullable T var1);

    @Nullable
    public abstract T func_230516_a_(@Nullable RegistryKey<T> var1);

    @Nullable
    public abstract T func_82594_a(@Nullable ResourceLocation var1);

    protected abstract Lifecycle func_241876_d(T var1);

    public abstract Lifecycle func_241875_b();

    public Optional<T> func_241873_b(@Nullable ResourceLocation resourceLocation) {
        return Optional.ofNullable(this.func_82594_a(resourceLocation));
    }

    public Optional<T> func_243575_c(@Nullable RegistryKey<T> registryKey) {
        return Optional.ofNullable(this.func_230516_a_(registryKey));
    }

    public T func_243576_d(RegistryKey<T> registryKey) {
        T t = this.func_230516_a_(registryKey);
        if (t == null) {
            throw new IllegalStateException("Missing: " + registryKey);
        }
        return t;
    }

    public abstract Set<ResourceLocation> func_148742_b();

    public abstract Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_();

    public Stream<T> func_201756_e() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public abstract boolean func_212607_c(ResourceLocation var1);

    public static <T> T func_218325_a(Registry<? super T> registry, String string, T t) {
        return Registry.func_218322_a(registry, new ResourceLocation(string), t);
    }

    public static <V, T extends V> T func_218322_a(Registry<V> registry, ResourceLocation resourceLocation, T t) {
        return ((MutableRegistry)registry).func_218381_a(RegistryKey.func_240903_a_(registry.field_239703_b_, resourceLocation), t, Lifecycle.stable());
    }

    public static <V, T extends V> T func_218343_a(Registry<V> registry, int n, String string, T t) {
        return ((MutableRegistry)registry).func_218382_a(n, RegistryKey.func_240903_a_(registry.field_239703_b_, new ResourceLocation(string)), t, Lifecycle.stable());
    }

    static {
        WorldGenRegistries.func_243661_a();
        field_218376_a.forEach((? super K resourceLocation, ? super V supplier) -> {
            if (supplier.get() == null) {
                field_212616_e.error("Unable to bootstrap registry '{}'", resourceLocation);
            }
        });
        Registry.func_239738_a_(field_239707_g_);
    }
}

