/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.network.play.server.SEntityHeadLookPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SEntityPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SEntityTeleportPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrackedEntity {
    private static final Logger field_219459_a = LogManager.getLogger();
    private final ServerWorld field_219460_b;
    private final Entity field_219461_c;
    private final int field_219462_d;
    private final boolean field_219463_e;
    private final Consumer<IPacket<?>> field_219464_f;
    private long field_219465_g;
    private long field_219466_h;
    private long field_219467_i;
    private int field_219468_j;
    private int field_219469_k;
    private int field_219470_l;
    private Vector3d field_219471_m = Vector3d.field_186680_a;
    private int field_219472_n;
    private int field_219473_o;
    private List<Entity> field_219474_p = Collections.emptyList();
    private boolean field_219475_q;
    private boolean field_219476_r;

    public TrackedEntity(ServerWorld serverWorld, Entity entity, int n, boolean bl, Consumer<IPacket<?>> consumer) {
        this.field_219460_b = serverWorld;
        this.field_219464_f = consumer;
        this.field_219461_c = entity;
        this.field_219462_d = n;
        this.field_219463_e = bl;
        this.func_219458_d();
        this.field_219468_j = MathHelper.func_76141_d(entity.field_70177_z * 256.0f / 360.0f);
        this.field_219469_k = MathHelper.func_76141_d(entity.field_70125_A * 256.0f / 360.0f);
        this.field_219470_l = MathHelper.func_76141_d(entity.func_70079_am() * 256.0f / 360.0f);
        this.field_219476_r = entity.func_233570_aj_();
    }

    /*
     * WARNING - void declaration
     */
    public void func_219453_a() {
        List<Entity> list = this.field_219461_c.func_184188_bt();
        if (!list.equals(this.field_219474_p)) {
            this.field_219474_p = list;
            this.field_219464_f.accept(new SSetPassengersPacket(this.field_219461_c));
        }
        if (this.field_219461_c instanceof ItemFrameEntity && this.field_219472_n % 10 == 0) {
            ItemFrameEntity itemFrameEntity = (ItemFrameEntity)this.field_219461_c;
            ItemStack \u26032 = itemFrameEntity.func_82335_i();
            if (\u26032.func_77973_b() instanceof FilledMapItem) {
                MapData \u26033 = FilledMapItem.func_195950_a(\u26032, this.field_219460_b);
                for (ServerPlayerEntity serverPlayerEntity : this.field_219460_b.func_217369_A()) {
                    \u26033.func_76191_a(serverPlayerEntity, \u26032);
                    IPacket<?> iPacket = ((FilledMapItem)\u26032.func_77973_b()).func_150911_c(\u26032, this.field_219460_b, serverPlayerEntity);
                    if (iPacket == null) continue;
                    serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
                }
            }
            this.func_219457_c();
        }
        if (this.field_219472_n % this.field_219462_d == 0 || this.field_219461_c.field_70160_al || this.field_219461_c.func_184212_Q().func_187223_a()) {
            int n;
            if (this.field_219461_c.func_184218_aH()) {
                int n2 = MathHelper.func_76141_d(this.field_219461_c.field_70177_z * 256.0f / 360.0f);
                int n3 = MathHelper.func_76141_d(this.field_219461_c.field_70125_A * 256.0f / 360.0f);
                boolean bl = \u2603 = Math.abs(n2 - this.field_219468_j) >= 1 || Math.abs(n3 - this.field_219469_k) >= 1;
                if (\u2603) {
                    this.field_219464_f.accept(new SEntityPacket.LookPacket(this.field_219461_c.func_145782_y(), (byte)n2, (byte)n3, this.field_219461_c.func_233570_aj_()));
                    this.field_219468_j = n2;
                    this.field_219469_k = n3;
                }
                this.func_219458_d();
                this.func_219457_c();
                this.field_219475_q = true;
            } else {
                void var6_17;
                Vector3d vector3d;
                double d;
                ++this.field_219473_o;
                n = MathHelper.func_76141_d(this.field_219461_c.field_70177_z * 256.0f / 360.0f);
                \u2603 = MathHelper.func_76141_d(this.field_219461_c.field_70125_A * 256.0f / 360.0f);
                Vector3d \u26037 = this.field_219461_c.func_213303_ch().func_178788_d(SEntityPacket.func_218744_a(this.field_219465_g, this.field_219466_h, this.field_219467_i));
                boolean \u26034 = \u26037.func_189985_c() >= 7.62939453125E-6;
                Object var6_12 = null;
                boolean \u26036 = \u26034 || this.field_219472_n % 60 == 0;
                boolean bl = \u2603 = Math.abs(n - this.field_219468_j) >= 1 || Math.abs(\u2603 - this.field_219469_k) >= 1;
                if (this.field_219472_n > 0 || this.field_219461_c instanceof AbstractArrowEntity) {
                    long l = SEntityPacket.func_218743_a(\u26037.field_72450_a);
                    long l2 = SEntityPacket.func_218743_a(\u26037.field_72448_b);
                    \u2603 = SEntityPacket.func_218743_a(\u26037.field_72449_c);
                    boolean bl2 = \u2603 = l < -32768L || l > 32767L || l2 < -32768L || l2 > 32767L || \u2603 < -32768L || \u2603 > 32767L;
                    if (\u2603 || this.field_219473_o > 400 || this.field_219475_q || this.field_219476_r != this.field_219461_c.func_233570_aj_()) {
                        this.field_219476_r = this.field_219461_c.func_233570_aj_();
                        this.field_219473_o = 0;
                        SEntityTeleportPacket sEntityTeleportPacket = new SEntityTeleportPacket(this.field_219461_c);
                    } else if (\u26036 && \u2603 || this.field_219461_c instanceof AbstractArrowEntity) {
                        SEntityPacket.MovePacket movePacket = new SEntityPacket.MovePacket(this.field_219461_c.func_145782_y(), (short)l, (short)l2, (short)\u2603, (byte)n, (byte)\u2603, this.field_219461_c.func_233570_aj_());
                    } else if (\u26036) {
                        SEntityPacket.RelativeMovePacket relativeMovePacket = new SEntityPacket.RelativeMovePacket(this.field_219461_c.func_145782_y(), (short)l, (short)l2, (short)\u2603, this.field_219461_c.func_233570_aj_());
                    } else if (\u2603) {
                        SEntityPacket.LookPacket lookPacket = new SEntityPacket.LookPacket(this.field_219461_c.func_145782_y(), (byte)n, (byte)\u2603, this.field_219461_c.func_233570_aj_());
                    }
                }
                if ((this.field_219463_e || this.field_219461_c.field_70160_al || this.field_219461_c instanceof LivingEntity && ((LivingEntity)this.field_219461_c).func_184613_cA()) && this.field_219472_n > 0 && ((d = (vector3d = this.field_219461_c.func_213322_ci()).func_72436_e(this.field_219471_m)) > 1.0E-7 || d > 0.0 && vector3d.func_189985_c() == 0.0)) {
                    this.field_219471_m = vector3d;
                    this.field_219464_f.accept(new SEntityVelocityPacket(this.field_219461_c.func_145782_y(), this.field_219471_m));
                }
                if (var6_17 != null) {
                    this.field_219464_f.accept((IPacket<?>)var6_17);
                }
                this.func_219457_c();
                if (\u26036) {
                    this.func_219458_d();
                }
                if (\u2603) {
                    this.field_219468_j = n;
                    this.field_219469_k = \u2603;
                }
                this.field_219475_q = false;
            }
            n = MathHelper.func_76141_d(this.field_219461_c.func_70079_am() * 256.0f / 360.0f);
            if (Math.abs(n - this.field_219470_l) >= 1) {
                this.field_219464_f.accept(new SEntityHeadLookPacket(this.field_219461_c, (byte)n));
                this.field_219470_l = n;
            }
            this.field_219461_c.field_70160_al = false;
        }
        ++this.field_219472_n;
        if (this.field_219461_c.field_70133_I) {
            this.func_219451_a(new SEntityVelocityPacket(this.field_219461_c));
            this.field_219461_c.field_70133_I = false;
        }
    }

    public void func_219454_a(ServerPlayerEntity serverPlayerEntity) {
        this.field_219461_c.func_184203_c(serverPlayerEntity);
        serverPlayerEntity.func_152339_d(this.field_219461_c);
    }

    public void func_219455_b(ServerPlayerEntity serverPlayerEntity) {
        this.func_219452_a(serverPlayerEntity.field_71135_a::func_147359_a);
        this.field_219461_c.func_184178_b(serverPlayerEntity);
        serverPlayerEntity.func_184848_d(this.field_219461_c);
    }

    public void func_219452_a(Consumer<IPacket<?>> consumer2) {
        Consumer<IPacket<?>> consumer2;
        Object object;
        if (this.field_219461_c.field_70128_L) {
            field_219459_a.warn("Fetching packet for removed entity " + this.field_219461_c);
        }
        IPacket<?> iPacket = this.field_219461_c.func_213297_N();
        this.field_219470_l = MathHelper.func_76141_d(this.field_219461_c.func_70079_am() * 256.0f / 360.0f);
        consumer2.accept(iPacket);
        if (!this.field_219461_c.func_184212_Q().func_187228_d()) {
            consumer2.accept(new SEntityMetadataPacket(this.field_219461_c.func_145782_y(), this.field_219461_c.func_184212_Q(), true));
        }
        boolean \u26032 = this.field_219463_e;
        if (this.field_219461_c instanceof LivingEntity) {
            object = ((LivingEntity)this.field_219461_c).func_233645_dx_().func_233789_b_();
            if (!object.isEmpty()) {
                consumer2.accept(new SEntityPropertiesPacket(this.field_219461_c.func_145782_y(), (Collection<ModifiableAttributeInstance>)object));
            }
            if (((LivingEntity)this.field_219461_c).func_184613_cA()) {
                \u26032 = true;
            }
        }
        this.field_219471_m = this.field_219461_c.func_213322_ci();
        if (\u26032 && !(iPacket instanceof SSpawnMobPacket)) {
            consumer2.accept(new SEntityVelocityPacket(this.field_219461_c.func_145782_y(), this.field_219471_m));
        }
        if (this.field_219461_c instanceof LivingEntity) {
            object = Lists.newArrayList();
            for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
                ItemStack itemStack = ((LivingEntity)this.field_219461_c).func_184582_a(equipmentSlotType);
                if (itemStack.func_190926_b()) continue;
                object.add(Pair.of((Object)((Object)equipmentSlotType), (Object)itemStack.func_77946_l()));
            }
            if (!object.isEmpty()) {
                consumer2.accept(new SEntityEquipmentPacket(this.field_219461_c.func_145782_y(), (List<Pair<EquipmentSlotType, ItemStack>>)object));
            }
        }
        if (this.field_219461_c instanceof LivingEntity) {
            object = (LivingEntity)this.field_219461_c;
            for (EffectInstance effectInstance : ((LivingEntity)object).func_70651_bq()) {
                consumer2.accept(new SPlayEntityEffectPacket(this.field_219461_c.func_145782_y(), effectInstance));
            }
        }
        if (!this.field_219461_c.func_184188_bt().isEmpty()) {
            consumer2.accept(new SSetPassengersPacket(this.field_219461_c));
        }
        if (this.field_219461_c.func_184218_aH()) {
            consumer2.accept(new SSetPassengersPacket(this.field_219461_c.func_184187_bx()));
        }
        if (this.field_219461_c instanceof MobEntity && ((MobEntity)(object = (MobEntity)this.field_219461_c)).func_110167_bD()) {
            consumer2.accept(new SMountEntityPacket((Entity)object, ((MobEntity)object).func_110166_bE()));
        }
    }

    private void func_219457_c() {
        EntityDataManager entityDataManager = this.field_219461_c.func_184212_Q();
        if (entityDataManager.func_187223_a()) {
            this.func_219451_a(new SEntityMetadataPacket(this.field_219461_c.func_145782_y(), entityDataManager, false));
        }
        if (this.field_219461_c instanceof LivingEntity) {
            Set<ModifiableAttributeInstance> set = ((LivingEntity)this.field_219461_c).func_233645_dx_().func_233778_a_();
            if (!set.isEmpty()) {
                this.func_219451_a(new SEntityPropertiesPacket(this.field_219461_c.func_145782_y(), set));
            }
            set.clear();
        }
    }

    private void func_219458_d() {
        this.field_219465_g = SEntityPacket.func_218743_a(this.field_219461_c.func_226277_ct_());
        this.field_219466_h = SEntityPacket.func_218743_a(this.field_219461_c.func_226278_cu_());
        this.field_219467_i = SEntityPacket.func_218743_a(this.field_219461_c.func_226281_cx_());
    }

    public Vector3d func_219456_b() {
        return SEntityPacket.func_218744_a(this.field_219465_g, this.field_219466_h, this.field_219467_i);
    }

    private void func_219451_a(IPacket<?> iPacket) {
        this.field_219464_f.accept(iPacket);
        if (this.field_219461_c instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)this.field_219461_c).field_71135_a.func_147359_a(iPacket);
        }
    }
}

