/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Biome {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final Codec<Biome> field_242418_b = RecordCodecBuilder.create(instance -> instance.group((App)Climate.field_242459_a.forGetter(biome -> biome.field_242423_j), (App)Category.field_235102_r_.fieldOf("category").forGetter(biome -> biome.field_201877_au), (App)Codec.FLOAT.fieldOf("depth").forGetter(biome -> Float.valueOf(biome.field_76748_D)), (App)Codec.FLOAT.fieldOf("scale").forGetter(biome -> Float.valueOf(biome.field_76749_E)), (App)BiomeAmbience.field_235204_a_.fieldOf("effects").forGetter(biome -> biome.field_235052_p_), (App)BiomeGenerationSettings.field_242481_c.forGetter(biome -> biome.field_242424_k), (App)MobSpawnInfo.field_242552_c.forGetter(biome -> biome.field_242425_l)).apply((Applicative)instance, Biome::new));
    public static final Codec<Biome> field_242419_c = RecordCodecBuilder.create(instance -> instance.group((App)Climate.field_242459_a.forGetter(biome -> biome.field_242423_j), (App)Category.field_235102_r_.fieldOf("category").forGetter(biome -> biome.field_201877_au), (App)Codec.FLOAT.fieldOf("depth").forGetter(biome -> Float.valueOf(biome.field_76748_D)), (App)Codec.FLOAT.fieldOf("scale").forGetter(biome -> Float.valueOf(biome.field_76749_E)), (App)BiomeAmbience.field_235204_a_.fieldOf("effects").forGetter(biome -> biome.field_235052_p_)).apply((Applicative)instance, (climate, category, f, f2, biomeAmbience) -> new Biome((Climate)climate, (Category)category, f.floatValue(), f2.floatValue(), (BiomeAmbience)biomeAmbience, BiomeGenerationSettings.field_242480_b, MobSpawnInfo.field_242551_b)));
    public static final Codec<Supplier<Biome>> field_235051_b_ = RegistryKeyCodec.func_241794_a_(Registry.field_239720_u_, field_242418_b);
    public static final Codec<List<Supplier<Biome>>> field_242420_e = RegistryKeyCodec.func_244328_b(Registry.field_239720_u_, field_242418_b);
    private final Map<Integer, List<Structure<?>>> field_242421_g = Registry.field_218361_B.func_201756_e().collect(Collectors.groupingBy(structure -> structure.func_236396_f_().ordinal()));
    private static final PerlinNoiseGenerator field_150605_ac = new PerlinNoiseGenerator(new SharedSeedRandom(1234L), (List<Integer>)ImmutableList.of((Object)0));
    private static final PerlinNoiseGenerator field_242422_i = new PerlinNoiseGenerator(new SharedSeedRandom(3456L), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    public static final PerlinNoiseGenerator field_180281_af = new PerlinNoiseGenerator(new SharedSeedRandom(2345L), (List<Integer>)ImmutableList.of((Object)0));
    private final Climate field_242423_j;
    private final BiomeGenerationSettings field_242424_k;
    private final MobSpawnInfo field_242425_l;
    private final float field_76748_D;
    private final float field_76749_E;
    private final Category field_201877_au;
    private final BiomeAmbience field_235052_p_;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> field_225488_v = ThreadLocal.withInitial(() -> Util.func_199748_a(() -> {
        Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int n) {
            }
        };
        long2FloatLinkedOpenHashMap.defaultReturnValue(Float.NaN);
        return long2FloatLinkedOpenHashMap;
    }));

    private Biome(Climate climate, Category category, float f, float f2, BiomeAmbience biomeAmbience, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.field_242423_j = climate;
        this.field_242424_k = biomeGenerationSettings;
        this.field_242425_l = mobSpawnInfo;
        this.field_201877_au = category;
        this.field_76748_D = f;
        this.field_76749_E = f2;
        this.field_235052_p_ = biomeAmbience;
    }

    public int func_225529_c_() {
        return this.field_235052_p_.func_242527_d();
    }

    public MobSpawnInfo func_242433_b() {
        return this.field_242425_l;
    }

    public RainType func_201851_b() {
        return this.field_242423_j.field_242460_b;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    private float func_242437_b(BlockPos blockPos) {
        float f = this.field_242423_j.field_242462_d.func_241852_a(blockPos, this.func_242445_k());
        if (blockPos.func_177956_o() > 64) {
            \u2603 = (float)(field_150605_ac.func_215464_a((float)blockPos.func_177958_n() / 8.0f, (float)blockPos.func_177952_p() / 8.0f, false) * 4.0);
            return f - (\u2603 + (float)blockPos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return f;
    }

    public final float func_225486_c(BlockPos blockPos) {
        long l = blockPos.func_218275_a();
        Long2FloatLinkedOpenHashMap \u26032 = this.field_225488_v.get();
        float \u26033 = \u26032.get(l);
        if (!Float.isNaN(\u26033)) {
            return \u26033;
        }
        float \u26034 = this.func_242437_b(blockPos);
        if (\u26032.size() == 1024) {
            \u26032.removeFirstFloat();
        }
        \u26032.put(l, \u26034);
        return \u26034;
    }

    public boolean func_201848_a(IWorldReader iWorldReader, BlockPos blockPos) {
        return this.func_201854_a(iWorldReader, blockPos, true);
    }

    public boolean func_201854_a(IWorldReader iWorldReader, BlockPos blockPos, boolean bl) {
        if (this.func_225486_c(blockPos) >= 0.15f) {
            return false;
        }
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReader.func_226658_a_(LightType.BLOCK, blockPos) < 10) {
            BlockState blockState = iWorldReader.func_180495_p(blockPos);
            FluidState \u26032 = iWorldReader.func_204610_c(blockPos);
            if (\u26032.func_206886_c() == Fluids.field_204546_a && blockState.func_177230_c() instanceof FlowingFluidBlock) {
                if (!bl) {
                    return true;
                }
                boolean bl2 = \u2603 = iWorldReader.func_201671_F(blockPos.func_177976_e()) && iWorldReader.func_201671_F(blockPos.func_177974_f()) && iWorldReader.func_201671_F(blockPos.func_177978_c()) && iWorldReader.func_201671_F(blockPos.func_177968_d());
                if (!\u2603) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader iWorldReader, BlockPos blockPos) {
        if (this.func_225486_c(blockPos) >= 0.15f) {
            return false;
        }
        return blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReader.func_226658_a_(LightType.BLOCK, blockPos) < 10 && (\u2603 = iWorldReader.func_180495_p(blockPos)).func_196958_f() && Blocks.field_150433_aE.func_176223_P().func_196955_c(iWorldReader, blockPos);
    }

    public BiomeGenerationSettings func_242440_e() {
        return this.field_242424_k;
    }

    public void func_242427_a(StructureManager structureManager, ChunkGenerator chunkGenerator, WorldGenRegion worldGenRegion, long l, SharedSeedRandom sharedSeedRandom, BlockPos blockPos) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> list = this.field_242424_k.func_242498_c();
        int \u26032 = GenerationStage.Decoration.values().length;
        for (int i = 0; i < \u26032; ++i) {
            int n;
            n = 0;
            if (structureManager.func_235005_a_()) {
                List list2 = this.field_242421_g.getOrDefault(i, Collections.emptyList());
                for (Object object : list2) {
                    sharedSeedRandom.func_202426_b(l, n, i);
                    int n2 = blockPos.func_177958_n() >> 4;
                    \u2603 = blockPos.func_177952_p() >> 4;
                    \u2603 = n2 << 4;
                    \u2603 = \u2603 << 4;
                    try {
                        structureManager.func_235011_a_(SectionPos.func_218167_a(blockPos), (Structure<?>)object).forEach(structureStart -> structureStart.func_230366_a_(worldGenRegion, structureManager, chunkGenerator, sharedSeedRandom, new MutableBoundingBox(\u2603, \u2603, \u2603 + 15, \u2603 + 15), new ChunkPos(n2, \u2603)));
                    }
                    catch (Exception \u26033) {
                        CrashReport crashReport = CrashReport.func_85055_a(\u26033, "Feature placement");
                        crashReport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218361_B.func_177774_c((Structure<?>)object)).func_189529_a("Description", () -> Biome.func_242431_a((Structure)object));
                        throw new ReportedException(crashReport);
                    }
                    ++n;
                }
            }
            if (list.size() <= i) continue;
            for (Supplier<ConfiguredFeature<?, ?>> supplier : list.get(i)) {
                Object object;
                object = supplier.get();
                sharedSeedRandom.func_202426_b(l, n, i);
                try {
                    ((ConfiguredFeature)object).func_242765_a(worldGenRegion, chunkGenerator, sharedSeedRandom, blockPos);
                }
                catch (Exception \u26034) {
                    CrashReport crashReport = CrashReport.func_85055_a(\u26034, "Feature placement");
                    crashReport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218379_q.func_177774_c((Feature<?>)((ConfiguredFeature)object).field_222737_a)).func_71507_a("Config", ((ConfiguredFeature)object).field_222738_b).func_189529_a("Description", () -> Biome.func_242430_a((ConfiguredFeature)object));
                    throw new ReportedException(crashReport);
                }
                ++n;
            }
        }
    }

    public int func_235080_i_() {
        return this.field_235052_p_.func_235213_a_();
    }

    public int func_225528_a_(double d, double d2) {
        int n = this.field_235052_p_.func_242529_f().orElseGet(this::func_242448_v);
        return this.field_235052_p_.func_242531_g().func_241853_a(d, d2, n);
    }

    private int func_242448_v() {
        double d = MathHelper.func_76131_a(this.field_242423_j.field_242461_c, 0.0f, 1.0f);
        \u2603 = MathHelper.func_76131_a(this.field_242423_j.field_242463_e, 0.0f, 1.0f);
        return GrassColors.func_77480_a(d, \u2603);
    }

    public int func_225527_a_() {
        return this.field_235052_p_.func_242528_e().orElseGet(this::func_242449_w);
    }

    private int func_242449_w() {
        double d = MathHelper.func_76131_a(this.field_242423_j.field_242461_c, 0.0f, 1.0f);
        \u2603 = MathHelper.func_76131_a(this.field_242423_j.field_242463_e, 0.0f, 1.0f);
        return FoliageColors.func_77470_a(d, \u2603);
    }

    public void func_206854_a(Random random, IChunk iChunk, int n, int n2, int n3, double d, BlockState blockState, BlockState blockState2, int n4, long l) {
        ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder = this.field_242424_k.func_242500_d().get();
        configuredSurfaceBuilder.func_215451_a(l);
        configuredSurfaceBuilder.func_215450_a(random, iChunk, this, n, n2, n3, d, blockState, blockState2, n4, l);
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_242423_j.field_242463_e;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_242445_k() {
        return this.field_242423_j.field_242461_c;
    }

    public BiomeAmbience func_235089_q_() {
        return this.field_235052_p_;
    }

    public final int func_185361_o() {
        return this.field_235052_p_.func_235216_b_();
    }

    public final int func_204274_p() {
        return this.field_235052_p_.func_235218_c_();
    }

    public Optional<ParticleEffectAmbience> func_235090_t_() {
        return this.field_235052_p_.func_235220_d_();
    }

    public Optional<SoundEvent> func_235091_u_() {
        return this.field_235052_p_.func_235222_e_();
    }

    public Optional<MoodSoundAmbience> func_235092_v_() {
        return this.field_235052_p_.func_235224_f_();
    }

    public Optional<SoundAdditionsAmbience> func_235093_w_() {
        return this.field_235052_p_.func_235226_g_();
    }

    public Optional<BackgroundMusicSelector> func_235094_x_() {
        return this.field_235052_p_.func_235228_h_();
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public String toString() {
        ResourceLocation resourceLocation = WorldGenRegistries.field_243657_i.func_177774_c(this);
        return resourceLocation == null ? super.toString() : resourceLocation.toString();
    }

    private static /* synthetic */ String func_242430_a(ConfiguredFeature configuredFeature) throws Exception {
        return configuredFeature.field_222737_a.toString();
    }

    private static /* synthetic */ String func_242431_a(Structure structure) throws Exception {
        return structure.toString();
    }

    static class Climate {
        public static final MapCodec<Climate> field_242459_a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RainType.field_235121_d_.fieldOf("precipitation").forGetter(climate -> climate.field_242460_b), (App)Codec.FLOAT.fieldOf("temperature").forGetter(climate -> Float.valueOf(climate.field_242461_c)), (App)TemperatureModifier.field_242473_c.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(climate -> climate.field_242462_d), (App)Codec.FLOAT.fieldOf("downfall").forGetter(climate -> Float.valueOf(climate.field_242463_e))).apply((Applicative)instance, Climate::new));
        private final RainType field_242460_b;
        private final float field_242461_c;
        private final TemperatureModifier field_242462_d;
        private final float field_242463_e;

        private Climate(RainType rainType, float f, TemperatureModifier temperatureModifier, float f2) {
            this.field_242460_b = rainType;
            this.field_242461_c = f;
            this.field_242462_d = temperatureModifier;
            this.field_242463_e = f2;
        }
    }

    public static class Attributes {
        public static final Codec<Attributes> field_235104_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("temperature").forGetter(attributes -> Float.valueOf(attributes.field_235105_b_)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("humidity").forGetter(attributes -> Float.valueOf(attributes.field_235106_c_)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("altitude").forGetter(attributes -> Float.valueOf(attributes.field_235107_d_)), (App)Codec.floatRange((float)-2.0f, (float)2.0f).fieldOf("weirdness").forGetter(attributes -> Float.valueOf(attributes.field_235108_e_)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").forGetter(attributes -> Float.valueOf(attributes.field_235109_f_))).apply((Applicative)instance, Attributes::new));
        private final float field_235105_b_;
        private final float field_235106_c_;
        private final float field_235107_d_;
        private final float field_235108_e_;
        private final float field_235109_f_;

        public Attributes(float f, float f2, float f3, float f4, float f5) {
            this.field_235105_b_ = f;
            this.field_235106_c_ = f2;
            this.field_235107_d_ = f3;
            this.field_235108_e_ = f4;
            this.field_235109_f_ = f5;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Attributes attributes = (Attributes)object;
            if (Float.compare(attributes.field_235105_b_, this.field_235105_b_) != 0) {
                return false;
            }
            if (Float.compare(attributes.field_235106_c_, this.field_235106_c_) != 0) {
                return false;
            }
            if (Float.compare(attributes.field_235107_d_, this.field_235107_d_) != 0) {
                return false;
            }
            return Float.compare(attributes.field_235108_e_, this.field_235108_e_) == 0;
        }

        public int hashCode() {
            int n = this.field_235105_b_ != 0.0f ? Float.floatToIntBits(this.field_235105_b_) : 0;
            n = 31 * n + (this.field_235106_c_ != 0.0f ? Float.floatToIntBits(this.field_235106_c_) : 0);
            n = 31 * n + (this.field_235107_d_ != 0.0f ? Float.floatToIntBits(this.field_235107_d_) : 0);
            n = 31 * n + (this.field_235108_e_ != 0.0f ? Float.floatToIntBits(this.field_235108_e_) : 0);
            return n;
        }

        public float func_235110_a_(Attributes attributes) {
            return (this.field_235105_b_ - attributes.field_235105_b_) * (this.field_235105_b_ - attributes.field_235105_b_) + (this.field_235106_c_ - attributes.field_235106_c_) * (this.field_235106_c_ - attributes.field_235106_c_) + (this.field_235107_d_ - attributes.field_235107_d_) * (this.field_235107_d_ - attributes.field_235107_d_) + (this.field_235108_e_ - attributes.field_235108_e_) * (this.field_235108_e_ - attributes.field_235108_e_) + (this.field_235109_f_ - attributes.field_235109_f_) * (this.field_235109_f_ - attributes.field_235109_f_);
        }
    }

    public static class Builder {
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        private TemperatureModifier field_242452_f = TemperatureModifier.NONE;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private BiomeAmbience field_235096_j_;
        @Nullable
        private MobSpawnInfo field_242453_i;
        @Nullable
        private BiomeGenerationSettings field_242454_j;

        public Builder func_205415_a(RainType rainType) {
            this.field_205423_b = rainType;
            return this;
        }

        public Builder func_205419_a(Category category) {
            this.field_205424_c = category;
            return this;
        }

        public Builder func_205421_a(float f) {
            this.field_205425_d = Float.valueOf(f);
            return this;
        }

        public Builder func_205420_b(float f) {
            this.field_205426_e = Float.valueOf(f);
            return this;
        }

        public Builder func_205414_c(float f) {
            this.field_205427_f = Float.valueOf(f);
            return this;
        }

        public Builder func_205417_d(float f) {
            this.field_205428_g = Float.valueOf(f);
            return this;
        }

        public Builder func_235097_a_(BiomeAmbience biomeAmbience) {
            this.field_235096_j_ = biomeAmbience;
            return this;
        }

        public Builder func_242458_a(MobSpawnInfo mobSpawnInfo) {
            this.field_242453_i = mobSpawnInfo;
            return this;
        }

        public Builder func_242457_a(BiomeGenerationSettings biomeGenerationSettings) {
            this.field_242454_j = biomeGenerationSettings;
            return this;
        }

        public Builder func_242456_a(TemperatureModifier temperatureModifier) {
            this.field_242452_f = temperatureModifier;
            return this;
        }

        public Biome func_242455_a() {
            if (this.field_205423_b == null || this.field_205424_c == null || this.field_205425_d == null || this.field_205426_e == null || this.field_205427_f == null || this.field_205428_g == null || this.field_235096_j_ == null || this.field_242453_i == null || this.field_242454_j == null) {
                throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
            }
            return new Biome(new Climate(this.field_205423_b, this.field_205427_f.floatValue(), this.field_242452_f, this.field_205428_g.floatValue()), this.field_205424_c, this.field_205425_d.floatValue(), this.field_205426_e.floatValue(), this.field_235096_j_, this.field_242454_j, this.field_242453_i);
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + this.field_205423_b + ",\nbiomeCategory=" + this.field_205424_c + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ntemperatureModifier=" + this.field_242452_f + ",\ndownfall=" + this.field_205428_g + ",\nspecialEffects=" + this.field_235096_j_ + ",\nmobSpawnSettings=" + this.field_242453_i + ",\ngenerationSettings=" + this.field_242454_j + ",\n" + '}';
        }
    }

    public static enum TemperatureModifier implements IStringSerializable
    {
        NONE("none"){

            @Override
            public float func_241852_a(BlockPos blockPos, float f) {
                return f;
            }
        }
        ,
        FROZEN("frozen"){

            @Override
            public float func_241852_a(BlockPos blockPos, float f) {
                double d = field_242422_i.func_215464_a((double)blockPos.func_177958_n() * 0.05, (double)blockPos.func_177952_p() * 0.05, false) * 7.0;
                \u2603 = d + (\u2603 = field_180281_af.func_215464_a((double)blockPos.func_177958_n() * 0.2, (double)blockPos.func_177952_p() * 0.2, false));
                if (\u2603 < 0.3 && (\u2603 = field_180281_af.func_215464_a((double)blockPos.func_177958_n() * 0.09, (double)blockPos.func_177952_p() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return f;
            }
        };

        private final String field_242474_d;
        public static final Codec<TemperatureModifier> field_242473_c;
        private static final Map<String, TemperatureModifier> field_242475_e;

        public abstract float func_241852_a(BlockPos var1, float var2);

        private TemperatureModifier(String string2) {
            this.field_242474_d = string2;
        }

        public String func_242478_b() {
            return this.field_242474_d;
        }

        @Override
        public String func_176610_l() {
            return this.field_242474_d;
        }

        public static TemperatureModifier func_242477_a(String string) {
            return field_242475_e.get(string);
        }

        static {
            field_242473_c = IStringSerializable.func_233023_a_(TemperatureModifier::values, TemperatureModifier::func_242477_a);
            field_242475_e = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::func_242478_b, temperatureModifier -> temperatureModifier));
        }
    }

    public static enum RainType implements IStringSerializable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<RainType> field_235121_d_;
        private static final Map<String, RainType> field_222362_d;
        private final String field_222363_e;

        private RainType(String string2) {
            this.field_222363_e = string2;
        }

        public String func_222361_a() {
            return this.field_222363_e;
        }

        public static RainType func_235122_a_(String string) {
            return field_222362_d.get(string);
        }

        @Override
        public String func_176610_l() {
            return this.field_222363_e;
        }

        static {
            field_235121_d_ = IStringSerializable.func_233023_a_(RainType::values, RainType::func_235122_a_);
            field_222362_d = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::func_222361_a, rainType -> rainType));
        }
    }

    public static enum Category implements IStringSerializable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        public static final Codec<Category> field_235102_r_;
        private static final Map<String, Category> field_222354_r;
        private final String field_222355_s;

        private Category(String string2) {
            this.field_222355_s = string2;
        }

        public String func_222352_a() {
            return this.field_222355_s;
        }

        public static Category func_235103_a_(String string) {
            return field_222354_r.get(string);
        }

        @Override
        public String func_176610_l() {
            return this.field_222355_s;
        }

        static {
            field_235102_r_ = IStringSerializable.func_233023_a_(Category::values, Category::func_235103_a_);
            field_222354_r = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::func_222352_a, category -> category));
        }
    }
}

