/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.trunkplacer;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class FancyTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<FancyTrunkPlacer> field_236884_a_ = RecordCodecBuilder.create(instance -> FancyTrunkPlacer.func_236915_a_(instance).apply((Applicative)instance, FancyTrunkPlacer::new));

    public FancyTrunkPlacer(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    @Override
    protected TrunkPlacerType<?> func_230381_a_() {
        return TrunkPlacerType.field_236925_f_;
    }

    @Override
    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader iWorldGenerationReader, Random random, int n, BlockPos blockPos, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        int n2 = 5;
        \u2603 = n + 2;
        \u2603 = MathHelper.func_76128_c((double)\u2603 * 0.618);
        if (!baseTreeFeatureConfig.field_227372_q_) {
            FancyTrunkPlacer.func_236909_a_(iWorldGenerationReader, blockPos.func_177977_b());
        }
        double \u26032 = 1.0;
        \u2603 = Math.min(1, MathHelper.func_76128_c(1.382 + Math.pow(1.0 * (double)\u2603 / 13.0, 2.0)));
        \u2603 = blockPos.func_177956_o() + \u2603;
        ArrayList \u26033 = Lists.newArrayList();
        \u26033.add(new Foliage(blockPos.func_177981_b(\u2603), \u2603));
        for (\u2603 = \u2603 - 5; \u2603 >= 0; --\u2603) {
            float f = this.func_236890_b_(\u2603, \u2603);
            if (f < 0.0f) continue;
            for (int i = 0; i < \u2603; ++i) {
                double d = 1.0;
                \u2603 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                \u2603 = \u2603 * Math.sin(\u2603 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos \u26034 = blockPos.func_177963_a(\u2603, \u2603 - 1, \u2603 = \u2603 * Math.cos(\u2603) + 0.5);
                if (!this.func_236887_a_(iWorldGenerationReader, random, \u26034, \u2603 = \u26034.func_177981_b(5), false, set, mutableBoundingBox, baseTreeFeatureConfig)) continue;
                int \u26035 = blockPos.func_177958_n() - \u26034.func_177958_n();
                int \u26036 = blockPos.func_177952_p() - \u26034.func_177952_p();
                \u2603 = (double)\u26034.func_177956_o() - Math.sqrt(\u26035 * \u26035 + \u26036 * \u26036) * 0.381;
                int \u26037 = \u2603 > (double)\u2603 ? \u2603 : (int)\u2603;
                BlockPos \u26038 = new BlockPos(blockPos.func_177958_n(), \u26037, blockPos.func_177952_p());
                if (!this.func_236887_a_(iWorldGenerationReader, random, \u26038, \u26034, false, set, mutableBoundingBox, baseTreeFeatureConfig)) continue;
                \u26033.add(new Foliage(\u26034, \u26038.func_177956_o()));
            }
        }
        this.func_236887_a_(iWorldGenerationReader, random, blockPos, blockPos.func_177981_b(\u2603), true, set, mutableBoundingBox, baseTreeFeatureConfig);
        this.func_236886_a_(iWorldGenerationReader, random, \u2603, blockPos, \u26033, set, mutableBoundingBox, baseTreeFeatureConfig);
        ArrayList arrayList = Lists.newArrayList();
        for (Foliage foliage : \u26033) {
            if (!this.func_236885_a_(\u2603, foliage.func_236894_a_() - blockPos.func_177956_o())) continue;
            arrayList.add(foliage.field_236892_a_);
        }
        return arrayList;
    }

    private boolean func_236887_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, BlockPos blockPos2, boolean bl, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        if (!bl && Objects.equals(blockPos, blockPos2)) {
            return true;
        }
        BlockPos blockPos3 = blockPos2.func_177982_a(-blockPos.func_177958_n(), -blockPos.func_177956_o(), -blockPos.func_177952_p());
        int \u26032 = this.func_236888_a_(blockPos3);
        float \u26033 = (float)blockPos3.func_177958_n() / (float)\u26032;
        float \u26034 = (float)blockPos3.func_177956_o() / (float)\u26032;
        float \u26035 = (float)blockPos3.func_177952_p() / (float)\u26032;
        for (int i = 0; i <= \u26032; ++i) {
            BlockPos blockPos4 = blockPos.func_177963_a(0.5f + (float)i * \u26033, 0.5f + (float)i * \u26034, 0.5f + (float)i * \u26035);
            if (bl) {
                FancyTrunkPlacer.func_236913_a_(iWorldGenerationReader, blockPos4, (BlockState)baseTreeFeatureConfig.field_227368_m_.func_225574_a_(random, blockPos4).func_206870_a(RotatedPillarBlock.field_176298_M, this.func_236889_a_(blockPos, blockPos4)), mutableBoundingBox);
                set.add(blockPos4.func_185334_h());
                continue;
            }
            if (TreeFeature.func_236410_c_(iWorldGenerationReader, blockPos4)) continue;
            return false;
        }
        return true;
    }

    private int func_236888_a_(BlockPos blockPos) {
        int n = MathHelper.func_76130_a(blockPos.func_177958_n());
        \u2603 = MathHelper.func_76130_a(blockPos.func_177956_o());
        \u2603 = MathHelper.func_76130_a(blockPos.func_177952_p());
        return Math.max(n, Math.max(\u2603, \u2603));
    }

    private Direction.Axis func_236889_a_(BlockPos blockPos, BlockPos blockPos2) {
        Direction.Axis axis = Direction.Axis.Y;
        int \u26032 = Math.abs(blockPos2.func_177958_n() - blockPos.func_177958_n());
        int \u26033 = Math.max(\u26032, \u2603 = Math.abs(blockPos2.func_177952_p() - blockPos.func_177952_p()));
        if (\u26033 > 0) {
            axis = \u26032 == \u26033 ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    private boolean func_236885_a_(int n, int n2) {
        return (double)n2 >= (double)n * 0.2;
    }

    private void func_236886_a_(IWorldGenerationReader iWorldGenerationReader, Random random, int n, BlockPos blockPos, List<Foliage> list, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        for (Foliage foliage : list) {
            int n2 = foliage.func_236894_a_();
            BlockPos \u26032 = new BlockPos(blockPos.func_177958_n(), n2, blockPos.func_177952_p());
            if (\u26032.equals(foliage.field_236892_a_.func_236763_a_()) || !this.func_236885_a_(n, n2 - blockPos.func_177956_o())) continue;
            this.func_236887_a_(iWorldGenerationReader, random, \u26032, foliage.field_236892_a_.func_236763_a_(), true, set, mutableBoundingBox, baseTreeFeatureConfig);
        }
    }

    private float func_236890_b_(int n, int n2) {
        if ((float)n2 < (float)n * 0.3f) {
            return -1.0f;
        }
        float f = (float)n / 2.0f;
        \u2603 = f - (float)n2;
        \u2603 = MathHelper.func_76129_c(f * f - \u2603 * \u2603);
        if (\u2603 == 0.0f) {
            \u2603 = f;
        } else if (Math.abs(\u2603) >= f) {
            return 0.0f;
        }
        return \u2603 * 0.5f;
    }

    static class Foliage {
        private final FoliagePlacer.Foliage field_236892_a_;
        private final int field_236893_b_;

        public Foliage(BlockPos blockPos, int n) {
            this.field_236892_a_ = new FoliagePlacer.Foliage(blockPos, 0, false);
            this.field_236893_b_ = n;
        }

        public int func_236894_a_() {
            return this.field_236893_b_;
        }
    }
}

