/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime.linker;

import org.openjdk.nashorn.internal.runtime.ECMAErrors;
import org.openjdk.nashorn.internal.runtime.ECMAException;

final class AdaptationResult {
    static final AdaptationResult SUCCESSFUL_RESULT = new AdaptationResult(Outcome.SUCCESS, "");
    private final Outcome outcome;
    private final RuntimeException cause;
    private final String[] messageArgs;

    AdaptationResult(Outcome outcome, RuntimeException cause, String ... messageArgs) {
        this.outcome = outcome;
        this.cause = cause;
        this.messageArgs = messageArgs;
    }

    AdaptationResult(Outcome outcome, String ... messageArgs) {
        this(outcome, (RuntimeException)null, messageArgs);
    }

    Outcome getOutcome() {
        return this.outcome;
    }

    ECMAException typeError() {
        return ECMAErrors.typeError(this.cause, "extend." + this.outcome, this.messageArgs);
    }

    static enum Outcome {
        SUCCESS,
        ERROR_FINAL_CLASS,
        ERROR_NON_PUBLIC_CLASS,
        ERROR_NO_ACCESSIBLE_CONSTRUCTOR,
        ERROR_MULTIPLE_SUPERCLASSES,
        ERROR_NO_COMMON_LOADER,
        ERROR_FINAL_FINALIZER,
        ERROR_OTHER;

    }
}

