/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import java.util.function.IntFunction;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.ThreadLocalUtil;

public final class ALCapabilities {
    public final long alGetError;
    public final long alEnable;
    public final long alDisable;
    public final long alIsEnabled;
    public final long alGetBoolean;
    public final long alGetInteger;
    public final long alGetFloat;
    public final long alGetDouble;
    public final long alGetBooleanv;
    public final long alGetIntegerv;
    public final long alGetFloatv;
    public final long alGetDoublev;
    public final long alGetString;
    public final long alDistanceModel;
    public final long alDopplerFactor;
    public final long alDopplerVelocity;
    public final long alListenerf;
    public final long alListeneri;
    public final long alListener3f;
    public final long alListenerfv;
    public final long alGetListenerf;
    public final long alGetListeneri;
    public final long alGetListener3f;
    public final long alGetListenerfv;
    public final long alGenSources;
    public final long alDeleteSources;
    public final long alIsSource;
    public final long alSourcef;
    public final long alSource3f;
    public final long alSourcefv;
    public final long alSourcei;
    public final long alGetSourcef;
    public final long alGetSource3f;
    public final long alGetSourcefv;
    public final long alGetSourcei;
    public final long alGetSourceiv;
    public final long alSourceQueueBuffers;
    public final long alSourceUnqueueBuffers;
    public final long alSourcePlay;
    public final long alSourcePause;
    public final long alSourceStop;
    public final long alSourceRewind;
    public final long alSourcePlayv;
    public final long alSourcePausev;
    public final long alSourceStopv;
    public final long alSourceRewindv;
    public final long alGenBuffers;
    public final long alDeleteBuffers;
    public final long alIsBuffer;
    public final long alGetBufferf;
    public final long alGetBufferi;
    public final long alBufferData;
    public final long alGetEnumValue;
    public final long alGetProcAddress;
    public final long alIsExtensionPresent;
    public final long alListener3i;
    public final long alGetListeneriv;
    public final long alSource3i;
    public final long alListeneriv;
    public final long alSourceiv;
    public final long alBufferf;
    public final long alBuffer3f;
    public final long alBufferfv;
    public final long alBufferi;
    public final long alBuffer3i;
    public final long alBufferiv;
    public final long alGetBufferiv;
    public final long alGetBufferfv;
    public final long alSpeedOfSound;
    public final long alGenEffects;
    public final long alDeleteEffects;
    public final long alIsEffect;
    public final long alEffecti;
    public final long alEffectiv;
    public final long alEffectf;
    public final long alEffectfv;
    public final long alGetEffecti;
    public final long alGetEffectiv;
    public final long alGetEffectf;
    public final long alGetEffectfv;
    public final long alGenFilters;
    public final long alDeleteFilters;
    public final long alIsFilter;
    public final long alFilteri;
    public final long alFilteriv;
    public final long alFilterf;
    public final long alFilterfv;
    public final long alGetFilteri;
    public final long alGetFilteriv;
    public final long alGetFilterf;
    public final long alGetFilterfv;
    public final long alGenAuxiliaryEffectSlots;
    public final long alDeleteAuxiliaryEffectSlots;
    public final long alIsAuxiliaryEffectSlot;
    public final long alAuxiliaryEffectSloti;
    public final long alAuxiliaryEffectSlotiv;
    public final long alAuxiliaryEffectSlotf;
    public final long alAuxiliaryEffectSlotfv;
    public final long alGetAuxiliaryEffectSloti;
    public final long alGetAuxiliaryEffectSlotiv;
    public final long alGetAuxiliaryEffectSlotf;
    public final long alGetAuxiliaryEffectSlotfv;
    public final long alBufferDataStatic;
    public final long alBufferSamplesSOFT;
    public final long alBufferSubSamplesSOFT;
    public final long alGetBufferSamplesSOFT;
    public final long alIsBufferFormatSupportedSOFT;
    public final long alBufferSubDataSOFT;
    public final long alBufferCallbackSOFT;
    public final long alGetBufferPtrSOFT;
    public final long alGetBuffer3PtrSOFT;
    public final long alGetBufferPtrvSOFT;
    public final long alDeferUpdatesSOFT;
    public final long alProcessUpdatesSOFT;
    public final long alEventControlSOFT;
    public final long alEventCallbackSOFT;
    public final long alGetPointerSOFT;
    public final long alGetPointervSOFT;
    public final long alSourcedSOFT;
    public final long alSource3dSOFT;
    public final long alSourcedvSOFT;
    public final long alGetSourcedSOFT;
    public final long alGetSource3dSOFT;
    public final long alGetSourcedvSOFT;
    public final long alSourcei64SOFT;
    public final long alSource3i64SOFT;
    public final long alSourcei64vSOFT;
    public final long alGetSourcei64SOFT;
    public final long alGetSource3i64SOFT;
    public final long alGetSourcei64vSOFT;
    public final long alGetStringiSOFT;
    public final boolean OpenAL10;
    public final boolean OpenAL11;
    public final boolean AL_EXT_ALAW;
    public final boolean AL_EXT_BFORMAT;
    public final boolean AL_EXT_DOUBLE;
    public final boolean ALC_EXT_EFX;
    public final boolean AL_EXT_EXPONENT_DISTANCE;
    public final boolean AL_EXT_FLOAT32;
    public final boolean AL_EXT_IMA4;
    public final boolean AL_EXT_LINEAR_DISTANCE;
    public final boolean AL_EXT_MCFORMATS;
    public final boolean AL_EXT_MULAW;
    public final boolean AL_EXT_MULAW_BFORMAT;
    public final boolean AL_EXT_MULAW_MCFORMATS;
    public final boolean AL_EXT_OFFSET;
    public final boolean AL_EXT_source_distance_model;
    public final boolean AL_EXT_SOURCE_RADIUS;
    public final boolean AL_EXT_static_buffer;
    public final boolean AL_EXT_STEREO_ANGLES;
    public final boolean AL_EXT_vorbis;
    public final boolean AL_LOKI_IMA_ADPCM;
    public final boolean AL_LOKI_quadriphonic;
    public final boolean AL_LOKI_WAVE_format;
    public final boolean AL_SOFT_bformat_ex;
    public final boolean AL_SOFT_block_alignment;
    public final boolean AL_SOFT_buffer_samples;
    public final boolean AL_SOFT_buffer_sub_data;
    public final boolean AL_SOFT_callback_buffer;
    public final boolean AL_SOFT_deferred_updates;
    public final boolean AL_SOFT_direct_channels;
    public final boolean AL_SOFT_direct_channels_remix;
    public final boolean AL_SOFT_effect_target;
    public final boolean AL_SOFT_events;
    public final boolean AL_SOFT_gain_clamp_ex;
    public final boolean AL_SOFT_loop_points;
    public final boolean AL_SOFT_MSADPCM;
    public final boolean AL_SOFT_source_latency;
    public final boolean AL_SOFT_source_length;
    public final boolean AL_SOFT_source_resampler;
    public final boolean AL_SOFT_source_spatialize;
    public final boolean AL_SOFT_UHJ;
    public final boolean AL_SOFTX_hold_on_disconnect;
    final PointerBuffer addresses;

    ALCapabilities(FunctionProvider provider, Set<String> ext, IntFunction<PointerBuffer> bufferFactory) {
        PointerBuffer caps = bufferFactory.apply(131);
        this.OpenAL10 = ALCapabilities.check_AL10(provider, caps, ext);
        this.OpenAL11 = ALCapabilities.check_AL11(provider, caps, ext);
        this.AL_EXT_ALAW = ext.contains("AL_EXT_ALAW");
        this.AL_EXT_BFORMAT = ext.contains("AL_EXT_BFORMAT");
        this.AL_EXT_DOUBLE = ext.contains("AL_EXT_DOUBLE");
        this.ALC_EXT_EFX = ALCapabilities.check_EXT_EFX(provider, caps, ext);
        this.AL_EXT_EXPONENT_DISTANCE = ext.contains("AL_EXT_EXPONENT_DISTANCE");
        this.AL_EXT_FLOAT32 = ext.contains("AL_EXT_FLOAT32");
        this.AL_EXT_IMA4 = ext.contains("AL_EXT_IMA4");
        this.AL_EXT_LINEAR_DISTANCE = ext.contains("AL_EXT_LINEAR_DISTANCE");
        this.AL_EXT_MCFORMATS = ext.contains("AL_EXT_MCFORMATS");
        this.AL_EXT_MULAW = ext.contains("AL_EXT_MULAW");
        this.AL_EXT_MULAW_BFORMAT = ext.contains("AL_EXT_MULAW_BFORMAT");
        this.AL_EXT_MULAW_MCFORMATS = ext.contains("AL_EXT_MULAW_MCFORMATS");
        this.AL_EXT_OFFSET = ext.contains("AL_EXT_OFFSET");
        this.AL_EXT_source_distance_model = ext.contains("AL_EXT_source_distance_model");
        this.AL_EXT_SOURCE_RADIUS = ext.contains("AL_EXT_SOURCE_RADIUS");
        this.AL_EXT_static_buffer = ALCapabilities.check_EXT_static_buffer(provider, caps, ext);
        this.AL_EXT_STEREO_ANGLES = ext.contains("AL_EXT_STEREO_ANGLES");
        this.AL_EXT_vorbis = ext.contains("AL_EXT_vorbis");
        this.AL_LOKI_IMA_ADPCM = ext.contains("AL_LOKI_IMA_ADPCM");
        this.AL_LOKI_quadriphonic = ext.contains("AL_LOKI_quadriphonic");
        this.AL_LOKI_WAVE_format = ext.contains("AL_LOKI_WAVE_format");
        this.AL_SOFT_bformat_ex = ext.contains("AL_SOFT_bformat_ex");
        this.AL_SOFT_block_alignment = ext.contains("AL_SOFT_block_alignment");
        this.AL_SOFT_buffer_samples = ALCapabilities.check_SOFT_buffer_samples(provider, caps, ext);
        this.AL_SOFT_buffer_sub_data = ALCapabilities.check_SOFT_buffer_sub_data(provider, caps, ext);
        this.AL_SOFT_callback_buffer = ALCapabilities.check_SOFT_callback_buffer(provider, caps, ext);
        this.AL_SOFT_deferred_updates = ALCapabilities.check_SOFT_deferred_updates(provider, caps, ext);
        this.AL_SOFT_direct_channels = ext.contains("AL_SOFT_direct_channels");
        this.AL_SOFT_direct_channels_remix = ext.contains("AL_SOFT_direct_channels_remix");
        this.AL_SOFT_effect_target = ext.contains("AL_SOFT_effect_target");
        this.AL_SOFT_events = ALCapabilities.check_SOFT_events(provider, caps, ext);
        this.AL_SOFT_gain_clamp_ex = ext.contains("AL_SOFT_gain_clamp_ex");
        this.AL_SOFT_loop_points = ext.contains("AL_SOFT_loop_points");
        this.AL_SOFT_MSADPCM = ext.contains("AL_SOFT_MSADPCM");
        this.AL_SOFT_source_latency = ALCapabilities.check_SOFT_source_latency(provider, caps, ext);
        this.AL_SOFT_source_length = ext.contains("AL_SOFT_source_length");
        this.AL_SOFT_source_resampler = ALCapabilities.check_SOFT_source_resampler(provider, caps, ext);
        this.AL_SOFT_source_spatialize = ext.contains("AL_SOFT_source_spatialize");
        this.AL_SOFT_UHJ = ext.contains("AL_SOFT_UHJ");
        this.AL_SOFTX_hold_on_disconnect = ext.contains("AL_SOFTX_hold_on_disconnect");
        this.alGetError = caps.get(0);
        this.alEnable = caps.get(1);
        this.alDisable = caps.get(2);
        this.alIsEnabled = caps.get(3);
        this.alGetBoolean = caps.get(4);
        this.alGetInteger = caps.get(5);
        this.alGetFloat = caps.get(6);
        this.alGetDouble = caps.get(7);
        this.alGetBooleanv = caps.get(8);
        this.alGetIntegerv = caps.get(9);
        this.alGetFloatv = caps.get(10);
        this.alGetDoublev = caps.get(11);
        this.alGetString = caps.get(12);
        this.alDistanceModel = caps.get(13);
        this.alDopplerFactor = caps.get(14);
        this.alDopplerVelocity = caps.get(15);
        this.alListenerf = caps.get(16);
        this.alListeneri = caps.get(17);
        this.alListener3f = caps.get(18);
        this.alListenerfv = caps.get(19);
        this.alGetListenerf = caps.get(20);
        this.alGetListeneri = caps.get(21);
        this.alGetListener3f = caps.get(22);
        this.alGetListenerfv = caps.get(23);
        this.alGenSources = caps.get(24);
        this.alDeleteSources = caps.get(25);
        this.alIsSource = caps.get(26);
        this.alSourcef = caps.get(27);
        this.alSource3f = caps.get(28);
        this.alSourcefv = caps.get(29);
        this.alSourcei = caps.get(30);
        this.alGetSourcef = caps.get(31);
        this.alGetSource3f = caps.get(32);
        this.alGetSourcefv = caps.get(33);
        this.alGetSourcei = caps.get(34);
        this.alGetSourceiv = caps.get(35);
        this.alSourceQueueBuffers = caps.get(36);
        this.alSourceUnqueueBuffers = caps.get(37);
        this.alSourcePlay = caps.get(38);
        this.alSourcePause = caps.get(39);
        this.alSourceStop = caps.get(40);
        this.alSourceRewind = caps.get(41);
        this.alSourcePlayv = caps.get(42);
        this.alSourcePausev = caps.get(43);
        this.alSourceStopv = caps.get(44);
        this.alSourceRewindv = caps.get(45);
        this.alGenBuffers = caps.get(46);
        this.alDeleteBuffers = caps.get(47);
        this.alIsBuffer = caps.get(48);
        this.alGetBufferf = caps.get(49);
        this.alGetBufferi = caps.get(50);
        this.alBufferData = caps.get(51);
        this.alGetEnumValue = caps.get(52);
        this.alGetProcAddress = caps.get(53);
        this.alIsExtensionPresent = caps.get(54);
        this.alListener3i = caps.get(55);
        this.alGetListeneriv = caps.get(56);
        this.alSource3i = caps.get(57);
        this.alListeneriv = caps.get(58);
        this.alSourceiv = caps.get(59);
        this.alBufferf = caps.get(60);
        this.alBuffer3f = caps.get(61);
        this.alBufferfv = caps.get(62);
        this.alBufferi = caps.get(63);
        this.alBuffer3i = caps.get(64);
        this.alBufferiv = caps.get(65);
        this.alGetBufferiv = caps.get(66);
        this.alGetBufferfv = caps.get(67);
        this.alSpeedOfSound = caps.get(68);
        this.alGenEffects = caps.get(69);
        this.alDeleteEffects = caps.get(70);
        this.alIsEffect = caps.get(71);
        this.alEffecti = caps.get(72);
        this.alEffectiv = caps.get(73);
        this.alEffectf = caps.get(74);
        this.alEffectfv = caps.get(75);
        this.alGetEffecti = caps.get(76);
        this.alGetEffectiv = caps.get(77);
        this.alGetEffectf = caps.get(78);
        this.alGetEffectfv = caps.get(79);
        this.alGenFilters = caps.get(80);
        this.alDeleteFilters = caps.get(81);
        this.alIsFilter = caps.get(82);
        this.alFilteri = caps.get(83);
        this.alFilteriv = caps.get(84);
        this.alFilterf = caps.get(85);
        this.alFilterfv = caps.get(86);
        this.alGetFilteri = caps.get(87);
        this.alGetFilteriv = caps.get(88);
        this.alGetFilterf = caps.get(89);
        this.alGetFilterfv = caps.get(90);
        this.alGenAuxiliaryEffectSlots = caps.get(91);
        this.alDeleteAuxiliaryEffectSlots = caps.get(92);
        this.alIsAuxiliaryEffectSlot = caps.get(93);
        this.alAuxiliaryEffectSloti = caps.get(94);
        this.alAuxiliaryEffectSlotiv = caps.get(95);
        this.alAuxiliaryEffectSlotf = caps.get(96);
        this.alAuxiliaryEffectSlotfv = caps.get(97);
        this.alGetAuxiliaryEffectSloti = caps.get(98);
        this.alGetAuxiliaryEffectSlotiv = caps.get(99);
        this.alGetAuxiliaryEffectSlotf = caps.get(100);
        this.alGetAuxiliaryEffectSlotfv = caps.get(101);
        this.alBufferDataStatic = caps.get(102);
        this.alBufferSamplesSOFT = caps.get(103);
        this.alBufferSubSamplesSOFT = caps.get(104);
        this.alGetBufferSamplesSOFT = caps.get(105);
        this.alIsBufferFormatSupportedSOFT = caps.get(106);
        this.alBufferSubDataSOFT = caps.get(107);
        this.alBufferCallbackSOFT = caps.get(108);
        this.alGetBufferPtrSOFT = caps.get(109);
        this.alGetBuffer3PtrSOFT = caps.get(110);
        this.alGetBufferPtrvSOFT = caps.get(111);
        this.alDeferUpdatesSOFT = caps.get(112);
        this.alProcessUpdatesSOFT = caps.get(113);
        this.alEventControlSOFT = caps.get(114);
        this.alEventCallbackSOFT = caps.get(115);
        this.alGetPointerSOFT = caps.get(116);
        this.alGetPointervSOFT = caps.get(117);
        this.alSourcedSOFT = caps.get(118);
        this.alSource3dSOFT = caps.get(119);
        this.alSourcedvSOFT = caps.get(120);
        this.alGetSourcedSOFT = caps.get(121);
        this.alGetSource3dSOFT = caps.get(122);
        this.alGetSourcedvSOFT = caps.get(123);
        this.alSourcei64SOFT = caps.get(124);
        this.alSource3i64SOFT = caps.get(125);
        this.alSourcei64vSOFT = caps.get(126);
        this.alGetSourcei64SOFT = caps.get(127);
        this.alGetSource3i64SOFT = caps.get(128);
        this.alGetSourcei64vSOFT = caps.get(129);
        this.alGetStringiSOFT = caps.get(130);
        this.addresses = ThreadLocalUtil.setupAddressBuffer((PointerBuffer)caps);
    }

    public PointerBuffer getAddressBuffer() {
        return this.addresses;
    }

    private static boolean check_AL10(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("OpenAL10")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54}, (String[])new String[]{"alGetError", "alEnable", "alDisable", "alIsEnabled", "alGetBoolean", "alGetInteger", "alGetFloat", "alGetDouble", "alGetBooleanv", "alGetIntegerv", "alGetFloatv", "alGetDoublev", "alGetString", "alDistanceModel", "alDopplerFactor", "alDopplerVelocity", "alListenerf", "alListeneri", "alListener3f", "alListenerfv", "alGetListenerf", "alGetListeneri", "alGetListener3f", "alGetListenerfv", "alGenSources", "alDeleteSources", "alIsSource", "alSourcef", "alSource3f", "alSourcefv", "alSourcei", "alGetSourcef", "alGetSource3f", "alGetSourcefv", "alGetSourcei", "alGetSourceiv", "alSourceQueueBuffers", "alSourceUnqueueBuffers", "alSourcePlay", "alSourcePause", "alSourceStop", "alSourceRewind", "alSourcePlayv", "alSourcePausev", "alSourceStopv", "alSourceRewindv", "alGenBuffers", "alDeleteBuffers", "alIsBuffer", "alGetBufferf", "alGetBufferi", "alBufferData", "alGetEnumValue", "alGetProcAddress", "alIsExtensionPresent"}) || Checks.reportMissing((String)"AL", (String)"OpenAL10");
    }

    private static boolean check_AL11(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("OpenAL11")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68}, (String[])new String[]{"alListener3i", "alGetListeneriv", "alSource3i", "alListeneriv", "alSourceiv", "alBufferf", "alBuffer3f", "alBufferfv", "alBufferi", "alBuffer3i", "alBufferiv", "alGetBufferiv", "alGetBufferfv", "alSpeedOfSound"}) || Checks.reportMissing((String)"AL", (String)"OpenAL11");
    }

    private static boolean check_EXT_EFX(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_EXT_EFX")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101}, (String[])new String[]{"alGenEffects", "alDeleteEffects", "alIsEffect", "alEffecti", "alEffectiv", "alEffectf", "alEffectfv", "alGetEffecti", "alGetEffectiv", "alGetEffectf", "alGetEffectfv", "alGenFilters", "alDeleteFilters", "alIsFilter", "alFilteri", "alFilteriv", "alFilterf", "alFilterfv", "alGetFilteri", "alGetFilteriv", "alGetFilterf", "alGetFilterfv", "alGenAuxiliaryEffectSlots", "alDeleteAuxiliaryEffectSlots", "alIsAuxiliaryEffectSlot", "alAuxiliaryEffectSloti", "alAuxiliaryEffectSlotiv", "alAuxiliaryEffectSlotf", "alAuxiliaryEffectSlotfv", "alGetAuxiliaryEffectSloti", "alGetAuxiliaryEffectSlotiv", "alGetAuxiliaryEffectSlotf", "alGetAuxiliaryEffectSlotfv"}) || Checks.reportMissing((String)"AL", (String)"ALC_EXT_EFX");
    }

    private static boolean check_EXT_static_buffer(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_EXT_static_buffer")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{102}, (String[])new String[]{"alBufferDataStatic"}) || Checks.reportMissing((String)"AL", (String)"AL_EXT_static_buffer");
    }

    private static boolean check_SOFT_buffer_samples(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_buffer_samples")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{103, 104, 105, 106}, (String[])new String[]{"alBufferSamplesSOFT", "alBufferSubSamplesSOFT", "alGetBufferSamplesSOFT", "alIsBufferFormatSupportedSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_buffer_samples");
    }

    private static boolean check_SOFT_buffer_sub_data(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_buffer_sub_data")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{107}, (String[])new String[]{"alBufferSubDataSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_buffer_sub_data");
    }

    private static boolean check_SOFT_callback_buffer(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_callback_buffer")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{108, 109, 110, 111}, (String[])new String[]{"alBufferCallbackSOFT", "alGetBufferPtrSOFT", "alGetBuffer3PtrSOFT", "alGetBufferPtrvSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_callback_buffer");
    }

    private static boolean check_SOFT_deferred_updates(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_deferred_updates")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{112, 113}, (String[])new String[]{"alDeferUpdatesSOFT", "alProcessUpdatesSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_deferred_updates");
    }

    private static boolean check_SOFT_events(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_events")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{114, 115, 116, 117}, (String[])new String[]{"alEventControlSOFT", "alEventCallbackSOFT", "alGetPointerSOFT", "alGetPointervSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_events");
    }

    private static boolean check_SOFT_source_latency(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_source_latency")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129}, (String[])new String[]{"alSourcedSOFT", "alSource3dSOFT", "alSourcedvSOFT", "alGetSourcedSOFT", "alGetSource3dSOFT", "alGetSourcedvSOFT", "alSourcei64SOFT", "alSource3i64SOFT", "alSourcei64vSOFT", "alGetSourcei64SOFT", "alGetSource3i64SOFT", "alGetSourcei64vSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_source_latency");
    }

    private static boolean check_SOFT_source_resampler(FunctionProvider provider, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("AL_SOFT_source_resampler")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProvider)provider, (PointerBuffer)caps, (int[])new int[]{130}, (String[])new String[]{"alGetStringiSOFT"}) || Checks.reportMissing((String)"AL", (String)"AL_SOFT_source_resampler");
    }
}

