/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.CuriosAPIConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.CuriosSaveUtils;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InGameConfigScreen
extends Screen {
    private final ResourceLocation INV_BG = new ResourceLocation("inventoryhud", "textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = new ResourceLocation("inventoryhud", "textures/gui/conf_bg.png");
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private List<ConfigWidget> listForRender;
    private Button backButton;
    private final int menu;
    private final boolean inGame;

    public InGameConfigScreen(int menu, boolean inGame) {
        super((ITextComponent)new TranslationTextComponent("InventoryHUD Config Screen"));
        this.inGame = inGame;
        this.menu = menu;
    }

    protected void func_231160_c_() {
        int textPos;
        int ySize;
        int xSize;
        int pw;
        float potScale;
        this.listForRender = new ArrayList<ConfigWidget>();
        float invScale = (Boolean)InventoryHUD.getClient().invMini.get() != false ? 0.75f : 1.0f;
        int invWidth = (Boolean)InventoryHUD.getClient().invVert.get() != false ? 52 : 160;
        int invHeight = (Boolean)InventoryHUD.getClient().invVert.get() != false ? 160 : 52;
        int x = this.getPosX((int)((float)invWidth * invScale), (Integer)InventoryHUD.getClient().xPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHalign.get()));
        int y = this.getPosY((int)((float)invHeight * invScale), (Integer)InventoryHUD.getClient().yPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invValign.get()));
        this.backButton = new Button(this.field_230708_k_ - 60, 10, 50, 20, (ITextComponent)new StringTextComponent("Back"), btn -> this.func_231175_as__());
        this.ICW = new ConfigWidget(x, y, invWidth, invHeight, invScale, Translation.INVGUI, InventoryHUD.isActive);
        this.listForRender.add(this.ICW);
        if (!((Boolean)InventoryHUD.getClient().invVert.get()).booleanValue()) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(w -> this.onInvChanged());
        this.ICW.addPosListener(w -> this.onInvPosChanged());
        float f = ((Boolean)InventoryHUD.getClient().potMini.get()).booleanValue() ? (((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue() ? 1.0f : 0.75f) : (potScale = 1.0f);
        int n = ((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClient().potMini.get()).booleanValue() ? 18 : 36) : (pw = 60);
        int ph = ((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClient().potMini.get()).booleanValue() ? 22 : 38) : 24;
        x = this.getPosX((int)((float)pw * potScale), (Integer)InventoryHUD.getClient().xPotionPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().potHalign.get()));
        y = this.getPosY((int)((float)ph * potScale), (Integer)InventoryHUD.getClient().yPotionPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().potValign.get()));
        this.PCW = new ConfigWidget(x, y, pw, ph, potScale, Translation.POTGUI, InventoryHUD.potionHUD);
        this.listForRender.add(this.PCW);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(w -> this.onPotionChanged());
        this.PCW.addPosListener(w -> this.onPotionPosChanged());
        float armScale = (float)((Integer)InventoryHUD.getClient().armScale.get()).intValue() / 100.0f;
        if (((Boolean)InventoryHUD.getClient().moveAll.get()).booleanValue()) {
            x = this.getPosX((int)(90.0f * armScale), (Integer)InventoryHUD.getClient().xArmPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()));
            y = this.getPosY((int)(70.0f * armScale), (Integer)InventoryHUD.getClient().yArmPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
            this.ACW = new ConfigWidget(x, y, 90, 70, armScale, Translation.ARMGUI, InventoryHUD.armorHUD);
            this.listForRender.add(this.ACW);
            this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
            this.ACW.addListener(w -> this.onArmorChanged());
            this.ACW.addPosListener(w -> this.onArmorPosChanged());
        } else {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().helmPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().helmHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().helmPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().helmVal.get()));
            ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_helmet.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 0));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().chestPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().chestHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().chestPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().chestVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_chestplate.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 1));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().legPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().legHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().legPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().legVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_leggings.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 2));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().bootPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().bootHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().bootPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().bootVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_boots.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 3));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().mainPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().mainHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().mainPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().mainVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showMain.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_main_hand_slot.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 5));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().offPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().offHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().offPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().offVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showOff.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_shield.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 4));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().arrPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().arrHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().arrPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().arrVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showArrows.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_arrows.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 7));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClient().invPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClient().invPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), (Boolean)InventoryHUD.getClient().showInv.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_inventory.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 6));
        }
        if (InventoryHUD.isCuriosMod) {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            for (Map.Entry<String, CuriosSlot> entry : InventoryHUD.getInstance().getInventoryGui().slots.entrySet()) {
                if (!entry.getValue().enabled) continue;
                x = this.getPosX(xSize, entry.getValue().x, entry.getValue().aligns.HorAlign);
                y = this.getPosY(ySize, entry.getValue().y, entry.getValue().aligns.VertAlign);
                ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (ITextComponent)new StringTextComponent(""), entry.getValue().enabled, false);
                this.listForRender.add(tmp);
                tmp.initTextureValues(textPos, 124, new Color4F(1.0f, 0.5f, 0.0f, 1.0f), this.INV_BG, entry.getValue().icon);
                tmp.addPosListener(w -> this.onCuriosItemPosChanged(w, (String)entry.getKey(), (CuriosSlot)entry.getValue()));
            }
        }
        this.field_230705_e_.add(this.backButton);
        this.field_230705_e_.addAll(this.listForRender);
    }

    private int getPosX(int width, int posX, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = posX;
                break;
            }
            case RIGHT: {
                result = this.field_230708_k_ - posX;
                break;
            }
            case MIDDLE: {
                result = this.field_230708_k_ / 2 - width / 2 - posX;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.field_230708_k_ - width) {
            result = this.field_230708_k_ - width;
        }
        return result;
    }

    private int getPosY(int height, int posY, WidgetAligns.VAlign hal) {
        int result = 0;
        switch (hal) {
            case TOP: {
                result = posY;
                break;
            }
            case BOTTOM: {
                result = this.field_230709_l_ - posY;
                break;
            }
            case CENTER: {
                result = this.field_230709_l_ / 2 - height / 2 - posY;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.field_230709_l_ - height) {
            result = this.field_230709_l_ - height;
        }
        return result;
    }

    public void func_230430_a_(MatrixStack mat, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(mat);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.CONF_BG);
        InGameConfigScreen.func_238463_a_((MatrixStack)mat, (int)0, (int)(this.field_230709_l_ / 3 - 1), (float)this.field_230708_k_, (float)3.0f, (int)this.field_230708_k_, (int)3, (int)3, (int)3);
        InGameConfigScreen.func_238463_a_((MatrixStack)mat, (int)0, (int)(this.field_230709_l_ / 3 * 2 - 1), (float)this.field_230708_k_, (float)3.0f, (int)this.field_230708_k_, (int)3, (int)3, (int)3);
        InGameConfigScreen.func_238463_a_((MatrixStack)mat, (int)(this.field_230708_k_ / 3 - 1), (int)0, (float)3.0f, (float)this.field_230709_l_, (int)3, (int)this.field_230709_l_, (int)3, (int)3);
        InGameConfigScreen.func_238463_a_((MatrixStack)mat, (int)(this.field_230708_k_ / 3 * 2 - 1), (int)0, (float)3.0f, (float)this.field_230709_l_, (int)3, (int)this.field_230709_l_, (int)3, (int)3);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        for (ConfigWidget w : this.listForRender) {
            w.func_230430_a_(mat, mouseX, mouseY, partialTick);
        }
        this.backButton.func_230430_a_(mat, mouseX, mouseY, partialTick);
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InventoryHUD.getClient().byDefault.set((Object)this.ICW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onInvPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.ICW.field_230690_l_ + this.ICW.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 3) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.invX = this.ICW.field_230690_l_;
        } else if (this.ICW.field_230690_l_ + this.ICW.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 3 * 2) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.invX = mc.field_71462_r.field_230708_k_ - this.ICW.field_230690_l_;
        } else {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.invX = this.ICW.field_230690_l_ + this.ICW.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 2 - 10 ? mc.field_71462_r.field_230708_k_ / 2 - this.ICW.func_230998_h_() / 2 - this.ICW.field_230690_l_ : (this.ICW.field_230690_l_ + this.ICW.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 2 + 10 ? mc.field_71462_r.field_230708_k_ / 2 - this.ICW.func_230998_h_() / 2 - this.ICW.field_230690_l_ : 0);
        }
        if (this.ICW.field_230691_m_ + this.ICW.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 3) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.invY = this.ICW.field_230691_m_;
        } else if (this.ICW.field_230691_m_ + this.ICW.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 3 * 2) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.invY = mc.field_71462_r.field_230709_l_ - this.ICW.field_230691_m_;
        } else {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.invY = this.ICW.field_230691_m_ + this.ICW.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 2 - 10 ? mc.field_71462_r.field_230709_l_ / 2 - this.ICW.func_238483_d_() / 2 - this.ICW.field_230691_m_ : (this.ICW.field_230691_m_ + this.ICW.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 2 + 10 ? mc.field_71462_r.field_230709_l_ / 2 - this.ICW.func_238483_d_() / 2 - this.ICW.field_230691_m_ : 0);
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InventoryHUD.getClient().Potions.set((Object)this.PCW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onPotionPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.PCW.field_230690_l_ + this.PCW.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.PCW.field_230690_l_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else if (this.PCW.field_230690_l_ + this.PCW.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.field_71462_r.field_230708_k_ - this.PCW.field_230690_l_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.field_230690_l_ + this.PCW.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.field_71462_r.field_230708_k_ / 2 - this.PCW.func_230998_h_() / 2 - this.PCW.field_230690_l_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else if (this.PCW.field_230690_l_ + this.PCW.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = mc.field_71462_r.field_230708_k_ / 2 - this.PCW.func_230998_h_() / 2 - this.PCW.field_230690_l_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            }
        }
        if (this.PCW.field_230691_m_ + this.PCW.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.PCW.field_230691_m_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
        } else if (this.PCW.field_230691_m_ + this.PCW.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.field_71462_r.field_230709_l_ - this.PCW.field_230691_m_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.field_230691_m_ + this.PCW.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.field_71462_r.field_230709_l_ / 2 - this.PCW.func_238483_d_() / 2 - this.PCW.field_230691_m_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            } else if (this.PCW.field_230691_m_ + this.PCW.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = mc.field_71462_r.field_230709_l_ / 2 - this.PCW.func_238483_d_() / 2 - this.PCW.field_230691_m_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InventoryHUD.getClient().ArmorDamage.set((Object)this.ACW.getShow());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void onArmorPosChanged() {
        int ay;
        int ax;
        Minecraft mc = Minecraft.func_71410_x();
        WidgetAligns armal = new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.BOTTOM);
        if (this.ACW.field_230690_l_ + this.ACW.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 3) {
            armal.HorAlign = WidgetAligns.HAlign.LEFT;
            ax = this.ACW.field_230690_l_;
        } else if (this.ACW.field_230690_l_ + this.ACW.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 3 * 2) {
            armal.HorAlign = WidgetAligns.HAlign.RIGHT;
            ax = mc.field_71462_r.field_230708_k_ - this.ACW.field_230690_l_;
        } else {
            armal.HorAlign = WidgetAligns.HAlign.MIDDLE;
            ax = this.ACW.field_230690_l_ + this.ACW.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 2 - 10 ? mc.field_71462_r.field_230708_k_ / 2 - this.ACW.func_230998_h_() / 2 - this.ACW.field_230690_l_ : (this.ACW.field_230690_l_ + this.ACW.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 2 + 10 ? mc.field_71462_r.field_230708_k_ / 2 - this.ACW.func_230998_h_() / 2 - this.ACW.field_230690_l_ : 0);
        }
        if (this.ACW.field_230691_m_ + this.ACW.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 2 - 10) {
            armal.VertAlign = WidgetAligns.VAlign.TOP;
            ay = this.ACW.field_230691_m_;
        } else if (this.ACW.field_230691_m_ + this.ACW.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 2 + 10) {
            armal.VertAlign = WidgetAligns.VAlign.BOTTOM;
            ay = mc.field_71462_r.field_230709_l_ - this.ACW.field_230691_m_;
        } else {
            armal.VertAlign = WidgetAligns.VAlign.CENTER;
            ay = this.ACW.field_230691_m_ + this.ACW.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 2 - 10 ? mc.field_71462_r.field_230709_l_ / 2 - this.ACW.func_238483_d_() / 2 - this.ACW.field_230691_m_ : (this.ACW.field_230691_m_ + this.ACW.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 2 + 10 ? mc.field_71462_r.field_230709_l_ / 2 - this.ACW.func_238483_d_() / 2 - this.ACW.field_230691_m_ : 0);
        }
        InventoryHUD.getInstance().getInventoryGui().changeArmorPos(armal, ax, ay);
    }

    private void onCuriosItemPosChanged(ConfigWidget w, String id, CuriosSlot slot) {
        Minecraft mc = Minecraft.func_71410_x();
        if (w.field_230690_l_ + w.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 3) {
            slot.aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            slot.x = w.field_230690_l_;
        } else if (w.field_230690_l_ + w.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 3 * 2) {
            slot.aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            slot.x = mc.field_71462_r.field_230708_k_ - w.field_230690_l_;
        } else {
            slot.aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            slot.x = mc.field_71462_r.field_230708_k_ / 2 - w.func_230998_h_() / 2 - w.field_230690_l_;
        }
        if (w.field_230691_m_ + w.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 2 - 10) {
            slot.aligns.VertAlign = WidgetAligns.VAlign.TOP;
            slot.y = w.field_230691_m_;
        } else if (w.field_230691_m_ + w.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 2 + 10) {
            slot.aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            slot.y = mc.field_71462_r.field_230709_l_ - w.field_230691_m_;
        } else {
            slot.aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            slot.y = mc.field_71462_r.field_230709_l_ / 2 - w.func_238483_d_() / 2 - w.field_230691_m_;
        }
        InventoryHUD.getInstance().getInventoryGui().slots.put(id, slot);
    }

    private void onItemPosChanged(ConfigWidget w, int i) {
        Minecraft mc = Minecraft.func_71410_x();
        if (w.field_230690_l_ + w.func_230998_h_() / 2 <= mc.field_71462_r.field_230708_k_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = w.field_230690_l_;
        } else if (w.field_230690_l_ + w.func_230998_h_() / 2 >= mc.field_71462_r.field_230708_k_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.field_71462_r.field_230708_k_ - w.field_230690_l_;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = mc.field_71462_r.field_230708_k_ / 2 - w.func_230998_h_() / 2 - w.field_230690_l_;
        }
        if (w.field_230691_m_ + w.func_238483_d_() / 2 <= mc.field_71462_r.field_230709_l_ / 2 - 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = w.field_230691_m_;
        } else if (w.field_230691_m_ + w.func_238483_d_() / 2 >= mc.field_71462_r.field_230709_l_ / 2 + 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.field_71462_r.field_230709_l_ - w.field_230691_m_;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = mc.field_71462_r.field_230709_l_ / 2 - w.func_238483_d_() / 2 - w.field_230691_m_;
        }
    }

    private void saveConfig() {
        InventoryHUD.getClient().xPos.set((Object)InventoryGui.invX);
        InventoryHUD.getClient().yPos.set((Object)InventoryGui.invY);
        InventoryHUD.getClient().invHalign.set((Object)InventoryGui.InvAligns.HorAlign);
        InventoryHUD.getClient().invValign.set((Object)InventoryGui.InvAligns.VertAlign);
        InventoryHUD.getClient().xPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX);
        InventoryHUD.getClient().yPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY);
        InventoryHUD.getClient().potHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign);
        InventoryHUD.getClient().potValign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign);
        InventoryHUD.getClient().xArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armX);
        InventoryHUD.getClient().yArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armY);
        InventoryHUD.getClient().armHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.HorAlign);
        InventoryHUD.getClient().armValign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.VertAlign);
        InventoryHUD.getClient().helmPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].x);
        InventoryHUD.getClient().chestPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].x);
        InventoryHUD.getClient().legPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].x);
        InventoryHUD.getClient().bootPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].x);
        InventoryHUD.getClient().offPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].x);
        InventoryHUD.getClient().mainPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].x);
        InventoryHUD.getClient().invPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].x);
        InventoryHUD.getClient().arrPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].x);
        InventoryHUD.getClient().helmPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].y);
        InventoryHUD.getClient().chestPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].y);
        InventoryHUD.getClient().legPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].y);
        InventoryHUD.getClient().bootPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].y);
        InventoryHUD.getClient().offPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].y);
        InventoryHUD.getClient().mainPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].y);
        InventoryHUD.getClient().invPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].y);
        InventoryHUD.getClient().arrPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].y);
        InventoryHUD.getClient().helmHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.HorAlign);
        InventoryHUD.getClient().chestHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.HorAlign);
        InventoryHUD.getClient().legHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.HorAlign);
        InventoryHUD.getClient().bootHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.HorAlign);
        InventoryHUD.getClient().offHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.HorAlign);
        InventoryHUD.getClient().mainHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.HorAlign);
        InventoryHUD.getClient().invHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.HorAlign);
        InventoryHUD.getClient().arrHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.HorAlign);
        InventoryHUD.getClient().helmVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.VertAlign);
        InventoryHUD.getClient().chestVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.VertAlign);
        InventoryHUD.getClient().legVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.VertAlign);
        InventoryHUD.getClient().bootVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.VertAlign);
        InventoryHUD.getClient().offVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.VertAlign);
        InventoryHUD.getClient().mainVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.VertAlign);
        InventoryHUD.getClient().invVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.VertAlign);
        InventoryHUD.getClient().arrVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.VertAlign);
        InventoryHUD.getConfig().clientSpec.save();
        if (InventoryHUD.isCuriosMod) {
            CuriosSaveUtils.saveSettings();
        }
    }

    public void func_231175_as__() {
        this.saveConfig();
        switch (this.menu) {
            case -1: {
                this.field_230706_i_.func_147108_a(null);
                break;
            }
            case 0: {
                this.field_230706_i_.func_147108_a((Screen)new InventoryConfigScreen(this.inGame));
                break;
            }
            case 1: {
                this.field_230706_i_.func_147108_a((Screen)new ArmorConfigScreen(this.inGame));
                break;
            }
            case 2: {
                this.field_230706_i_.func_147108_a((Screen)new PotionConfigScreen(this.inGame));
                break;
            }
            case 3: {
                this.field_230706_i_.func_147108_a((Screen)new CuriosAPIConfigScreen(this.inGame));
            }
        }
    }
}

