/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.utils.CuriosSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosItemRenderer
extends ArmorRenderer {
    public CuriosItemRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(MatrixStack mat, int width, int height) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.mc.field_71439_g).ifPresent(handler -> {
            float scale = (float)this.armScale / 100.0f;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)-320.0);
            handler.getCurios().forEach((id, stacksHandler) -> {
                CuriosSlot slot = InventoryHUD.getInstance().getInventoryGui().slots.get(id);
                if (slot != null && slot.enabled) {
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.func_190926_b()) {
                            stack = cosmeticHandler.getStackInSlot(i);
                        }
                        int x = this.getX(width, (int)(16.0f * scale), slot.x, slot.aligns.HorAlign);
                        int y = this.getY(height, (int)(16.0f * scale), slot.y, slot.aligns.VertAlign);
                        boolean right = this.getRight(slot.x, slot.aligns.HorAlign);
                        int Damage = ArmorStatus.GetDamage(stack);
                        String text = null;
                        if (Damage >= 0 && Damage <= this.armAbove) {
                            if (!InventoryHUD.getInstance().getInventoryGui().armorRenderer.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                                switch (this.armView) {
                                    case PERCENTAGE: {
                                        text = this.getDamageText(String.valueOf(Damage), Damage);
                                        break;
                                    }
                                    case DAMAGE: {
                                        text = this.getDamageText(String.valueOf(stack.func_77952_i()), Damage);
                                        break;
                                    }
                                    case DAMAGE_LEFT: {
                                        text = this.getDamageText(String.valueOf(stack.func_77958_k() - stack.func_77952_i()), Damage);
                                    }
                                }
                            }
                            this.pushAndRender(mat, x, (int)((float)y + (float)(i * 18) * scale), !right, null, stack, text, this.armBars, scale);
                            continue;
                        }
                        if (Damage == -2) {
                            this.pushAndRender(mat, x, (int)((float)y + (float)(i * 18) * scale), !right, null, stack, null, true, scale);
                            continue;
                        }
                        if (!this.showEmpty) continue;
                        this.pushAndRender(mat, x, (int)((float)y + (float)(i * 18) * scale), !right, slot.icon, null, null, false, scale);
                    }
                }
            });
            RenderSystem.popMatrix();
        });
    }

    private void pushAndRender(MatrixStack mat, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        this.renderElement(mat, 0, 0, right, resourceLocation, itemStack, text, over);
        RenderSystem.popMatrix();
    }
}

