/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class HorizontalMiniPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_mini_hor.png");

    public HorizontalMiniPotionRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    int getX(int width, int effCount) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - 9 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 9 - (effCount - 1) * (19 + this.potGap) - this.potX;
                    break;
                }
                result = (int)((float)(width / 2 - 9) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 9.0f) - (float)this.potX);
                break;
            }
            case RIGHT: {
                result = width - this.potX - (effCount - 1) * (this.potGap + 19);
            }
        }
        return result;
    }

    @Override
    int getY(int height, int c) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                result = height / 2 - 11 - this.potY;
                break;
            }
            case BOTTOM: {
                result = height - this.potY;
            }
        }
        return result;
    }

    @Override
    void renderBG(MatrixStack mat, int x, int y, int c) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.mc.func_110434_K().func_110577_a(this.PBG);
        HorizontalMiniPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(x + c * (18 + this.potGap)), (int)y, (float)18.0f, (float)22.0f, (int)18, (int)22, (int)18, (int)(22 * this.potSide));
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.popMatrix();
    }

    @Override
    void renderIcon(MatrixStack mat, int x, int y, int c, TextureAtlasSprite s) {
        HorizontalMiniPotionRenderer.func_238470_a_((MatrixStack)mat, (int)(x + c * (18 + this.potGap) + 3), (int)(y + 3 + this.potIconSide), (int)this.func_230927_p_(), (int)12, (int)12, (TextureAtlasSprite)s);
    }

    @Override
    void renderLevel(MatrixStack mat, int x, int y, int c) {
        HorizontalMiniPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(x + c * (18 + this.potGap) + 9), (int)(y + this.potIconSide), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
    }

    @Override
    void renderTimer(MatrixStack mat, int x, int y, int c, int dur) {
        int xsize = 12;
        this.mc.func_110434_K().func_110577_a(this.PMT);
        RenderSystem.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        if (dur < this.barDuration) {
            xsize = this.setBarColor(dur);
        }
        HorizontalMiniPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(x + 3 + c * (18 + this.potGap)), (int)(y + this.potTextSide), (float)xsize, (float)3.0f, (int)xsize, (int)3, (int)xsize, (int)3);
    }
}

