/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class VerticalMiniPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_mini.png");

    public VerticalMiniPotionRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    int getX(int width, int c) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 22 - this.potX;
                    break;
                }
                result = width / 2 - 11 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX + 23;
            }
        }
        return result;
    }

    @Override
    int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 9 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 9 - (effCount - 1) * (18 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 9) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 9.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 18);
            }
        }
        return result;
    }

    @Override
    void renderBG(MatrixStack mat, int x, int y, int c) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.mc.func_110434_K().func_110577_a(this.PBG);
        VerticalMiniPotionRenderer.func_238463_a_((MatrixStack)mat, (int)x, (int)(y + c * (18 + this.potGap)), (float)22.0f, (float)18.0f, (int)22, (int)18, (int)(22 * this.potSide), (int)18);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.popMatrix();
    }

    @Override
    void renderIcon(MatrixStack mat, int x, int y, int c, TextureAtlasSprite s) {
        VerticalMiniPotionRenderer.func_238470_a_((MatrixStack)mat, (int)(x + 3 + this.potIconSide), (int)(y + c * (18 + this.potGap) + 3), (int)this.func_230927_p_(), (int)12, (int)12, (TextureAtlasSprite)s);
    }

    @Override
    void renderLevel(MatrixStack mat, int x, int y, int c) {
        VerticalMiniPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(x + 9 + this.potIconSide), (int)(y + c * (18 + this.potGap)), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
    }

    @Override
    void renderTimer(MatrixStack mat, int x, int y, int c, int dur) {
        int ysize = 12;
        this.mc.func_110434_K().func_110577_a(this.PMT);
        RenderSystem.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        if (dur < this.barDuration) {
            ysize = this.setBarColor(dur);
        }
        VerticalMiniPotionRenderer.func_238463_a_((MatrixStack)mat, (int)(x + 17 + this.potTextSide), (int)(y + c * (18 + this.potGap) + 15 - ysize), (float)3.0f, (float)ysize, (int)3, (int)ysize, (int)3, (int)ysize);
    }
}

