package com.mattsmeets.macrokey.gui;

import java.io.IOException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mattsmeets.macrokey.gui.fragment.LayerListFragment;
import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiLayerManagement extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();

    private final Screen parentScreen;

    private LayerListFragment layerListFragment;

    GuiLayerManagement(Screen screen) {
    	super(new TranslationTextComponent("gui.manage.layer.text.title"));
        this.parentScreen = screen;
    }
    
    @Override
    public void render(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
    	this.renderBackground(p_230430_1_);
    	drawCenteredString(p_230430_1_, this.font, this.title, this.width / 2, 8, 0xFFFFFF);
    	super.render(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    @Override
    public void init() {
        this.addButton(new Button(this.width / 2 - 155, this.height - 29, 150, 20, new TranslationTextComponent("gui.done"), b -> {
        	minecraft.setScreen(parentScreen);
        }));

        // Add layer button
        this.addButton(new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, new TranslationTextComponent("gui.manage.text.layer.add"), b -> {
        	minecraft.setScreen(new GuiModifyLayer(this));
        }));

        try {
            this.layerListFragment = new LayerListFragment(this);
        } catch (IOException e) {
            LOGGER.error(e);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton != 0 || !this.layerListFragment.mouseClicked(mouseX, mouseY, mouseButton)) {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        return false;
    }

    @Override
    public boolean isPauseScreen() {
    	return false;
    }
}
