package com.mattsmeets.macrokey.gui.button;

import org.lwjgl.glfw.GLFW;

import com.mattsmeets.macrokey.model.MacroInterface;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class KeyBindingButton extends Button {
    public KeyBindingButton(int x, int y, int widthIn, int heightIn, ITextComponent buttonText, IPressable ipr) {
        super(x, y, widthIn, heightIn, buttonText, ipr);
    }

    public void updateDisplayString(final MacroInterface macro, final boolean isListening) {
    	String keyValue = GLFW.glfwGetKeyName(macro.getKeyCode(), 0);
        if (keyValue == null) keyValue = InputMappings.Type.KEYSYM.getOrCreate(macro.getKeyCode()).getDisplayName().getString();
        if (macro.getKeyCode() == 0 || keyValue == null) keyValue = " ";
        this.setMessage(new StringTextComponent(isListening ? TextFormatting.WHITE + "> " + TextFormatting.YELLOW + keyValue + TextFormatting.WHITE + " <"
                : isMacroKeyAlreadyBind(macro) ? TextFormatting.GOLD + keyValue
                : keyValue));
    }

    @SuppressWarnings("resource")
    private static boolean isMacroKeyAlreadyBind(final MacroInterface macro) {
        if (macro.getKeyCode() != 0) {
            for (KeyBinding keybinding : Minecraft.getInstance().options.keyMappings) {
                if (keybinding.getKey().getValue() == macro.getKeyCode()) {
                    return true;
                }
            }
        }

        return false;
    }
}
