package ru.vidtu.macrokeyreborn;

import com.mattsmeets.macrokey.config.ModConfig;
import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

//Thanks to Forge for removing @Config in 1.13/1.14
public class MacroKeyConfigGui extends Screen {
	public Screen prev;
	public TextFieldWidget repeatDelayTF, bindingFileTF, xTF, yTF, widthTF, heightTF;
	public CheckboxButton disableTF;
	public MacroKeyConfigGui(Screen prev) {
		super(new TranslationTextComponent("macrokey.config.title"));
		this.prev = prev;
	}
	
	@Override
	protected void init() {
		repeatDelayTF = addButton(new TextFieldWidget(font, width - 204, 40, 200, 20, new StringTextComponent("repeatDelay")));
		bindingFileTF = addButton(new TextFieldWidget(font, width - 204, 64, 200, 20, new StringTextComponent("bindingFile")));
		disableTF = addButton(new CheckboxButton(width - font.width("buttonLayerSwitchSettingsDisable") - 30, 88, 200, 20, new StringTextComponent("buttonLayerSwitchSettingsDisable"), ModConfig.buttonLayerSwitchDisabled.get()));
		xTF = addButton(new TextFieldWidget(font, width - 204, 112, 46, 20, new StringTextComponent("buttonLayerSwitchSettingsX")));
		yTF = addButton(new TextFieldWidget(font, width - 154, 112, 46, 20, new StringTextComponent("buttonLayerSwitchSettingsY")));
		widthTF = addButton(new TextFieldWidget(font, width - 104, 112, 46, 20, new StringTextComponent("buttonLayerSwitchSettingsWidth")));
		heightTF = addButton(new TextFieldWidget(font, width - 54, 112, 46, 20, new StringTextComponent("buttonLayerSwitchSettingsHeight")));
		repeatDelayTF.setValue(Integer.toString(ModConfig.repeatDelay.get()));
		bindingFileTF.setValue(ModConfig.bindingFile.get());
		xTF.setValue(Integer.toString(ModConfig.buttonLayerSwitchSettingsX.get()));
		yTF.setValue(Integer.toString(ModConfig.buttonLayerSwitchSettingsY.get()));
		widthTF.setValue(Integer.toString(ModConfig.buttonLayerSwitchSettingsW.get()));
		heightTF.setValue(Integer.toString(ModConfig.buttonLayerSwitchSettingsH.get()));
		addButton(new Button(width / 2 - 75, height - 24, 70, 20, new TranslationTextComponent("gui.done"), b -> {
			try {
				ModConfig.repeatDelay.set(Integer.parseInt(repeatDelayTF.getValue()));
				ModConfig.bindingFile.set(bindingFileTF.getValue());
				ModConfig.buttonLayerSwitchDisabled.set(disableTF.selected());
				ModConfig.buttonLayerSwitchSettingsX.set(Integer.parseInt(xTF.getValue()));
				ModConfig.buttonLayerSwitchSettingsY.set(Integer.parseInt(yTF.getValue()));
				ModConfig.buttonLayerSwitchSettingsW.set(Integer.parseInt(widthTF.getValue()));
				ModConfig.buttonLayerSwitchSettingsH.set(Integer.parseInt(heightTF.getValue()));
				ModConfig.config.save();
				minecraft.setScreen(prev);
			} catch (NumberFormatException nfe) {
				minecraft.getToasts().addToast(new SystemToast(SystemToast.Type.NARRATOR_TOGGLE, new TranslationTextComponent("macrokey.config.nfe1"), new TranslationTextComponent("macrokey.config.nfe2")));
			}
		}));
		addButton(new Button(width / 2 + 5, height - 24, 70, 20, new TranslationTextComponent("gui.cancel"), b -> minecraft.setScreen(prev)));
		String s = I18n.get("macrokey.config.reset");
		addButton(new Button(width - font.width(s) - 6, height - 24, font.width(s) + 4, 20, new StringTextComponent(s), b -> {
			ModConfig.repeatDelay.set(20);
			ModConfig.bindingFile.set("bindings.json");
			ModConfig.buttonLayerSwitchDisabled.set(false);
			ModConfig.buttonLayerSwitchSettingsX.set(-100);
			ModConfig.buttonLayerSwitchSettingsY.set(128);
			ModConfig.buttonLayerSwitchSettingsW.set(200);
			ModConfig.buttonLayerSwitchSettingsH.set(20);
			ModConfig.config.save();
		}));
	}
	
	@Override
	public void tick() {
		replace(repeatDelayTF, "[^0-9]");
		replace(xTF, "[^0-9-]");
		replace(yTF, "[^0-9-]");
		replace(widthTF, "[^0-9]");
		replace(heightTF, "[^0-9]");
		replace(bindingFileTF, "[^A-Za-z0-9._-]");
		xTF.setEditable(!disableTF.selected());
		yTF.setEditable(!disableTF.selected());
		widthTF.setEditable(!disableTF.selected());
		heightTF.setEditable(!disableTF.selected());
	}
	
	/**@deprecated*/
	private void replace(TextFieldWidget tf, String regex) { //Someone help me with regex plz this code is AWFUL.
		String n = tf.getValue().replaceAll(regex, "");
		if (!n.equals(tf.getValue())) tf.setValue(n);
	}
	
	@Override
	public void render(MatrixStack ms, int p_render_1_, int p_render_2_, float p_render_3_) {
		this.renderBackground(ms);
		drawString(ms, font, "repeatDelay:", 5, 44, -1);
		drawString(ms, font, "bindingFile:", 5, 68, -1);
		drawString(ms, font, "buttonLayerSwitchSettings:", 5, 116, -1);
		drawString(ms, font, "(x, y, width, height)", 5, 126, -256);
		drawCenteredString(ms, font, this.title, width / 2, 20, -1);
		super.render(ms, p_render_1_, p_render_2_, p_render_3_);
	}
}
