/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.action.ConnectingToRealmsAction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.settings.ModSettings;
import xaero.patreon.Patreon6;

public class ForgeEventHandler {
    public static final RenderGameOverlayEvent.ElementType[] OVERLAY_LAYERS = new RenderGameOverlayEvent.ElementType[]{RenderGameOverlayEvent.ElementType.ALL, RenderGameOverlayEvent.ElementType.HELMET, RenderGameOverlayEvent.ElementType.HOTBAR, RenderGameOverlayEvent.ElementType.CROSSHAIRS, RenderGameOverlayEvent.ElementType.BOSSHEALTH, RenderGameOverlayEvent.ElementType.TEXT, RenderGameOverlayEvent.ElementType.POTION_ICONS, RenderGameOverlayEvent.ElementType.SUBTITLES, RenderGameOverlayEvent.ElementType.CHAT};
    private IXaeroMinimap modMain;
    private Screen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private boolean crosshairDisabledByThisMod = false;
    public RealmsServer latestRealm;

    public ForgeEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof OptionsScreen) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setGui((Screen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (event.getGui() instanceof MainMenuScreen || event.getGui() instanceof MultiplayerScreen) {
            this.modMain.getSettings().resetServerSettings();
        }
        if (event.getGui() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                ConnectingToRealmsAction realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("field_224248_l");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = ConnectingToRealmsAction.class.getDeclaredField("field_238116_c_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getGui())) instanceof ConnectingToRealmsAction && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (ConnectingToRealmsAction)task)) != null && (this.latestRealm == null || realm.field_230582_a_ != this.latestRealm.field_230582_a_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastGuiOpen = event.getGui();
    }

    protected void handleRenderGameOverlayEventPreOverridable(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == OVERLAY_LAYERS[this.modMain.getSettings().renderLayerIndex]) {
            MainWindow mainwindow = Minecraft.func_71410_x().func_228018_at_();
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)mainwindow.func_198109_k() / mainwindow.func_198100_s()), (double)((double)mainwindow.func_198091_l() / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                this.modMain.getInterfaceRenderer().renderInterfaces(minimapSession, event.getMatrixStack(), event.getPartialTicks());
                this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), event.getMatrixStack(), Minecraft.func_71410_x().func_228018_at_());
                if (ForgeIngameGui.renderCrosshairs && minimapSession.getMinimapProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
                    ForgeIngameGui.renderCrosshairs = false;
                    this.crosshairDisabledByThisMod = true;
                }
            }
            OldAnimation.tick();
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        ImprovedFramebuffer.ensureDefaultFramebuffer();
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)256)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
        this.handleRenderGameOverlayEventPreOverridable(event);
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        IPotionEffectsPushBox potionEffectsPushBox;
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && (potionEffectsPushBox = this.modMain.getInterfaces().getPotionEffectPushBox()) != null) {
            potionEffectsPushBox.setActive(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.crosshairDisabledByThisMod) {
            ForgeIngameGui.renderCrosshairs = true;
            this.crosshairDisabledByThisMod = false;
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (e.getMessage().startsWith("xaero_waypoint_add:")) {
            String[] args = e.getMessage().split(":");
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
        } else if (e.getMessage().equals("/xaero_tp_anyway")) {
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getMessage() == null) {
            return;
        }
        ITextComponent text = e.getMessage();
        String textString = text.getString();
        if (textString.contains("xaero_waypoint:") || textString.contains("xaero-waypoint:")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(textString, e);
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon6.needsNotification() && event.getGui() instanceof MainMenuScreen) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    public void handlePlayerSetSpawn(World world, BlockPos spawn) {
        XaeroMinimapSession minimapSession;
        if (world instanceof ClientWorld && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(spawn, (ClientWorld)world);
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (this.modMain.getSupportMods().optifine) {
            Patreon6.renderCapeFallback(this.modMain.getFileLayoutID(), event);
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }
}

