/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.entity.model.AbstractTropicalFishModel;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BeeModel;
import net.minecraft.client.renderer.entity.model.BoarModel;
import net.minecraft.client.renderer.entity.model.CodModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EndermiteModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.LlamaModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.PandaModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PufferFishBigModel;
import net.minecraft.client.renderer.entity.model.PufferFishMediumModel;
import net.minecraft.client.renderer.entity.model.PufferFishSmallModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.SalmonModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.StriderModel;
import net.minecraft.client.renderer.entity.model.WitherModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.custom.CatIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.DrownedIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.EndermanIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.HorseIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.IronGolemIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.LlamaIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.PhantomIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.PigIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.ShulkerIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.SlimeIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.SpiderIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.StrayIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.StriderIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.TropicalFishIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.VillagerIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.WolfIconCustomRenderer;

public class EntityIconDefinitions {
    private static ImmutableList<String> FIELD_FORCED_CLASSES = ImmutableList.of();
    static ImmutableList<String> HEAD_HARDCODED_NAMES = ImmutableList.of((Object)"net.minecraft.client.renderer.entity.model.BatModel;batHead", (Object)"net.minecraft.client.renderer.entity.model.BatModel;field_82895_a", (Object)"net.minecraft.client.renderer.entity.model.BlazeModel;blazeHead", (Object)"net.minecraft.client.renderer.entity.model.BlazeModel;field_78105_b", (Object)"net.minecraft.client.renderer.entity.model.SpiderModel;spiderHead", (Object)"net.minecraft.client.renderer.entity.model.SpiderModel;field_78209_a", (Object)"net.minecraft.client.renderer.entity.model.CodModel;headFront", (Object)"net.minecraft.client.renderer.entity.model.CodModel;field_203726_d", (Object)"net.minecraft.client.renderer.entity.model.CreeperModel;head", (Object)"net.minecraft.client.renderer.entity.model.CreeperModel;field_78135_a", (Object)"net.minecraft.client.renderer.entity.model.LlamaModel;head", (Object)"net.minecraft.client.renderer.entity.model.LlamaModel;field_228273_a_", (Object[])new String[]{"net.minecraft.client.renderer.entity.model.ParrotModel;head", "net.minecraft.client.renderer.entity.model.ParrotModel;field_192768_e", "net.minecraft.client.renderer.entity.model.PhantomModel;body", "net.minecraft.client.renderer.entity.model.PhantomModel;field_203070_a", "net.minecraft.client.renderer.entity.model.RabbitModel;rabbitHead", "net.minecraft.client.renderer.entity.model.RabbitModel;field_178704_h", "net.minecraft.client.renderer.entity.model.RavagerModel;head", "net.minecraft.client.renderer.entity.model.RavagerModel;field_217168_a", "net.minecraft.client.renderer.entity.model.SquidModel;body", "net.minecraft.client.renderer.entity.model.SquidModel;field_78202_a", "", "net.minecraft.client.renderer.entity.model.StriderModel;field_239120_f_", "net.minecraft.client.renderer.entity.model.IronGolemModel;ironGolemHead", "net.minecraft.client.renderer.entity.model.IronGolemModel;field_78178_a", "net.minecraft.client.renderer.entity.model.SnowManModel;head", "net.minecraft.client.renderer.entity.model.SnowManModel;field_78195_c", "net.minecraft.client.renderer.entity.EnderDragonRenderer$EnderDragonModel;head", "net.minecraft.client.renderer.entity.EnderDragonRenderer$EnderDragonModel;field_78221_a"});
    static ImmutableList<String> HEAD_PARTS_HARDCODED_NAMES = ImmutableList.of((Object)"net.minecraft.client.renderer.entity.model.RabbitModel;rabbitRightEar", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;field_178705_i", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;rabbitLeftEar", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;field_178702_j", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;rabbitNose", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;field_178700_l");
    static float slimeSquishBU;

    static boolean forceFieldCheck(EntityModel em) {
        return FIELD_FORCED_CLASSES.contains((Object)em.getClass().getName());
    }

    static void customTransformation(MatrixStack matrixStack, EntityModel em, Entity entity, EntityIconPrerenderer prerenderer) {
        if (em instanceof CodModel || em instanceof SalmonModel) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof AbstractTropicalFishModel) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            if (entity instanceof TropicalFishEntity) {
                TropicalFishEntity fishEntity = (TropicalFishEntity)entity;
                float[] color = fishEntity.func_204219_dC();
                prerenderer.setRGBA(color[0], color[1], color[2], 1.0f);
            }
        } else if (em instanceof BatModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof HorseModel) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(65.0f));
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof DolphinModel) {
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof GuardianModel || em instanceof SquidModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof BoarModel) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof LlamaModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (entity instanceof SlimeEntity) {
            SlimeEntity slime = (SlimeEntity)entity;
            slimeSquishBU = slime.field_70811_b;
            slime.field_70811_b = 0.0f;
        } else if (em instanceof GhastModel || em instanceof RavagerModel || em instanceof StriderModel || em instanceof EnderDragonRenderer.EnderDragonModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof WitherModel) {
            matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
        } else if (em instanceof PhantomModel) {
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        } else if (em instanceof PandaModel) {
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        }
    }

    public static void customPostRenderTransformation(MatrixStack matrixStack, EntityModel entityModel, Entity entity) {
        if (entity instanceof SlimeEntity) {
            SlimeEntity slime = (SlimeEntity)entity;
            slime.field_70811_b = slimeSquishBU;
        }
    }

    static boolean fullModelIcon(EntityModel em) {
        return em instanceof CodModel || em instanceof SalmonModel || em instanceof AbstractTropicalFishModel || em instanceof BeeModel || em instanceof DolphinModel || em instanceof GuardianModel || em instanceof EndermiteModel || em instanceof GhastModel || em instanceof MagmaCubeModel || em instanceof SlimeModel || em instanceof PufferFishBigModel || em instanceof PufferFishMediumModel || em instanceof PufferFishSmallModel || em instanceof SilverfishModel || em instanceof WitherModel;
    }

    public static EntityIconCustomRenderer getCustomLayer(EntityRenderer entityRenderer, Entity entity) {
        if (entityRenderer instanceof SlimeRenderer) {
            return new SlimeIconCustomRenderer();
        }
        if (entityRenderer instanceof EndermanRenderer) {
            return new EndermanIconCustomRenderer();
        }
        if (entityRenderer instanceof SpiderRenderer) {
            return new SpiderIconCustomRenderer();
        }
        if (entityRenderer instanceof PhantomRenderer) {
            return new PhantomIconCustomRenderer();
        }
        if (entityRenderer instanceof HorseRenderer) {
            return new HorseIconCustomRenderer();
        }
        if (entityRenderer instanceof DrownedRenderer) {
            return new DrownedIconCustomRenderer();
        }
        if (entityRenderer instanceof VillagerRenderer) {
            return new VillagerIconCustomRenderer("villager");
        }
        if (entityRenderer instanceof ZombieVillagerRenderer) {
            return new VillagerIconCustomRenderer("zombie_villager");
        }
        if (entityRenderer instanceof CatRenderer) {
            return new CatIconCustomRenderer();
        }
        if (entityRenderer instanceof WolfRenderer) {
            return new WolfIconCustomRenderer();
        }
        if (entityRenderer instanceof IronGolemRenderer) {
            return new IronGolemIconCustomRenderer();
        }
        if (entityRenderer instanceof LlamaRenderer) {
            return new LlamaIconCustomRenderer();
        }
        if (entityRenderer instanceof PigRenderer) {
            return new PigIconCustomRenderer();
        }
        if (entityRenderer instanceof StriderRenderer) {
            return new StriderIconCustomRenderer();
        }
        if (entityRenderer instanceof ShulkerRenderer) {
            return new ShulkerIconCustomRenderer();
        }
        if (entityRenderer instanceof StrayRenderer) {
            return new StrayIconCustomRenderer();
        }
        if (entityRenderer instanceof TropicalFishRenderer) {
            return new TropicalFishIconCustomRenderer();
        }
        return null;
    }

    public static String getVariantString(EntityRenderer entityRenderer, Entity entity) {
        ResourceLocation entityTexture = entityRenderer.func_110775_a(entity);
        if (entityTexture == null) {
            return "";
        }
        if (entityRenderer instanceof HorseRenderer) {
            return entityTexture + "%" + HorseIconCustomRenderer.horseMarkings.get(((HorseEntity)entity).func_234240_eM_());
        }
        if (entityRenderer instanceof VillagerRenderer || entityRenderer instanceof ZombieVillagerRenderer) {
            VillagerData villagerdata = ((IVillagerDataHolder)entity).func_213700_eh();
            VillagerType villagertype = villagerdata.func_221129_a();
            VillagerProfession villagerprofession = villagerdata.func_221130_b();
            int villagerprofessionlevel = villagerdata.func_221132_c();
            return entityTexture + "%" + ((LivingEntity)entity).func_70631_g_() + "%" + villagertype + "%" + villagerprofession + "%" + villagerprofessionlevel;
        }
        if (entityRenderer instanceof CatRenderer) {
            return entityTexture + "%" + ((CatEntity)entity).func_70909_n();
        }
        if (entityRenderer instanceof WolfRenderer) {
            return entityTexture + "%" + ((WolfEntity)entity).func_70909_n();
        }
        if (entityRenderer instanceof IronGolemRenderer) {
            IronGolemEntity ironGolem = (IronGolemEntity)entity;
            IronGolemEntity.Cracks cracks = ironGolem.func_226512_l_();
            return entityTexture + "%" + cracks;
        }
        if (entityRenderer instanceof LlamaRenderer) {
            LlamaEntity llama = (LlamaEntity)entity;
            return entityTexture + "%" + llama.func_213800_eB() + "%" + llama.func_190704_dO();
        }
        if (entityRenderer instanceof PigRenderer) {
            PigEntity pig = (PigEntity)entity;
            return entityTexture + "%" + pig.func_110257_ck();
        }
        if (entityRenderer instanceof StriderRenderer) {
            StriderEntity strider = (StriderEntity)entity;
            return entityTexture + "%" + strider.func_110257_ck();
        }
        if (entityRenderer instanceof TropicalFishRenderer) {
            TropicalFishEntity fish = (TropicalFishEntity)entity;
            return entityTexture + "%" + fish.func_204221_dB();
        }
        return entityTexture.toString();
    }
}

