/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;

public class EntityIconPrerenderer {
    private static final ModelRenderer[] ONE_RENDERER_ARRAY = new ModelRenderer[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private MatrixStack matrixStack;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private float r;
    private float g;
    private float b;
    private float a;

    public EntityIconPrerenderer() {
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        GlStateManager.func_227758_s_((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.matrixStack = new MatrixStack();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(EntityRenderer entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, boolean debug) {
        EntityModel entityModel = null;
        if (entityRenderer instanceof LivingRenderer) {
            entityModel = ((LivingRenderer)entityRenderer).func_217764_d();
        } else if (entityRenderer instanceof EnderDragonRenderer) {
            entityModel = new EnderDragonRenderer.EnderDragonModel();
        }
        if (entityModel == null) {
            return -1;
        }
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_147621_c;
        OpenGLException.checkGLError();
        MatrixStack matrixStack = this.matrixStack;
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227625_M_();
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        if (Minecraft.func_71410_x().func_175598_ae().field_217783_c != null) {
            matrixStack.func_227860_a_();
            try {
                OpenGLException.checkGLError();
                entityRenderer.func_225623_a_(entity, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
            }
            catch (Exception e) {
                System.out.println("Exception when calling the full entity renderer before rendering the icon. " + entity.func_70022_Q());
            }
            renderTypeBuffer.func_228461_a_();
            matrixStack.func_227865_b_();
            while (GL11.glGetError() != 0) {
            }
        } else {
            System.out.println("Render info was null for entity " + entity.func_70022_Q());
        }
        GlStateManager.func_227700_d_();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227658_a_((int)16640, (boolean)Minecraft.field_142025_a);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227734_k_();
        GlStateManager.func_227605_A_();
        GlStateManager.func_227674_b_((int)515);
        RenderHelper.func_227783_c_();
        if (debug) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 10.0, -10.0);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-65536);
            matrixStack.func_227865_b_();
            GlStateManager.func_227740_m_();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(finalIconSize / 2), (double)(finalIconSize / 2), -450.0);
        matrixStack.func_227862_a_((float)(finalIconSize / 2), (float)(finalIconSize / 2), -1.0f);
        EntityIconDefinitions.customTransformation(matrixStack, entityModel, entity, this);
        entityModel.func_225597_a_(entity, 0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f);
        entityModel.func_212843_a_(entity, 0.0f, 0.0f, 1.0f);
        OpenGLException.checkGLError();
        boolean renderedSomething = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, entityModel, (Entity)((LivingEntity)entity));
        EntityIconDefinitions.customPostRenderTransformation(matrixStack, entityModel, entity);
        matrixStack.func_227865_b_();
        if (debug) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(9.0, 10.0, -10.0);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711936);
            matrixStack.func_227865_b_();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.func_227740_m_();
        RenderHelper.func_74518_a();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.0f);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227737_l_();
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(18.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16776961);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.func_227702_d_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(27.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711681);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_227740_m_();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.func_227760_t_((int)0);
            entityScaledIconTextureId = GlStateManager.func_227622_J_();
            OpenGLException.checkGLError();
            GlStateManager.func_227760_t_((int)entityScaledIconTextureId);
            GL11.glTexParameteri((int)3553, (int)33085, (int)0);
            GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            OpenGLException.checkGLError();
            GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_147621_c, (int)iconScaleFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GlStateManager.func_227760_t_((int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.func_147610_a(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.func_147611_b();
            iconRenderFramebuffer.func_147612_c();
            GlStateManager.func_227700_d_();
            GlStateManager.func_227737_l_();
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(36.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-256);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_227709_e_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227760_t_((int)0);
        }
        GlStateManager.func_227627_O_();
        GlStateManager.func_227768_x_((int)5889);
        helper.defaultOrtho();
        GlStateManager.func_227768_x_((int)5888);
        iconScaleFramebuffer.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
        return entityScaledIconTextureId;
    }

    private boolean renderModel(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, EntityRenderer entityRenderer, EntityModel entityModel, Entity entity) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck = EntityIconDefinitions.forceFieldCheck(entityModel);
        boolean isChildBU = entityModel.field_217114_e;
        entityModel.field_217114_e = false;
        ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
        ModelRenderer mainPart = null;
        ResourceLocation entityTexture = entityRenderer.func_110775_a(entity);
        if (entityTexture != null) {
            IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(CustomRenderTypes.entityTranslucent(entityTexture));
            if (!forceFieldCheck && entityModel instanceof AgeableModel) {
                if (entityModel instanceof BipedModel) {
                    ModelRenderer headRenderer;
                    mainPart = headRenderer = ((BipedModel)entityModel).field_78116_c;
                    ModelRenderer headWearRenderer = ((BipedModel)entityModel).field_178720_f;
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headWearRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                }
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, entityModel, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                if (EntityIconDefinitions.fullModelIcon(entityModel)) {
                    mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelBodyPartsMethod, entityModel, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                }
            } else if (!forceFieldCheck && entityModel instanceof SegmentedModel && EntityIconDefinitions.fullModelIcon(entityModel)) {
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.segmentedModelPartsMethod, entityModel, renderedModels, null, this.r, this.g, this.b, this.a);
            } else {
                if (!forceFieldCheck && entityModel instanceof IHasHead) {
                    mainPart = ((IHasHead)entityModel).func_205072_a();
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                }
                if (mainPart == null) {
                    mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, EntityIconDefinitions.HEAD_HARDCODED_NAMES, true);
                }
                mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES, false);
            }
            renderTypeBuffer.func_228461_a_();
        }
        if ((extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(matrixStack, renderTypeBuffer, entityRenderer, entity, entityModel, this.entityModelPartsRenderer, renderedModels, mainPart);
        }
        entityModel.field_217114_e = isChildBU;
        return !renderedModels.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelRenderer[] handleDeclaredField(Field f, EntityModel entityModel) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue instanceof ModelRenderer[]) {
                ModelRenderer[] modelRendererArray = (ModelRenderer[])fieldValue;
                return modelRendererArray;
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (ModelRenderer)fieldValue;
            ModelRenderer[] modelRendererArray = ONE_RENDERER_ARRAY;
            return modelRendererArray;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public ModelRenderer searchSuperclassFields(IVertexBuilder vertexBuilder, EntityModel entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, ImmutableList<String> filter, boolean justOne) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != EntityModel.class && modelClass != AgeableModel.class && modelClass != SegmentedModel.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(vertexBuilder, entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public ModelRenderer handleFields(IVertexBuilder vertexBuilder, EntityModel entityModel, Field[] declaredModelFields, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, ImmutableList<String> filter, boolean justOne) {
        block7: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(ModelRenderer.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(ModelRenderer[].class);
                }
                catch (ClassCastException cce1) {
                    continue;
                }
            }
            try {
                ModelRenderer[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                if (filter != null && !filter.contains((Object)comparisonName)) continue;
                for (ModelRenderer mr : renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel)) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(this.matrixStack, vertexBuilder, mr, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                    if (justOne) break block7;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    public void setRGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }
}

