/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.type.RGBA;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public final class ComputedProperties {
    private final Minecraft mc;
    private final CustomCrosshair crosshair;
    private final int gap;
    private final RGBA colour;
    private final boolean isVisible;
    private final Set<Item> rangedWeapons = ImmutableSet.of((Object)Items.field_151031_f, (Object)Items.field_203184_eO, (Object)Items.field_222114_py);
    private final Set<Item> throwableItems = ImmutableSet.of((Object)Items.field_151079_bi, (Object)Items.field_151061_bv);
    private final Map<Item, Float> usageItemsDurations = ImmutableMap.of((Object)Items.field_151031_f, (Object)Float.valueOf(20.0f), (Object)Items.field_203184_eO, (Object)Float.valueOf(10.0f), (Object)Items.field_222114_py, (Object)Float.valueOf(0.0f));
    private final Set<Item> attackableItems = ImmutableSet.of((Object)Items.field_151041_m, (Object)Items.field_151010_B, (Object)Items.field_151052_q, (Object)Items.field_151040_l, (Object)Items.field_151048_u, (Object)Items.field_234754_kI_, (Object[])new Item[]{Items.field_151053_p, Items.field_151006_E, Items.field_151049_t, Items.field_151036_c, Items.field_151056_x, Items.field_234757_kL_, Items.field_151038_n, Items.field_151011_C, Items.field_151051_r, Items.field_151037_a, Items.field_151047_v, Items.field_234755_kJ_, Items.field_151039_o, Items.field_151005_D, Items.field_151050_s, Items.field_151035_b, Items.field_151046_w, Items.field_234756_kK_, Items.field_151017_I, Items.field_151013_M, Items.field_151018_J, Items.field_151019_K, Items.field_151012_L, Items.field_234758_kU_, Items.field_203184_eO});

    public ComputedProperties(CustomCrosshair crosshair) {
        this.mc = Minecraft.func_71410_x();
        this.crosshair = crosshair;
        this.gap = this.calculateGap();
        this.colour = this.calculateColour();
        this.isVisible = this.calculateIsVisible();
    }

    public int gap() {
        return this.gap;
    }

    public RGBA colour() {
        return this.colour;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private int calculateGap() {
        int baseGap = (Integer)this.crosshair.gap.get();
        if (this.mc.field_71439_g == null) {
            return baseGap;
        }
        boolean isSpectator = this.mc.field_71439_g.func_175149_v();
        boolean isHoldingItem = !this.mc.field_71439_g.func_184614_ca().func_190926_b() || !this.mc.field_71439_g.func_184592_cb().func_190926_b();
        boolean isDynamicBowEnabled = (Boolean)this.crosshair.isDynamicBowEnabled.get();
        boolean isDynamicAttackIndicatorEnabled = (Boolean)this.crosshair.isDynamicAttackIndicatorEnabled.get();
        if (isSpectator || !isHoldingItem || !isDynamicAttackIndicatorEnabled && !isDynamicBowEnabled) {
            return baseGap;
        }
        int gapModifier = 2;
        Float usageItemDuration = this.usageItemsDurations.get(this.mc.field_71439_g.func_184607_cu().func_77973_b());
        if (isDynamicBowEnabled && usageItemDuration != null) {
            float progress;
            if (this.mc.field_71439_g.func_184607_cu().func_77973_b() == Items.field_222114_py) {
                usageItemDuration = Float.valueOf(CrossbowItem.func_220026_e((ItemStack)this.mc.field_71439_g.func_184607_cu()));
                progress = Math.min(usageItemDuration.floatValue(), usageItemDuration.floatValue() - (float)this.mc.field_71439_g.func_184605_cv());
            } else {
                progress = Math.min(usageItemDuration.floatValue(), (float)this.mc.field_71439_g.func_184612_cw());
            }
            return baseGap + Math.round((usageItemDuration.floatValue() - progress) * (float)gapModifier);
        }
        if (isDynamicAttackIndicatorEnabled && this.attackableItems.contains(this.mc.field_71439_g.func_184614_ca().func_77973_b())) {
            float currentAttackUsage = this.mc.field_71439_g.func_184825_o(1.0f);
            float maxAttackUsage = 1.0f;
            if (this.mc.field_71439_g.func_184818_cX() > 5.0f && currentAttackUsage < maxAttackUsage) {
                return baseGap + Math.round((maxAttackUsage - currentAttackUsage) * (float)gapModifier * 20.0f);
            }
        }
        return baseGap;
    }

    private RGBA calculateColour() {
        Entity target = this.mc.field_147125_j;
        boolean isHighlightPlayersEnabled = (Boolean)this.crosshair.isHighlightPlayersEnabled.get();
        if (isHighlightPlayersEnabled && target instanceof PlayerEntity) {
            return (RGBA)this.crosshair.highlightPlayersColour.get();
        }
        boolean isHighlightHostilesEnabled = (Boolean)this.crosshair.isHighlightHostilesEnabled.get();
        if (isHighlightHostilesEnabled && (target instanceof MonsterEntity || target instanceof IAngerable)) {
            return (RGBA)this.crosshair.highlightHostilesColour.get();
        }
        boolean isHighlightPassivesEnabled = (Boolean)this.crosshair.isHighlightPassivesEnabled.get();
        if (isHighlightPassivesEnabled && target instanceof LivingEntity) {
            return (RGBA)this.crosshair.highlightPassivesColour.get();
        }
        if (((Boolean)this.crosshair.isRainbowEnabled.get()).booleanValue()) {
            return this.getRainbowColour();
        }
        return (RGBA)this.crosshair.colour.get();
    }

    private RGBA getRainbowColour() {
        int ticks = (Integer)this.crosshair.rainbowTicks.get() + 1;
        if (ticks > 125000) {
            ticks = 0;
        }
        this.crosshair.rainbowTicks.set(ticks);
        int opacity = ((RGBA)this.crosshair.colour.get()).getOpacity();
        int speed = (Integer)this.crosshair.rainbowSpeed.get();
        return new RGBA(255, 255, 255, opacity).setRed(this.getRainbowColourComponent(ticks, 0.0f, speed)).setGreen(this.getRainbowColourComponent(ticks, 2.0f, speed)).setBlue(this.getRainbowColourComponent(ticks, 4.0f, speed));
    }

    private int getRainbowColourComponent(int ticks, float offset, int speed) {
        return (int)(Math.sin((float)(ticks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }

    private boolean calculateIsVisible() {
        boolean isThirdPerson;
        if (this.mc.field_71439_g == null) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleDefault.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHiddenGui.get()).booleanValue() && this.mc.field_71474_y.field_74319_N) {
            return false;
        }
        PointOfView pov = this.mc.field_71474_y.func_243230_g();
        boolean bl = isThirdPerson = pov == PointOfView.THIRD_PERSON_BACK || pov == PointOfView.THIRD_PERSON_FRONT;
        if (!((Boolean)this.crosshair.isVisibleThirdPerson.get()).booleanValue() && isThirdPerson) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleDebug.get()).booleanValue() && this.mc.field_71474_y.field_74330_P) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleSpectator.get()).booleanValue() && this.mc.field_71439_g.func_175149_v()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHoldingRangedWeapon.get()).booleanValue() && this.isHoldingItem(this.mc.field_71439_g, this.rangedWeapons)) {
            return false;
        }
        return (Boolean)this.crosshair.isVisibleHoldingThrowableItem.get() != false || !this.isHoldingItem(this.mc.field_71439_g, this.throwableItems);
    }

    private boolean isHoldingItem(ClientPlayerEntity player, Set<Item> items) {
        ItemStack mainHandItem = player.func_184614_ca();
        boolean isMainHand = items.contains(mainHandItem.func_77973_b());
        boolean isOffhand = items.contains(player.func_184592_cb().func_77973_b());
        return isMainHand || isOffhand && mainHandItem.func_190926_b();
    }
}

