/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public final class CrosshairRenderManager {
    private final CustomCrosshair crosshair;
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<Item> itemCooldownItems = ImmutableSet.of((Object)Items.field_151079_bi, (Object)Items.field_185161_cS);

    public CrosshairRenderManager(CustomCrosshair crosshair) {
        this.crosshair = crosshair;
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(this.crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        MatrixStack matrixStack = new MatrixStack();
        RenderGameOverlayEvent eventParent = new RenderGameOverlayEvent(matrixStack, 1.0f, Minecraft.func_71410_x().func_228018_at_());
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(matrixStack, eventParent, RenderGameOverlayEvent.ElementType.CROSSHAIRS));
        ICrosshairStyle style = this.crosshairStyleFactory.from((CrosshairStyle)((Object)this.crosshair.style.get()), this.crosshair);
        boolean isItemCooldownEnabled = (Boolean)this.crosshair.isItemCooldownEnabled.get();
        boolean isDotEnabled = (Boolean)this.crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled) {
            this.drawItemCooldownIndicator(computedProperties, x, y);
        }
        if (isDotEnabled && this.crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(x, y, 0.5f, 1.0f, (RGBA)this.crosshair.dotColour.get());
        }
        this.drawDefaultAttackIndicator(matrixStack, computedProperties, x, y);
        this.preTransformation(x, y);
        style.draw(x, y, computedProperties);
        this.postTransformation();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(matrixStack, eventParent, RenderGameOverlayEvent.ElementType.CROSSHAIRS));
    }

    private void preTransformation(int x, int y) {
        int rotation = (Integer)this.crosshair.rotation.get();
        int scale = (Integer)this.crosshair.scale.get();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)((float)scale / 100.0f), (float)((float)scale / 100.0f), (float)1.0f);
        GL11.glRotatef((float)rotation, (float)x, (float)y, (float)8000.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    private void postTransformation() {
        GL11.glPopMatrix();
    }

    private void drawItemCooldownIndicator(ComputedProperties computedProperties, int x, int y) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)this.crosshair.itemCooldownColour.get();
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (Item item : this.itemCooldownItems) {
            float cooldown = player.func_184811_cZ().func_185143_a(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(MatrixStack matrixStack, ComputedProperties computedProperties, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71474_y.field_186716_M != AttackIndicatorStatus.CROSSHAIR) {
            return;
        }
        float cooledAttackStrength = mc.field_71439_g.func_184825_o(0.0f);
        boolean isActive = false;
        int j = mc.func_228018_at_().func_198087_p() / 2 - 7 + 16;
        int k = mc.func_228018_at_().func_198107_o() / 2 - 8;
        if (mc.field_147125_j instanceof LivingEntity && cooledAttackStrength >= 1.0f) {
            isActive = mc.field_71439_g.func_184818_cX() > 5.0f;
            isActive &= mc.field_147125_j.func_70089_S();
        }
        if (isActive) {
            AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)k, (int)j, (int)0, (float)68.0f, (float)94.0f, (int)16, (int)16, (int)256, (int)256);
        } else if (cooledAttackStrength < 1.0f) {
            int xPos = (int)(cooledAttackStrength * 17.0f);
            AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)k, (int)j, (int)0, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
            AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)k, (int)j, (int)0, (float)52.0f, (float)94.0f, (int)xPos, (int)4, (int)256, (int)256);
        }
    }
}

