/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style.styles;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.AbstractCrosshairStyle;
import com.wjbaker.ccm.type.RGBA;

public final class CrossStyle
extends AbstractCrosshairStyle {
    public CrossStyle(CustomCrosshair crosshair) {
        super(crosshair);
    }

    @Override
    public void draw(int x, int y, ComputedProperties computedProperties) {
        boolean isOutlineEnabled = (Boolean)this.crosshair.isOutlineEnabled.get();
        RGBA baseColour = computedProperties.colour();
        int gap = computedProperties.gap();
        float thickness = ((Integer)this.crosshair.thickness.get()).intValue();
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        if (isOutlineEnabled) {
            RGBA outlineColour = (RGBA)this.crosshair.outlineColour.get();
            float adjustedWidth = (float)width + 1.0f;
            float adjustedHeight = (float)height + 1.0f;
            float adjustedGap = (float)gap - 0.5f;
            this.renderManager.drawBorderedRectangle((float)x - thickness, (float)y - adjustedGap - adjustedHeight, (float)x + thickness, (float)y - adjustedGap, 2.0f, outlineColour, baseColour);
            this.renderManager.drawBorderedRectangle((float)x - thickness, (float)y + adjustedGap, (float)x + thickness, (float)y + adjustedGap + adjustedHeight, 2.0f, outlineColour, baseColour);
            this.renderManager.drawBorderedRectangle((float)x - adjustedGap - adjustedWidth, (float)y - thickness, (float)x - adjustedGap, (float)y + thickness, 2.0f, outlineColour, baseColour);
            this.renderManager.drawBorderedRectangle((float)x + adjustedGap, (float)y - thickness, (float)x + adjustedGap + adjustedWidth, (float)y + thickness, 2.0f, outlineColour, baseColour);
        } else {
            float adjustedThickness = thickness - 0.5f;
            this.renderManager.drawFilledRectangle((float)x - adjustedThickness, y - gap - height, (float)x + adjustedThickness, y - gap, baseColour);
            this.renderManager.drawFilledRectangle((float)x - adjustedThickness, y + gap, (float)x + adjustedThickness, y + gap + height, baseColour);
            this.renderManager.drawFilledRectangle(x - gap - width, (float)y - adjustedThickness, x - gap, (float)y + adjustedThickness, baseColour);
            this.renderManager.drawFilledRectangle(x + gap, (float)y - adjustedThickness, x + gap + width, (float)y + adjustedThickness, baseColour);
        }
    }
}

