/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.render.type.GuiBounds;
import com.wjbaker.ccm.render.type.IDrawInsideWindowCallback;
import com.wjbaker.ccm.type.RGBA;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public final class RenderManager {
    private void setGlProperty(int property, boolean isEnabled) {
        if (isEnabled) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    private void setColour(RGBA colour) {
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
    }

    private void preRender() {
        GL11.glPushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
    }

    private void postRender() {
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        GL11.glPopMatrix();
    }

    public void drawLines(float[] points, float thickness, RGBA colour) {
        this.setGlProperty(2848, false);
        GL11.glLineWidth((float)thickness);
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        this.preRender();
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.func_225582_a_((double)points[i], (double)points[i + 1], 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        this.postRender();
    }

    public void drawFilledShape(float[] points, RGBA colour) {
        this.setGlProperty(2848, false);
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(9, DefaultVertexFormats.field_181706_f);
        this.preRender();
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.func_225582_a_((double)points[i], (double)points[i + 1], 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        this.postRender();
    }

    public void drawLine(float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(new float[]{x1, y1, x2, y2}, thickness, colour);
    }

    public void drawRectangle(float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(new float[]{x1, y1, x2, y1, x2, y1, x2, y2, x1, y2, x2, y2, x1, y1, x1, y2}, thickness, colour);
    }

    public void drawFilledRectangle(float x1, float y1, float x2, float y2, RGBA colour) {
        this.drawFilledShape(new float[]{x1, y1, x1, y2, x2, y2, x2, y1}, colour);
    }

    public void drawBorderedRectangle(float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour) {
        this.drawFilledRectangle(x1, y1, x2, y2, fillColour);
        this.drawRectangle(x1, y1, x2, y2, borderThickness, borderColour);
    }

    public void drawPartialCircle(float x, float y, float radius, int startAngleAt, int endAngleAt, float thickness, RGBA colour) {
        this.setGlProperty(2848, true);
        int startAngle = Math.max(0, Math.min(startAngleAt, endAngleAt));
        int endAngle = Math.min(360, Math.max(startAngleAt, endAngleAt));
        GL11.glLineWidth((float)thickness);
        float ratio = (float)Math.PI / 180;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        this.preRender();
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.func_225582_a_((double)(x + (float)Math.cos(radians) * radius), (double)(y + (float)Math.sin(radians) * radius), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        this.postRender();
    }

    public void drawCircle(float x, float y, float radius, float thickness, RGBA colour) {
        this.drawPartialCircle(x, y, radius, 0, 360, thickness, colour);
    }

    public void drawFilledCircle(float x, float y, float radius, RGBA colour) {
        float[] points = new float[722];
        float ratio = (float)Math.PI / 180;
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            points[i * 2] = x + (float)Math.cos(radians) * radius;
            points[i * 2 + 1] = y + (float)Math.sin(radians) * radius;
        }
        this.drawFilledShape(points, colour);
    }

    public void drawTorus(int x, int y, int innerRadius, int outerRadius, RGBA colour) {
        this.setGlProperty(2848, true);
        this.setColour(colour);
        float ratio = (float)Math.PI / 180;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        this.preRender();
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.func_225582_a_((double)((float)x + (float)Math.cos(radians) * (float)innerRadius), (double)((float)y + (float)Math.sin(radians) * (float)innerRadius), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            bufferBuilder.func_225582_a_((double)((float)x + (float)Math.cos(radians) * (float)outerRadius), (double)((float)y + (float)Math.sin(radians) * (float)outerRadius), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        this.postRender();
    }

    public void drawText(String text, int x, int y, RGBA colour, boolean hasShadow) {
        int colourAsInt = this.rgbaAsInt(colour);
        if (hasShadow) {
            Minecraft.func_71410_x().field_71466_p.func_238405_a_(new MatrixStack(), text, (float)x, (float)y, colourAsInt);
        } else {
            Minecraft.func_71410_x().field_71466_p.func_238421_b_(new MatrixStack(), text, (float)x, (float)y, colourAsInt);
        }
    }

    public void drawSmallText(String text, int x, int y, RGBA colour, boolean hasShadow) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.drawText(text, x * 2, y * 2, colour, hasShadow);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
    }

    public void drawBigText(String text, int x, int y, RGBA colour, boolean hasShadow) {
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
        this.drawText(text, (int)((float)x * 0.666f), (int)((float)y * 0.666f), colour, hasShadow);
        float scale = 0.6666667f;
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
    }

    private int rgbaAsInt(RGBA colour) {
        return (colour.getOpacity() << 24) + (colour.getRed() << 16) + (colour.getGreen() << 8) + colour.getBlue();
    }

    public int textWidth(String text) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    public void drawInsideBounds(GuiBounds bounds, IDrawInsideWindowCallback callback) {
        this.setGlProperty(3089, true);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double scale = window.func_198100_s();
        GL11.glScissor((int)((int)Math.round((double)bounds.x() * scale)), (int)((int)Math.round((double)window.func_198083_n() - (double)bounds.y() * scale - (double)bounds.height() * scale)), (int)((int)Math.round((double)bounds.width() * scale)), (int)((int)Math.round((double)bounds.height() * scale)));
        callback.draw();
        this.setGlProperty(3089, false);
    }
}

