/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.component.components;

import com.wjbaker.ccm.render.gui.component.GuiComponent;
import com.wjbaker.ccm.render.gui.component.event.IGuiComponentEvent;
import com.wjbaker.ccm.render.gui.component.event.IOnClickEvent;
import com.wjbaker.ccm.render.gui.screen.GuiScreen;
import java.util.ArrayList;
import java.util.List;

public final class ButtonGuiComponent
extends GuiComponent {
    private final String label;
    private final List<IOnClickEvent> onClickEvents;

    public ButtonGuiComponent(GuiScreen parentGuiScreen, int x, int y, int width, int height, String label) {
        super(parentGuiScreen, x, y, width, height);
        this.label = label;
        this.onClickEvents = new ArrayList<IOnClickEvent>();
    }

    @Override
    public void draw() {
        super.draw();
        this.renderManager.drawBorderedRectangle(this.x, this.y, this.x + this.width, this.y + this.height, 2.0f, this.currentBorderColour, this.currentBackgroundColour);
        int centreX = this.x + this.width / 2 - this.renderManager.textWidth(this.label) / 2;
        int centreY = this.y + this.height / 2 - 3;
        this.renderManager.drawText(this.label, centreX, centreY, this.currentTextColour, false);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        this.isMouseDownInside = true;
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        if (button != 0 || !this.isInsideComponent(mouseX, mouseY) || !this.isMouseDownInside) {
            return;
        }
        for (IGuiComponentEvent onClickEvent : this.events(IOnClickEvent.class)) {
            onClickEvent.invoke();
        }
        this.isMouseDownInside = false;
    }
}

