/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.config.Constants;
import mezz.jei.gui.textures.JeiSpriteUploader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class DrawableNineSliceTexture {
    private final JeiSpriteUploader spriteUploader;
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private final int sliceLeft;
    private final int sliceRight;
    private final int sliceTop;
    private final int sliceBottom;

    public DrawableNineSliceTexture(JeiSpriteUploader spriteUploader, ResourceLocation location, int width, int height, int left, int right, int top, int bottom) {
        this.spriteUploader = spriteUploader;
        this.location = location;
        this.width = width;
        this.height = height;
        this.sliceLeft = left;
        this.sliceRight = right;
        this.sliceTop = top;
        this.sliceBottom = bottom;
    }

    public void draw(MatrixStack matrixStack, int xOffset, int yOffset, int width, int height) {
        TextureAtlasSprite sprite = this.spriteUploader.func_215282_a(this.location);
        int leftWidth = this.sliceLeft;
        int rightWidth = this.sliceRight;
        int topHeight = this.sliceTop;
        int bottomHeight = this.sliceBottom;
        int textureWidth = this.width;
        int textureHeight = this.height;
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uSize = uMax - uMin;
        float vSize = vMax - vMin;
        float uLeft = uMin + uSize * ((float)leftWidth / (float)textureWidth);
        float uRight = uMax - uSize * ((float)rightWidth / (float)textureWidth);
        float vTop = vMin + vSize * ((float)topHeight / (float)textureHeight);
        float vBottom = vMax - vSize * ((float)bottomHeight / (float)textureHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        DrawableNineSliceTexture.draw(bufferBuilder, matrix, uMin, vMin, uLeft, vTop, xOffset, yOffset, leftWidth, topHeight);
        DrawableNineSliceTexture.draw(bufferBuilder, matrix, uMin, vBottom, uLeft, vMax, xOffset, yOffset + height - bottomHeight, leftWidth, bottomHeight);
        DrawableNineSliceTexture.draw(bufferBuilder, matrix, uRight, vMin, uMax, vTop, xOffset + width - rightWidth, yOffset, rightWidth, topHeight);
        DrawableNineSliceTexture.draw(bufferBuilder, matrix, uRight, vBottom, uMax, vMax, xOffset + width - rightWidth, yOffset + height - bottomHeight, rightWidth, bottomHeight);
        int middleWidth = textureWidth - leftWidth - rightWidth;
        int middleHeight = textureWidth - topHeight - bottomHeight;
        int tiledMiddleWidth = width - leftWidth - rightWidth;
        int tiledMiddleHeight = height - topHeight - bottomHeight;
        if (tiledMiddleWidth > 0) {
            this.drawTiled(bufferBuilder, matrix, uLeft, vMin, uRight, vTop, xOffset + leftWidth, yOffset, tiledMiddleWidth, topHeight, middleWidth, topHeight);
            this.drawTiled(bufferBuilder, matrix, uLeft, vBottom, uRight, vMax, xOffset + leftWidth, yOffset + height - bottomHeight, tiledMiddleWidth, bottomHeight, middleWidth, bottomHeight);
        }
        if (tiledMiddleHeight > 0) {
            this.drawTiled(bufferBuilder, matrix, uMin, vTop, uLeft, vBottom, xOffset, yOffset + topHeight, leftWidth, tiledMiddleHeight, leftWidth, middleHeight);
            this.drawTiled(bufferBuilder, matrix, uRight, vTop, uMax, vBottom, xOffset + width - rightWidth, yOffset + topHeight, rightWidth, tiledMiddleHeight, rightWidth, middleHeight);
        }
        if (tiledMiddleHeight > 0 && tiledMiddleWidth > 0) {
            this.drawTiled(bufferBuilder, matrix, uLeft, vTop, uRight, vBottom, xOffset + leftWidth, yOffset + topHeight, tiledMiddleWidth, tiledMiddleHeight, middleWidth, middleHeight);
        }
        tessellator.func_78381_a();
    }

    private void drawTiled(BufferBuilder bufferBuilder, Matrix4f matrix, float uMin, float vMin, float uMax, float vMax, int xOffset, int yOffset, int tiledWidth, int tiledHeight, int width, int height) {
        int xTileCount = tiledWidth / width;
        int xRemainder = tiledWidth - xTileCount * width;
        int yTileCount = tiledHeight / height;
        int yRemainder = tiledHeight - yTileCount * height;
        int yStart = yOffset + tiledHeight;
        float uSize = uMax - uMin;
        float vSize = vMax - vMin;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileWidth = xTile == xTileCount ? xRemainder : width;
                int tileHeight = yTile == yTileCount ? yRemainder : height;
                int x = xOffset + xTile * width;
                int y = yStart - (yTile + 1) * height;
                if (tileWidth <= 0 || tileHeight <= 0) continue;
                int maskRight = width - tileWidth;
                int maskTop = height - tileHeight;
                float uOffset = (float)maskRight / (float)width * uSize;
                float vOffset = (float)maskTop / (float)height * vSize;
                DrawableNineSliceTexture.draw(bufferBuilder, matrix, uMin, vMin + vOffset, uMax - uOffset, vMax, x, y + maskTop, tileWidth, tileHeight);
            }
        }
    }

    private static void draw(BufferBuilder bufferBuilder, Matrix4f matrix, float minU, double minV, float maxU, float maxV, int xOffset, int yOffset, int width, int height) {
        bufferBuilder.func_227888_a_(matrix, (float)xOffset, (float)(yOffset + height), 0.0f).func_225583_a_(minU, maxV).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(xOffset + width), (float)(yOffset + height), 0.0f).func_225583_a_(maxU, maxV).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(xOffset + width), (float)yOffset, 0.0f).func_225583_a_(maxU, (float)minV).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)xOffset, (float)yOffset, 0.0f).func_225583_a_(minU, (float)minV).func_181675_d();
    }
}

