/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.renderer.Rectangle2d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiIngredientGroup<T>
implements IGuiIngredientGroup<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, GuiIngredient<T>> guiIngredients = new HashMap<Integer, GuiIngredient<T>>();
    private final Set<Integer> inputSlots = new HashSet<Integer>();
    private final Set<Integer> outputSlots = new HashSet<Integer>();
    private final IIngredientHelper<T> ingredientHelper;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final IIngredientType<T> ingredientType;
    private final int cycleOffset;
    @Nullable
    private Focus<T> focus;
    private final List<ITooltipCallback<T>> tooltipCallbacks = new ArrayList<ITooltipCallback<T>>();

    public GuiIngredientGroup(IIngredientType<T> ingredientType, @Nullable Focus<T> focus, int cycleOffset) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        this.ingredientType = ingredientType;
        this.focus = focus;
        IngredientManager ingredientManager = Internal.getIngredientManager();
        this.ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        this.ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.cycleOffset = cycleOffset;
    }

    @Override
    public void init(int slotIndex, boolean input, int xPosition, int yPosition) {
        this.init(slotIndex, input, this.ingredientRenderer, xPosition, yPosition, 16, 16, 0, 0);
    }

    @Override
    public void init(int slotIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xPadding, int yPadding) {
        Rectangle2d rect = new Rectangle2d(xPosition, yPosition, width, height);
        GuiIngredient<T> guiIngredient = new GuiIngredient<T>(slotIndex, input, ingredientRenderer, this.ingredientHelper, rect, xPadding, yPadding, this.cycleOffset);
        this.guiIngredients.put(slotIndex, guiIngredient);
        if (input) {
            this.inputSlots.add(slotIndex);
        } else {
            this.outputSlots.add(slotIndex);
        }
    }

    @Override
    public void set(IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(this.ingredientType);
        List<List<T>> outputs = ingredients.getOutputs(this.ingredientType);
        int inputIndex = 0;
        int outputIndex = 0;
        ArrayList<Integer> slots = new ArrayList<Integer>(this.guiIngredients.keySet());
        Collections.sort(slots);
        for (Integer slot : slots) {
            if (this.inputSlots.contains(slot)) {
                if (inputIndex >= inputs.size()) continue;
                List<T> input = inputs.get(inputIndex);
                ++inputIndex;
                this.set((int)slot, (T)input);
                continue;
            }
            if (outputIndex >= outputs.size()) continue;
            List<T> output = outputs.get(outputIndex);
            ++outputIndex;
            this.set((int)slot, (T)output);
        }
    }

    @Override
    public void set(int slotIndex, @Nullable List<T> ingredients) {
        GuiIngredient<T> guiIngredient;
        IFocus.Mode ingredientMode;
        if (ingredients != null) {
            for (T ingredient : ingredients) {
                Class<T> ingredientClass = this.ingredientType.getIngredientClass();
                if (ingredientClass.isInstance(ingredient) || ingredient == null) continue;
                LOGGER.error("Received wrong type of ingredient. Expected {}, got {}", ingredientClass, ingredient.getClass(), (Object)new IllegalArgumentException());
                return;
            }
        }
        IFocus.Mode mode = ingredientMode = (guiIngredient = this.guiIngredients.get(slotIndex)).isInput() ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT;
        if (this.focus == null || this.focus.getMode() == ingredientMode) {
            guiIngredient.set(ingredients, this.focus);
        } else {
            guiIngredient.set(ingredients, null);
        }
    }

    @Override
    public void set(int slotIndex, @Nullable T value) {
        this.set(slotIndex, (T)Collections.singletonList(value));
    }

    @Override
    public void setBackground(int slotIndex, IDrawable background) {
        GuiIngredient<T> guiIngredient = this.guiIngredients.get(slotIndex);
        guiIngredient.setBackground(background);
    }

    @Override
    public void addTooltipCallback(ITooltipCallback<T> tooltipCallback) {
        ErrorUtil.checkNotNull(this.tooltipCallbacks, "tooltipCallback");
        this.tooltipCallbacks.add(tooltipCallback);
    }

    @Override
    public Map<Integer, GuiIngredient<T>> getGuiIngredients() {
        return this.guiIngredients;
    }

    @Nullable
    public GuiIngredient<T> getHoveredIngredient(int xOffset, int yOffset, double mouseX, double mouseY) {
        for (GuiIngredient<T> ingredient : this.guiIngredients.values()) {
            if (!ingredient.isMouseOver(xOffset, yOffset, mouseX, mouseY)) continue;
            return ingredient;
        }
        return null;
    }

    public void draw(MatrixStack matrixStack, int xOffset, int yOffset, int highlightColor, int mouseX, int mouseY) {
        for (GuiIngredient<T> ingredient : this.guiIngredients.values()) {
            ingredient.draw(matrixStack, xOffset, yOffset);
            if (!ingredient.isMouseOver(xOffset, yOffset, mouseX, mouseY)) continue;
            ingredient.setTooltipCallbacks(this.tooltipCallbacks);
            ingredient.drawHighlight(matrixStack, highlightColor, xOffset, yOffset);
        }
    }

    @Override
    public void setOverrideDisplayFocus(@Nullable IFocus<T> focus) {
        this.focus = focus == null ? null : Focus.check(focus);
    }

    public Set<Integer> getOutputSlots() {
        return this.outputSlots;
    }

    public String getIngredientModId(T ingredient) {
        return this.ingredientHelper.getModId(ingredient);
    }
}

