/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EnchantingTableBlock
extends ContainerBlock {
    protected static final VoxelShape field_196322_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);

    protected EnchantingTableBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public boolean func_220074_n(BlockState blockState) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_196322_a;
    }

    @Override
    public void func_180655_c(BlockState blockState, World world, BlockPos blockPos, Random random) {
        super.func_180655_c(blockState, world, blockPos, random);
        for (int i = -2; i <= 2; ++i) {
            block1: for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                if (i > -2 && i < 2 && \u2603 == -1) {
                    \u2603 = 2;
                }
                if (random.nextInt(16) != 0) continue;
                for (\u2603 = 0; \u2603 <= 1; ++\u2603) {
                    BlockPos blockPos2 = blockPos.func_177982_a(i, \u2603, \u2603);
                    if (!world.func_180495_p(blockPos2).func_203425_a(Blocks.field_150342_X)) continue;
                    if (!world.func_175623_d(blockPos.func_177982_a(i / 2, 0, \u2603 / 2))) continue block1;
                    world.func_195594_a(ParticleTypes.field_197623_p, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 2.0, (double)blockPos.func_177952_p() + 0.5, (double)((float)i + random.nextFloat()) - 0.5, (float)\u2603 - random.nextFloat() - 1.0f, (double)((float)\u2603 + random.nextFloat()) - 0.5);
                }
            }
        }
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new EnchantingTableTileEntity();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        playerEntity.func_213829_a(blockState.func_215699_b(world, blockPos));
        return ActionResultType.CONSUME;
    }

    @Override
    @Nullable
    public INamedContainerProvider func_220052_b(BlockState blockState, World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof EnchantingTableTileEntity) {
            ITextComponent iTextComponent = ((INameable)((Object)tileEntity)).func_145748_c_();
            return new SimpleNamedContainerProvider((n, playerInventory, playerEntity) -> new EnchantmentContainer(n, playerInventory, IWorldPosCallable.func_221488_a(world, blockPos)), iTextComponent);
        }
        return null;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof EnchantingTableTileEntity) {
            ((EnchantingTableTileEntity)\u2603).func_200229_a(itemStack.func_200301_q());
        }
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

