/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.NarratorStatus;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.settings.ToggleableKeyBinding;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.HandSide;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.Difficulty;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameSettings {
    private static final Logger field_151454_ax = LogManager.getLogger();
    private static final Gson field_151450_ay = new Gson();
    private static final TypeToken<List<String>> field_151449_az = new TypeToken<List<String>>(){};
    private static final Splitter field_230003_aR_ = Splitter.on((char)':').limit(2);
    public double field_74341_c = 0.5;
    public int field_151451_c = -1;
    public float field_238329_c_ = 1.0f;
    public int field_74350_i = 120;
    public CloudOption field_74345_l = CloudOption.FANCY;
    public GraphicsFanciness field_238330_f_ = GraphicsFanciness.FANCY;
    public AmbientOcclusionStatus field_74348_k = AmbientOcclusionStatus.MAX;
    public List<String> field_151453_l = Lists.newArrayList();
    public List<String> field_183018_l = Lists.newArrayList();
    public ChatVisibility field_74343_n = ChatVisibility.FULL;
    public double field_74357_r = 1.0;
    public double field_238331_l_ = 0.0;
    public double field_216845_l = 0.5;
    @Nullable
    public String field_198019_u;
    public boolean field_80005_w;
    public boolean field_82882_x;
    public boolean field_82881_y = true;
    private final Set<PlayerModelPart> field_178882_aU = Sets.newHashSet((Object[])PlayerModelPart.values());
    public HandSide field_186715_A = HandSide.RIGHT;
    public int field_92118_B;
    public int field_92119_C;
    public boolean field_92117_D = true;
    public double field_96691_E = 1.0;
    public double field_96692_F = 1.0;
    public double field_96693_G = 0.44366195797920227;
    public double field_96694_H = 1.0;
    public double field_238332_z_ = 0.0;
    public int field_151442_I = 4;
    private final Map<SoundCategory, Float> field_186714_aM = Maps.newEnumMap(SoundCategory.class);
    public boolean field_181150_U = true;
    public AttackIndicatorStatus field_186716_M = AttackIndicatorStatus.CROSSHAIR;
    public TutorialSteps field_193631_S = TutorialSteps.MOVEMENT;
    public boolean field_244601_E = false;
    public int field_205217_U = 2;
    public double field_208033_V = 1.0;
    public boolean field_225307_E = true;
    public int field_209231_W = 1;
    public boolean field_189989_R = true;
    public boolean field_198018_T = true;
    public boolean field_74344_o = true;
    public boolean field_74359_p = true;
    public boolean field_74358_q = true;
    public boolean field_74352_v = true;
    public boolean field_181151_V = true;
    public boolean field_211842_aO;
    public boolean field_74338_d;
    public boolean field_216843_O;
    public boolean field_183509_X = true;
    public boolean field_178879_v;
    public boolean field_74355_t = true;
    public boolean field_186717_N;
    public boolean field_216844_T = true;
    public boolean field_85185_A;
    public boolean field_74353_u;
    public boolean field_74336_f = true;
    public boolean field_228044_Y_;
    public boolean field_228045_Z_;
    public boolean field_230152_Z_;
    public boolean field_244794_ae = true;
    public final KeyBinding field_74351_w = new KeyBinding("key.forward", 87, "key.categories.movement");
    public final KeyBinding field_74370_x = new KeyBinding("key.left", 65, "key.categories.movement");
    public final KeyBinding field_74368_y = new KeyBinding("key.back", 83, "key.categories.movement");
    public final KeyBinding field_74366_z = new KeyBinding("key.right", 68, "key.categories.movement");
    public final KeyBinding field_74314_A = new KeyBinding("key.jump", 32, "key.categories.movement");
    public final KeyBinding field_228046_af_ = new ToggleableKeyBinding("key.sneak", 340, "key.categories.movement", () -> this.field_228044_Y_);
    public final KeyBinding field_151444_V = new ToggleableKeyBinding("key.sprint", 341, "key.categories.movement", () -> this.field_228045_Z_);
    public final KeyBinding field_151445_Q = new KeyBinding("key.inventory", 69, "key.categories.inventory");
    public final KeyBinding field_186718_X = new KeyBinding("key.swapOffhand", 70, "key.categories.inventory");
    public final KeyBinding field_74316_C = new KeyBinding("key.drop", 81, "key.categories.inventory");
    public final KeyBinding field_74313_G = new KeyBinding("key.use", InputMappings.Type.MOUSE, 1, "key.categories.gameplay");
    public final KeyBinding field_74312_F = new KeyBinding("key.attack", InputMappings.Type.MOUSE, 0, "key.categories.gameplay");
    public final KeyBinding field_74322_I = new KeyBinding("key.pickItem", InputMappings.Type.MOUSE, 2, "key.categories.gameplay");
    public final KeyBinding field_74310_D = new KeyBinding("key.chat", 84, "key.categories.multiplayer");
    public final KeyBinding field_74321_H = new KeyBinding("key.playerlist", 258, "key.categories.multiplayer");
    public final KeyBinding field_74323_J = new KeyBinding("key.command", 47, "key.categories.multiplayer");
    public final KeyBinding field_244602_au = new KeyBinding("key.socialInteractions", 80, "key.categories.multiplayer");
    public final KeyBinding field_151447_Z = new KeyBinding("key.screenshot", 291, "key.categories.misc");
    public final KeyBinding field_151457_aa = new KeyBinding("key.togglePerspective", 294, "key.categories.misc");
    public final KeyBinding field_151458_ab = new KeyBinding("key.smoothCamera", InputMappings.field_197958_a.func_197937_c(), "key.categories.misc");
    public final KeyBinding field_152395_am = new KeyBinding("key.fullscreen", 300, "key.categories.misc");
    public final KeyBinding field_178883_an = new KeyBinding("key.spectatorOutlines", InputMappings.field_197958_a.func_197937_c(), "key.categories.misc");
    public final KeyBinding field_194146_ao = new KeyBinding("key.advancements", 76, "key.categories.misc");
    public final KeyBinding[] field_151456_ac = new KeyBinding[]{new KeyBinding("key.hotbar.1", 49, "key.categories.inventory"), new KeyBinding("key.hotbar.2", 50, "key.categories.inventory"), new KeyBinding("key.hotbar.3", 51, "key.categories.inventory"), new KeyBinding("key.hotbar.4", 52, "key.categories.inventory"), new KeyBinding("key.hotbar.5", 53, "key.categories.inventory"), new KeyBinding("key.hotbar.6", 54, "key.categories.inventory"), new KeyBinding("key.hotbar.7", 55, "key.categories.inventory"), new KeyBinding("key.hotbar.8", 56, "key.categories.inventory"), new KeyBinding("key.hotbar.9", 57, "key.categories.inventory")};
    public final KeyBinding field_193629_ap = new KeyBinding("key.saveToolbarActivator", 67, "key.categories.creative");
    public final KeyBinding field_193630_aq = new KeyBinding("key.loadToolbarActivator", 88, "key.categories.creative");
    public final KeyBinding[] field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.field_74312_F, this.field_74313_G, this.field_74351_w, this.field_74370_x, this.field_74368_y, this.field_74366_z, this.field_74314_A, this.field_228046_af_, this.field_151444_V, this.field_74316_C, this.field_151445_Q, this.field_74310_D, this.field_74321_H, this.field_74322_I, this.field_74323_J, this.field_244602_au, this.field_151447_Z, this.field_151457_aa, this.field_151458_ab, this.field_152395_am, this.field_178883_an, this.field_186718_X, this.field_193629_ap, this.field_193630_aq, this.field_194146_ao}, (Object[])this.field_151456_ac);
    protected Minecraft field_74317_L;
    private final File field_74354_ai;
    public Difficulty field_74318_M = Difficulty.NORMAL;
    public boolean field_74319_N;
    private PointOfView field_243228_bb = PointOfView.FIRST_PERSON;
    public boolean field_74330_P;
    public boolean field_74329_Q;
    public boolean field_181657_aC;
    public String field_74332_R = "";
    public boolean field_74326_T;
    public double field_74334_X = 70.0;
    public float field_243226_aM = 1.0f;
    public float field_243227_aN = 1.0f;
    public double field_74333_Y;
    public int field_74335_Z;
    public ParticleStatus field_74362_aa = ParticleStatus.ALL;
    public NarratorStatus field_192571_R = NarratorStatus.OFF;
    public String field_74363_ab = "en_us";
    public boolean field_241568_aS_;

    public GameSettings(Minecraft minecraft, File file) {
        this.field_74317_L = minecraft;
        this.field_74354_ai = new File(file, "options.txt");
        if (minecraft.func_147111_S() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            AbstractOption.field_216706_m.func_216728_a(32.0f);
        } else {
            AbstractOption.field_216706_m.func_216728_a(16.0f);
        }
        this.field_151451_c = minecraft.func_147111_S() ? 12 : 8;
        this.field_241568_aS_ = Util.func_110647_a() == Util.OS.WINDOWS;
        this.func_74300_a();
    }

    public float func_216840_a(float f) {
        return this.field_216844_T ? f : (float)this.field_216845_l;
    }

    public int func_216841_b(float f) {
        return (int)(this.func_216840_a(f) * 255.0f) << 24 & 0xFF000000;
    }

    public int func_216839_a(int n) {
        return this.field_216844_T ? n : (int)(this.field_216845_l * 255.0) << 24 & 0xFF000000;
    }

    public void func_198014_a(KeyBinding keyBinding, InputMappings.Input input) {
        keyBinding.func_197979_b(input);
        this.func_74303_b();
    }

    public void func_74300_a() {
        try {
            if (!this.field_74354_ai.exists()) {
                return;
            }
            this.field_186714_aM.clear();
            CompoundNBT compoundNBT = new CompoundNBT();
            BufferedReader \u26032 = Files.newReader((File)this.field_74354_ai, (Charset)Charsets.UTF_8);
            Object object = null;
            try {
                \u26032.lines().forEach(string -> {
                    try {
                        Iterator iterator = field_230003_aR_.split((CharSequence)string).iterator();
                        compoundNBT.func_74778_a((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception) {
                        field_151454_ax.warn("Skipping bad option: {}", string);
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (\u26032 != null) {
                    if (object != null) {
                        try {
                            \u26032.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        \u26032.close();
                    }
                }
            }
            CompoundNBT compoundNBT2 = this.func_189988_a(compoundNBT);
            if (!compoundNBT2.func_74764_b("graphicsMode") && compoundNBT2.func_74764_b("fancyGraphics")) {
                this.field_238330_f_ = "true".equals(compoundNBT2.func_74779_i("fancyGraphics")) ? GraphicsFanciness.FANCY : GraphicsFanciness.FAST;
            }
            for (String string2 : compoundNBT2.func_150296_c()) {
                String string3 = compoundNBT2.func_74779_i(string2);
                try {
                    if ("autoJump".equals(string2)) {
                        AbstractOption.field_216719_z.func_216742_a(this, string3);
                    }
                    if ("autoSuggestions".equals(string2)) {
                        AbstractOption.field_216677_A.func_216742_a(this, string3);
                    }
                    if ("chatColors".equals(string2)) {
                        AbstractOption.field_216678_B.func_216742_a(this, string3);
                    }
                    if ("chatLinks".equals(string2)) {
                        AbstractOption.field_216679_C.func_216742_a(this, string3);
                    }
                    if ("chatLinksPrompt".equals(string2)) {
                        AbstractOption.field_216680_D.func_216742_a(this, string3);
                    }
                    if ("enableVsync".equals(string2)) {
                        AbstractOption.field_216682_F.func_216742_a(this, string3);
                    }
                    if ("entityShadows".equals(string2)) {
                        AbstractOption.field_216683_G.func_216742_a(this, string3);
                    }
                    if ("forceUnicodeFont".equals(string2)) {
                        AbstractOption.field_216684_H.func_216742_a(this, string3);
                    }
                    if ("discrete_mouse_scroll".equals(string2)) {
                        AbstractOption.field_216681_E.func_216742_a(this, string3);
                    }
                    if ("invertYMouse".equals(string2)) {
                        AbstractOption.field_216685_I.func_216742_a(this, string3);
                    }
                    if ("realmsNotifications".equals(string2)) {
                        AbstractOption.field_216686_J.func_216742_a(this, string3);
                    }
                    if ("reducedDebugInfo".equals(string2)) {
                        AbstractOption.field_216687_K.func_216742_a(this, string3);
                    }
                    if ("showSubtitles".equals(string2)) {
                        AbstractOption.field_216688_L.func_216742_a(this, string3);
                    }
                    if ("snooperEnabled".equals(string2)) {
                        AbstractOption.field_216689_M.func_216742_a(this, string3);
                    }
                    if ("touchscreen".equals(string2)) {
                        AbstractOption.field_216690_N.func_216742_a(this, string3);
                    }
                    if ("fullscreen".equals(string2)) {
                        AbstractOption.field_216691_O.func_216742_a(this, string3);
                    }
                    if ("bobView".equals(string2)) {
                        AbstractOption.field_216692_P.func_216742_a(this, string3);
                    }
                    if ("toggleCrouch".equals(string2)) {
                        this.field_228044_Y_ = "true".equals(string3);
                    }
                    if ("toggleSprint".equals(string2)) {
                        this.field_228045_Z_ = "true".equals(string3);
                    }
                    if ("mouseSensitivity".equals(string2)) {
                        this.field_74341_c = GameSettings.func_74305_a(string3);
                    }
                    if ("fov".equals(string2)) {
                        this.field_74334_X = GameSettings.func_74305_a(string3) * 40.0f + 70.0f;
                    }
                    if ("screenEffectScale".equals(string2)) {
                        this.field_243226_aM = GameSettings.func_74305_a(string3);
                    }
                    if ("fovEffectScale".equals(string2)) {
                        this.field_243227_aN = GameSettings.func_74305_a(string3);
                    }
                    if ("gamma".equals(string2)) {
                        this.field_74333_Y = GameSettings.func_74305_a(string3);
                    }
                    if ("renderDistance".equals(string2)) {
                        this.field_151451_c = Integer.parseInt(string3);
                    }
                    if ("entityDistanceScaling".equals(string2)) {
                        this.field_238329_c_ = Float.parseFloat(string3);
                    }
                    if ("guiScale".equals(string2)) {
                        this.field_74335_Z = Integer.parseInt(string3);
                    }
                    if ("particles".equals(string2)) {
                        this.field_74362_aa = ParticleStatus.func_216833_a(Integer.parseInt(string3));
                    }
                    if ("maxFps".equals(string2)) {
                        this.field_74350_i = Integer.parseInt(string3);
                        if (this.field_74317_L.func_228018_at_() != null) {
                            this.field_74317_L.func_228018_at_().func_216526_a(this.field_74350_i);
                        }
                    }
                    if ("difficulty".equals(string2)) {
                        this.field_74318_M = Difficulty.func_151523_a(Integer.parseInt(string3));
                    }
                    if ("graphicsMode".equals(string2)) {
                        this.field_238330_f_ = GraphicsFanciness.func_238163_a_(Integer.parseInt(string3));
                    }
                    if ("tutorialStep".equals(string2)) {
                        this.field_193631_S = TutorialSteps.func_193307_a(string3);
                    }
                    if ("ao".equals(string2)) {
                        this.field_74348_k = "true".equals(string3) ? AmbientOcclusionStatus.MAX : ("false".equals(string3) ? AmbientOcclusionStatus.OFF : AmbientOcclusionStatus.func_216570_a(Integer.parseInt(string3)));
                    }
                    if ("renderClouds".equals(string2)) {
                        if ("true".equals(string3)) {
                            this.field_74345_l = CloudOption.FANCY;
                        } else if ("false".equals(string3)) {
                            this.field_74345_l = CloudOption.OFF;
                        } else if ("fast".equals(string3)) {
                            this.field_74345_l = CloudOption.FAST;
                        }
                    }
                    if ("attackIndicator".equals(string2)) {
                        this.field_186716_M = AttackIndicatorStatus.func_216749_a(Integer.parseInt(string3));
                    }
                    if ("resourcePacks".equals(string2)) {
                        this.field_151453_l = JSONUtils.func_233012_a_(field_151450_ay, string3, field_151449_az);
                        if (this.field_151453_l == null) {
                            this.field_151453_l = Lists.newArrayList();
                        }
                    }
                    if ("incompatibleResourcePacks".equals(string2)) {
                        this.field_183018_l = JSONUtils.func_233012_a_(field_151450_ay, string3, field_151449_az);
                        if (this.field_183018_l == null) {
                            this.field_183018_l = Lists.newArrayList();
                        }
                    }
                    if ("lastServer".equals(string2)) {
                        this.field_74332_R = string3;
                    }
                    if ("lang".equals(string2)) {
                        this.field_74363_ab = string3;
                    }
                    if ("chatVisibility".equals(string2)) {
                        this.field_74343_n = ChatVisibility.func_221252_a(Integer.parseInt(string3));
                    }
                    if ("chatOpacity".equals(string2)) {
                        this.field_74357_r = GameSettings.func_74305_a(string3);
                    }
                    if ("chatLineSpacing".equals(string2)) {
                        this.field_238331_l_ = GameSettings.func_74305_a(string3);
                    }
                    if ("textBackgroundOpacity".equals(string2)) {
                        this.field_216845_l = GameSettings.func_74305_a(string3);
                    }
                    if ("backgroundForChatOnly".equals(string2)) {
                        this.field_216844_T = "true".equals(string3);
                    }
                    if ("fullscreenResolution".equals(string2)) {
                        this.field_198019_u = string3;
                    }
                    if ("hideServerAddress".equals(string2)) {
                        this.field_80005_w = "true".equals(string3);
                    }
                    if ("advancedItemTooltips".equals(string2)) {
                        this.field_82882_x = "true".equals(string3);
                    }
                    if ("pauseOnLostFocus".equals(string2)) {
                        this.field_82881_y = "true".equals(string3);
                    }
                    if ("overrideHeight".equals(string2)) {
                        this.field_92119_C = Integer.parseInt(string3);
                    }
                    if ("overrideWidth".equals(string2)) {
                        this.field_92118_B = Integer.parseInt(string3);
                    }
                    if ("heldItemTooltips".equals(string2)) {
                        this.field_92117_D = "true".equals(string3);
                    }
                    if ("chatHeightFocused".equals(string2)) {
                        this.field_96694_H = GameSettings.func_74305_a(string3);
                    }
                    if ("chatDelay".equals(string2)) {
                        this.field_238332_z_ = GameSettings.func_74305_a(string3);
                    }
                    if ("chatHeightUnfocused".equals(string2)) {
                        this.field_96693_G = GameSettings.func_74305_a(string3);
                    }
                    if ("chatScale".equals(string2)) {
                        this.field_96691_E = GameSettings.func_74305_a(string3);
                    }
                    if ("chatWidth".equals(string2)) {
                        this.field_96692_F = GameSettings.func_74305_a(string3);
                    }
                    if ("mipmapLevels".equals(string2)) {
                        this.field_151442_I = Integer.parseInt(string3);
                    }
                    if ("useNativeTransport".equals(string2)) {
                        this.field_181150_U = "true".equals(string3);
                    }
                    if ("mainHand".equals(string2)) {
                        HandSide handSide = this.field_186715_A = "left".equals(string3) ? HandSide.LEFT : HandSide.RIGHT;
                    }
                    if ("narrator".equals(string2)) {
                        this.field_192571_R = NarratorStatus.func_216825_a(Integer.parseInt(string3));
                    }
                    if ("biomeBlendRadius".equals(string2)) {
                        this.field_205217_U = Integer.parseInt(string3);
                    }
                    if ("mouseWheelSensitivity".equals(string2)) {
                        this.field_208033_V = GameSettings.func_74305_a(string3);
                    }
                    if ("rawMouseInput".equals(string2)) {
                        this.field_225307_E = "true".equals(string3);
                    }
                    if ("glDebugVerbosity".equals(string2)) {
                        this.field_209231_W = Integer.parseInt(string3);
                    }
                    if ("skipMultiplayerWarning".equals(string2)) {
                        this.field_230152_Z_ = "true".equals(string3);
                    }
                    if ("hideMatchedNames".equals(string2)) {
                        this.field_244794_ae = "true".equals(string3);
                    }
                    if ("joinedFirstServer".equals(string2)) {
                        this.field_244601_E = "true".equals(string3);
                    }
                    if ("syncChunkWrites".equals(string2)) {
                        this.field_241568_aS_ = "true".equals(string3);
                    }
                    for (KeyBinding keyBinding : this.field_74324_K) {
                        if (!string2.equals("key_" + keyBinding.func_151464_g())) continue;
                        keyBinding.func_197979_b(InputMappings.func_197955_a(string3));
                    }
                    for (SoundCategory soundCategory : SoundCategory.values()) {
                        if (!string2.equals("soundCategory_" + soundCategory.func_187948_a())) continue;
                        this.field_186714_aM.put(soundCategory, Float.valueOf(GameSettings.func_74305_a(string3)));
                    }
                    for (PlayerModelPart playerModelPart : PlayerModelPart.values()) {
                        if (!string2.equals("modelPart_" + playerModelPart.func_179329_c())) continue;
                        this.func_178878_a(playerModelPart, "true".equals(string3));
                    }
                }
                catch (Exception exception) {
                    field_151454_ax.warn("Skipping bad option: {}:{}", (Object)string2, (Object)string3);
                }
            }
            KeyBinding.func_74508_b();
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to load options", (Throwable)exception);
        }
    }

    private CompoundNBT func_189988_a(CompoundNBT compoundNBT) {
        int n = 0;
        try {
            n = Integer.parseInt(compoundNBT.func_74779_i("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NBTUtil.func_210822_a(this.field_74317_L.func_184126_aj(), DefaultTypeReferences.OPTIONS, compoundNBT, n);
    }

    private static float func_74305_a(String string) {
        if ("true".equals(string)) {
            return 1.0f;
        }
        if ("false".equals(string)) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public void func_74303_b() {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.field_74354_ai), StandardCharsets.UTF_8));){
            printWriter.println("version:" + SharedConstants.func_215069_a().getWorldVersion());
            printWriter.println("autoJump:" + AbstractOption.field_216719_z.func_216741_b(this));
            printWriter.println("autoSuggestions:" + AbstractOption.field_216677_A.func_216741_b(this));
            printWriter.println("chatColors:" + AbstractOption.field_216678_B.func_216741_b(this));
            printWriter.println("chatLinks:" + AbstractOption.field_216679_C.func_216741_b(this));
            printWriter.println("chatLinksPrompt:" + AbstractOption.field_216680_D.func_216741_b(this));
            printWriter.println("enableVsync:" + AbstractOption.field_216682_F.func_216741_b(this));
            printWriter.println("entityShadows:" + AbstractOption.field_216683_G.func_216741_b(this));
            printWriter.println("forceUnicodeFont:" + AbstractOption.field_216684_H.func_216741_b(this));
            printWriter.println("discrete_mouse_scroll:" + AbstractOption.field_216681_E.func_216741_b(this));
            printWriter.println("invertYMouse:" + AbstractOption.field_216685_I.func_216741_b(this));
            printWriter.println("realmsNotifications:" + AbstractOption.field_216686_J.func_216741_b(this));
            printWriter.println("reducedDebugInfo:" + AbstractOption.field_216687_K.func_216741_b(this));
            printWriter.println("snooperEnabled:" + AbstractOption.field_216689_M.func_216741_b(this));
            printWriter.println("showSubtitles:" + AbstractOption.field_216688_L.func_216741_b(this));
            printWriter.println("touchscreen:" + AbstractOption.field_216690_N.func_216741_b(this));
            printWriter.println("fullscreen:" + AbstractOption.field_216691_O.func_216741_b(this));
            printWriter.println("bobView:" + AbstractOption.field_216692_P.func_216741_b(this));
            printWriter.println("toggleCrouch:" + this.field_228044_Y_);
            printWriter.println("toggleSprint:" + this.field_228045_Z_);
            printWriter.println("mouseSensitivity:" + this.field_74341_c);
            printWriter.println("fov:" + (this.field_74334_X - 70.0) / 40.0);
            printWriter.println("screenEffectScale:" + this.field_243226_aM);
            printWriter.println("fovEffectScale:" + this.field_243227_aN);
            printWriter.println("gamma:" + this.field_74333_Y);
            printWriter.println("renderDistance:" + this.field_151451_c);
            printWriter.println("entityDistanceScaling:" + this.field_238329_c_);
            printWriter.println("guiScale:" + this.field_74335_Z);
            printWriter.println("particles:" + this.field_74362_aa.func_216832_b());
            printWriter.println("maxFps:" + this.field_74350_i);
            printWriter.println("difficulty:" + this.field_74318_M.func_151525_a());
            printWriter.println("graphicsMode:" + this.field_238330_f_.func_238162_a_());
            printWriter.println("ao:" + this.field_74348_k.func_216572_a());
            printWriter.println("biomeBlendRadius:" + this.field_205217_U);
            switch (this.field_74345_l) {
                case FANCY: {
                    printWriter.println("renderClouds:true");
                    break;
                }
                case FAST: {
                    printWriter.println("renderClouds:fast");
                    break;
                }
                case OFF: {
                    printWriter.println("renderClouds:false");
                }
            }
            printWriter.println("resourcePacks:" + field_151450_ay.toJson(this.field_151453_l));
            printWriter.println("incompatibleResourcePacks:" + field_151450_ay.toJson(this.field_183018_l));
            printWriter.println("lastServer:" + this.field_74332_R);
            printWriter.println("lang:" + this.field_74363_ab);
            printWriter.println("chatVisibility:" + this.field_74343_n.func_221254_a());
            printWriter.println("chatOpacity:" + this.field_74357_r);
            printWriter.println("chatLineSpacing:" + this.field_238331_l_);
            printWriter.println("textBackgroundOpacity:" + this.field_216845_l);
            printWriter.println("backgroundForChatOnly:" + this.field_216844_T);
            if (this.field_74317_L.func_228018_at_().func_198106_d().isPresent()) {
                printWriter.println("fullscreenResolution:" + this.field_74317_L.func_228018_at_().func_198106_d().get().func_198066_g());
            }
            printWriter.println("hideServerAddress:" + this.field_80005_w);
            printWriter.println("advancedItemTooltips:" + this.field_82882_x);
            printWriter.println("pauseOnLostFocus:" + this.field_82881_y);
            printWriter.println("overrideWidth:" + this.field_92118_B);
            printWriter.println("overrideHeight:" + this.field_92119_C);
            printWriter.println("heldItemTooltips:" + this.field_92117_D);
            printWriter.println("chatHeightFocused:" + this.field_96694_H);
            printWriter.println("chatDelay: " + this.field_238332_z_);
            printWriter.println("chatHeightUnfocused:" + this.field_96693_G);
            printWriter.println("chatScale:" + this.field_96691_E);
            printWriter.println("chatWidth:" + this.field_96692_F);
            printWriter.println("mipmapLevels:" + this.field_151442_I);
            printWriter.println("useNativeTransport:" + this.field_181150_U);
            printWriter.println("mainHand:" + (this.field_186715_A == HandSide.LEFT ? "left" : "right"));
            printWriter.println("attackIndicator:" + this.field_186716_M.func_216751_a());
            printWriter.println("narrator:" + this.field_192571_R.func_216827_a());
            printWriter.println("tutorialStep:" + this.field_193631_S.func_193308_a());
            printWriter.println("mouseWheelSensitivity:" + this.field_208033_V);
            printWriter.println("rawMouseInput:" + AbstractOption.field_225302_l.func_216741_b(this));
            printWriter.println("glDebugVerbosity:" + this.field_209231_W);
            printWriter.println("skipMultiplayerWarning:" + this.field_230152_Z_);
            printWriter.println("hideMatchedNames:" + this.field_244794_ae);
            printWriter.println("joinedFirstServer:" + this.field_244601_E);
            printWriter.println("syncChunkWrites:" + this.field_241568_aS_);
            for (KeyBinding keyBinding : this.field_74324_K) {
                printWriter.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m());
            }
            for (SoundCategory soundCategory : SoundCategory.values()) {
                printWriter.println("soundCategory_" + soundCategory.func_187948_a() + ":" + this.func_186711_a(soundCategory));
            }
            for (PlayerModelPart playerModelPart : PlayerModelPart.values()) {
                printWriter.println("modelPart_" + playerModelPart.func_179329_c() + ":" + this.field_178882_aU.contains((Object)playerModelPart));
            }
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to save options", (Throwable)exception);
        }
        this.func_82879_c();
    }

    public float func_186711_a(SoundCategory soundCategory) {
        if (this.field_186714_aM.containsKey((Object)soundCategory)) {
            return this.field_186714_aM.get((Object)soundCategory).floatValue();
        }
        return 1.0f;
    }

    public void func_186712_a(SoundCategory soundCategory, float f) {
        this.field_186714_aM.put(soundCategory, Float.valueOf(f));
        this.field_74317_L.func_147118_V().func_184399_a(soundCategory, f);
    }

    public void func_82879_c() {
        if (this.field_74317_L.field_71439_g != null) {
            int n = 0;
            for (PlayerModelPart playerModelPart : this.field_178882_aU) {
                n |= playerModelPart.func_179327_a();
            }
            this.field_74317_L.field_71439_g.field_71174_a.func_147297_a(new CClientSettingsPacket(this.field_74363_ab, this.field_151451_c, this.field_74343_n, this.field_74344_o, n, this.field_186715_A));
        }
    }

    public Set<PlayerModelPart> func_178876_d() {
        return ImmutableSet.copyOf(this.field_178882_aU);
    }

    public void func_178878_a(PlayerModelPart playerModelPart, boolean bl) {
        if (bl) {
            this.field_178882_aU.add(playerModelPart);
        } else {
            this.field_178882_aU.remove((Object)playerModelPart);
        }
        this.func_82879_c();
    }

    public void func_178877_a(PlayerModelPart playerModelPart) {
        if (this.func_178876_d().contains((Object)playerModelPart)) {
            this.field_178882_aU.remove((Object)playerModelPart);
        } else {
            this.field_178882_aU.add(playerModelPart);
        }
        this.func_82879_c();
    }

    public CloudOption func_216842_e() {
        if (this.field_151451_c >= 4) {
            return this.field_74345_l;
        }
        return CloudOption.OFF;
    }

    public boolean func_181148_f() {
        return this.field_181150_U;
    }

    public void func_198017_a(ResourcePackList resourcePackList) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        Iterator<String> \u26032 = this.field_151453_l.iterator();
        while (\u26032.hasNext()) {
            String string = \u26032.next();
            ResourcePackInfo \u26033 = resourcePackList.func_198981_a(string);
            if (\u26033 == null && !string.startsWith("file/")) {
                \u26033 = resourcePackList.func_198981_a("file/" + string);
            }
            if (\u26033 == null) {
                field_151454_ax.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)string);
                \u26032.remove();
                continue;
            }
            if (!\u26033.func_195791_d().func_198968_a() && !this.field_183018_l.contains(string)) {
                field_151454_ax.warn("Removed resource pack {} from options because it is no longer compatible", (Object)string);
                \u26032.remove();
                continue;
            }
            if (\u26033.func_195791_d().func_198968_a() && this.field_183018_l.contains(string)) {
                field_151454_ax.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)string);
                this.field_183018_l.remove(string);
                continue;
            }
            linkedHashSet.add(\u26033.func_195790_f());
        }
        resourcePackList.func_198985_a(linkedHashSet);
    }

    public PointOfView func_243230_g() {
        return this.field_243228_bb;
    }

    public void func_243229_a(PointOfView pointOfView) {
        this.field_243228_bb = pointOfView;
    }
}

