/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.PlatformDescriptors;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class DebugOverlayGui
extends AbstractGui {
    private static final Map<Heightmap.Type, String> field_212923_a = Util.func_200696_a(new EnumMap(Heightmap.Type.class), enumMap -> {
        enumMap.put(Heightmap.Type.WORLD_SURFACE_WG, "SW");
        enumMap.put(Heightmap.Type.WORLD_SURFACE, "S");
        enumMap.put(Heightmap.Type.OCEAN_FLOOR_WG, "OW");
        enumMap.put(Heightmap.Type.OCEAN_FLOOR, "O");
        enumMap.put(Heightmap.Type.MOTION_BLOCKING, "M");
        enumMap.put(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft field_175242_a;
    private final FontRenderer field_175241_f;
    private RayTraceResult field_211537_g;
    private RayTraceResult field_211538_h;
    @Nullable
    private ChunkPos field_212924_f;
    @Nullable
    private Chunk field_212925_g;
    @Nullable
    private CompletableFuture<Chunk> field_212926_h;

    public DebugOverlayGui(Minecraft minecraft) {
        this.field_175242_a = minecraft;
        this.field_175241_f = minecraft.field_71466_p;
    }

    public void func_212921_a() {
        this.field_212926_h = null;
        this.field_212925_g = null;
    }

    public void func_194818_a(MatrixStack matrixStack) {
        this.field_175242_a.func_213239_aq().func_76320_a("debug");
        RenderSystem.pushMatrix();
        Entity entity = this.field_175242_a.func_175606_aa();
        this.field_211537_g = entity.func_213324_a(20.0, 0.0f, false);
        this.field_211538_h = entity.func_213324_a(20.0, 0.0f, true);
        this.func_230024_c_(matrixStack);
        this.func_230025_d_(matrixStack);
        RenderSystem.popMatrix();
        if (this.field_175242_a.field_71474_y.field_181657_aC) {
            int n = this.field_175242_a.func_228018_at_().func_198107_o();
            this.func_238509_a_(matrixStack, this.field_175242_a.func_181539_aj(), 0, n / 2, true);
            IntegratedServer \u26032 = this.field_175242_a.func_71401_C();
            if (\u26032 != null) {
                this.func_238509_a_(matrixStack, \u26032.func_213210_aR(), n - Math.min(n / 2, 240), n / 2, false);
            }
        }
        this.field_175242_a.func_213239_aq().func_76319_b();
    }

    protected void func_230024_c_(MatrixStack matrixStack) {
        List<String> list = this.func_209011_c();
        list.add("");
        boolean \u26032 = this.field_175242_a.func_71401_C() != null;
        list.add("Debug: Pie [shift]: " + (this.field_175242_a.field_71474_y.field_74329_Q ? "visible" : "hidden") + (\u26032 ? " FPS + TPS" : " FPS") + " [alt]: " + (this.field_175242_a.field_71474_y.field_181657_aC ? "visible" : "hidden"));
        list.add("For help: press F3 + Q");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int \u26033 = this.field_175241_f.field_78288_b;
            int \u26034 = this.field_175241_f.func_78256_a(string);
            int \u26035 = 2;
            int \u26036 = 2 + \u26033 * i;
            DebugOverlayGui.func_238467_a_(matrixStack, 1, \u26036 - 1, 2 + \u26034 + 1, \u26036 + \u26033 - 1, -1873784752);
            this.field_175241_f.func_238421_b_(matrixStack, string, 2.0f, \u26036, 0xE0E0E0);
        }
    }

    protected void func_230025_d_(MatrixStack matrixStack) {
        List<String> list = this.func_175238_c();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int \u26032 = this.field_175241_f.field_78288_b;
            int \u26033 = this.field_175241_f.func_78256_a(string);
            int \u26034 = this.field_175242_a.func_228018_at_().func_198107_o() - 2 - \u26033;
            int \u26035 = 2 + \u26032 * i;
            DebugOverlayGui.func_238467_a_(matrixStack, \u26034 - 1, \u26035 - 1, \u26034 + \u26033 + 1, \u26035 + \u26032 - 1, -1873784752);
            this.field_175241_f.func_238421_b_(matrixStack, string, \u26034, \u26035, 0xE0E0E0);
        }
    }

    protected List<String> func_209011_c() {
        World world;
        String string;
        IntegratedServer integratedServer = this.field_175242_a.func_71401_C();
        NetworkManager \u26032 = this.field_175242_a.func_147114_u().func_147298_b();
        float \u26033 = \u26032.func_211390_n();
        float \u26034 = \u26032.func_211393_m();
        if (integratedServer != null) {
            String \u26035 = String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedServer.func_211149_aT()), Float.valueOf(\u26033), Float.valueOf(\u26034));
        } else {
            string = String.format("\"%s\" server, %.0f tx, %.0f rx", this.field_175242_a.field_71439_g.func_142021_k(), Float.valueOf(\u26033), Float.valueOf(\u26034));
        }
        BlockPos \u26036 = this.field_175242_a.func_175606_aa().func_233580_cy_();
        if (this.field_175242_a.func_189648_am()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ")", this.field_175242_a.field_71426_K, string, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u(), "", String.format("Chunk-relative: %d %d %d", \u26036.func_177958_n() & 0xF, \u26036.func_177956_o() & 0xF, \u26036.func_177952_p() & 0xF)});
        }
        Entity \u26037 = this.field_175242_a.func_175606_aa();
        Direction \u26038 = \u26037.func_174811_aO();
        switch (\u26038) {
            case NORTH: {
                String string2 = "Towards negative Z";
                break;
            }
            case SOUTH: {
                String string3 = "Towards positive Z";
                break;
            }
            case WEST: {
                String string3 = "Towards negative X";
                break;
            }
            case EAST: {
                String string3 = "Towards positive X";
                break;
            }
            default: {
                String string3 = "Invalid";
            }
        }
        ChunkPos chunkPos = new ChunkPos(\u26036);
        if (!Objects.equals(this.field_212924_f, chunkPos)) {
            this.field_212924_f = chunkPos;
            this.func_212921_a();
        }
        LongSets.EmptySet \u26039 = (world = this.func_212922_g()) instanceof ServerWorld ? ((ServerWorld)world).func_217469_z() : LongSets.EMPTY_SET;
        ArrayList \u260310 = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_175242_a.func_184123_d()) ? "" : "/" + this.field_175242_a.func_184123_d()) + ")", this.field_175242_a.field_71426_K, string, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u()});
        String \u260311 = this.func_223101_g();
        if (\u260311 != null) {
            \u260310.add(\u260311);
        }
        \u260310.add(this.field_175242_a.field_71441_e.func_234923_W_().func_240901_a_() + " FC: " + \u26039.size());
        \u260310.add("");
        \u260310.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.field_175242_a.func_175606_aa().func_226277_ct_(), this.field_175242_a.func_175606_aa().func_226278_cu_(), this.field_175242_a.func_175606_aa().func_226281_cx_()));
        \u260310.add(String.format("Block: %d %d %d", \u26036.func_177958_n(), \u26036.func_177956_o(), \u26036.func_177952_p()));
        \u260310.add(String.format("Chunk: %d %d %d in %d %d %d", \u26036.func_177958_n() & 0xF, \u26036.func_177956_o() & 0xF, \u26036.func_177952_p() & 0xF, \u26036.func_177958_n() >> 4, \u26036.func_177956_o() >> 4, \u26036.func_177952_p() >> 4));
        \u260310.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", \u26038, string3, Float.valueOf(MathHelper.func_76142_g(\u26037.field_70177_z)), Float.valueOf(MathHelper.func_76142_g(\u26037.field_70125_A))));
        if (this.field_175242_a.field_71441_e != null) {
            if (this.field_175242_a.field_71441_e.func_175667_e(\u26036)) {
                Chunk chunk = this.func_212916_i();
                if (chunk.func_76621_g()) {
                    \u260310.add("Waiting for chunk...");
                } else {
                    int n = this.field_175242_a.field_71441_e.func_72863_F().func_212863_j_().func_227470_b_(\u26036, 0);
                    int n2 = this.field_175242_a.field_71441_e.func_226658_a_(LightType.SKY, \u26036);
                    \u2603 = this.field_175242_a.field_71441_e.func_226658_a_(LightType.BLOCK, \u26036);
                    \u260310.add("Client Light: " + n + " (" + n2 + " sky, " + \u2603 + " block)");
                    Chunk \u260312 = this.func_212919_h();
                    if (\u260312 != null) {
                        WorldLightManager object = world.func_72863_F().func_212863_j_();
                        \u260310.add("Server Light: (" + object.func_215569_a(LightType.SKY).func_215611_b(\u26036) + " sky, " + object.func_215569_a(LightType.BLOCK).func_215611_b(\u26036) + " block)");
                    } else {
                        \u260310.add("Server Light: (?? sky, ?? block)");
                    }
                    StringBuilder \u260316 = new StringBuilder("CH");
                    for (Heightmap.Type type : Heightmap.Type.values()) {
                        if (!type.func_222681_b()) continue;
                        \u260316.append(" ").append(field_212923_a.get(type)).append(": ").append(chunk.func_201576_a(type, \u26036.func_177958_n(), \u26036.func_177952_p()));
                    }
                    \u260310.add(\u260316.toString());
                    \u260316.setLength(0);
                    \u260316.append("SH");
                    for (Heightmap.Type type : Heightmap.Type.values()) {
                        if (!type.func_222683_c()) continue;
                        \u260316.append(" ").append(field_212923_a.get(type)).append(": ");
                        if (\u260312 != null) {
                            \u260316.append(\u260312.func_201576_a(type, \u26036.func_177958_n(), \u26036.func_177952_p()));
                            continue;
                        }
                        \u260316.append("??");
                    }
                    \u260310.add(\u260316.toString());
                    if (\u26036.func_177956_o() >= 0 && \u26036.func_177956_o() < 256) {
                        \u260310.add("Biome: " + this.field_175242_a.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c(this.field_175242_a.field_71441_e.func_226691_t_(\u26036)));
                        long l = 0L;
                        float \u260313 = 0.0f;
                        if (\u260312 != null) {
                            \u260313 = world.func_242413_ae();
                            l = \u260312.func_177416_w();
                        }
                        DifficultyInstance difficultyInstance = new DifficultyInstance(world.func_175659_aa(), world.func_72820_D(), l, \u260313);
                        \u260310.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyInstance.func_180168_b()), Float.valueOf(difficultyInstance.func_180170_c()), this.field_175242_a.field_71441_e.func_72820_D() / 24000L));
                    }
                }
            } else {
                \u260310.add("Outside of world...");
            }
        } else {
            \u260310.add("Outside of world...");
        }
        ServerWorld iBlockReader = this.func_238515_d_();
        if (iBlockReader != null) {
            WorldEntitySpawner.EntityDensityManager entityDensityManager = iBlockReader.func_72863_F().func_241101_k_();
            if (entityDensityManager != null) {
                Object2IntMap<EntityClassification> object2IntMap = entityDensityManager.func_234995_b_();
                int \u260315 = entityDensityManager.func_234988_a_();
                \u260310.add("SC: " + \u260315 + ", " + Stream.of(EntityClassification.values()).map(entityClassification -> Character.toUpperCase(entityClassification.func_220363_a().charAt(0)) + ": " + object2IntMap.getInt(entityClassification)).collect(Collectors.joining(", ")));
            } else {
                \u260310.add("SC: N/A");
            }
        }
        if ((\u2603 = this.field_175242_a.field_71460_t.func_147706_e()) != null) {
            \u260310.add("Shader: " + \u2603.func_148022_b());
        }
        \u260310.add(this.field_175242_a.func_147118_V().func_215293_f() + String.format(" (Mood %d%%)", Math.round(this.field_175242_a.field_71439_g.func_239206_w_() * 100.0f)));
        return \u260310;
    }

    @Nullable
    private ServerWorld func_238515_d_() {
        IntegratedServer integratedServer = this.field_175242_a.func_71401_C();
        if (integratedServer != null) {
            return integratedServer.func_71218_a(this.field_175242_a.field_71441_e.func_234923_W_());
        }
        return null;
    }

    @Nullable
    private String func_223101_g() {
        ServerWorld serverWorld = this.func_238515_d_();
        if (serverWorld != null) {
            return serverWorld.func_72827_u();
        }
        return null;
    }

    private World func_212922_g() {
        return (World)DataFixUtils.orElse(Optional.ofNullable(this.field_175242_a.func_71401_C()).flatMap(integratedServer -> Optional.ofNullable(integratedServer.func_71218_a(this.field_175242_a.field_71441_e.func_234923_W_()))), (Object)this.field_175242_a.field_71441_e);
    }

    @Nullable
    private Chunk func_212919_h() {
        if (this.field_212926_h == null) {
            ServerWorld serverWorld = this.func_238515_d_();
            if (serverWorld != null) {
                this.field_212926_h = serverWorld.func_72863_F().func_217232_b(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b, ChunkStatus.field_222617_m, false).thenApply(either -> (Chunk)either.map(iChunk -> (Chunk)iChunk, iChunkLoadingError -> null));
            }
            if (this.field_212926_h == null) {
                this.field_212926_h = CompletableFuture.completedFuture(this.func_212916_i());
            }
        }
        return this.field_212926_h.getNow(null);
    }

    private Chunk func_212916_i() {
        if (this.field_212925_g == null) {
            this.field_212925_g = this.field_175242_a.field_71441_e.func_212866_a_(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b);
        }
        return this.field_212925_g;
    }

    protected List<String> func_175238_c() {
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        \u2603 = Runtime.getRuntime().freeMemory();
        \u2603 = l2 - \u2603;
        ArrayList \u26032 = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.field_175242_a.func_147111_S() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", \u2603 * 100L / l, DebugOverlayGui.func_175240_a(\u2603), DebugOverlayGui.func_175240_a(l)), String.format("Allocated: % 2d%% %03dMB", l2 * 100L / l, DebugOverlayGui.func_175240_a(l2)), "", String.format("CPU: %s", PlatformDescriptors.func_227775_b_()), "", String.format("Display: %dx%d (%s)", Minecraft.func_71410_x().func_228018_at_().func_198109_k(), Minecraft.func_71410_x().func_228018_at_().func_198091_l(), PlatformDescriptors.func_227774_a_()), PlatformDescriptors.func_227776_c_(), PlatformDescriptors.func_227777_d_()});
        if (this.field_175242_a.func_189648_am()) {
            return \u26032;
        }
        if (this.field_211537_g.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos object = ((BlockRayTraceResult)this.field_211537_g).func_216350_a();
            BlockState \u26033 = this.field_175242_a.field_71441_e.func_180495_p(object);
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Block: " + object.func_177958_n() + ", " + object.func_177956_o() + ", " + object.func_177952_p());
            \u26032.add(String.valueOf(Registry.field_212618_g.func_177774_c(\u26033.func_177230_c())));
            for (Map.Entry entry : \u26033.func_206871_b().entrySet()) {
                \u26032.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourceLocation : this.field_175242_a.func_147114_u().func_199724_l().func_241835_a().func_199913_a(\u26033.func_177230_c())) {
                \u26032.add("#" + resourceLocation);
            }
        }
        if (this.field_211538_h.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Object object = ((BlockRayTraceResult)this.field_211538_h).func_216350_a();
            FluidState \u26034 = this.field_175242_a.field_71441_e.func_204610_c((BlockPos)object);
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Fluid: " + ((Vector3i)object).func_177958_n() + ", " + ((Vector3i)object).func_177956_o() + ", " + ((Vector3i)object).func_177952_p());
            \u26032.add(String.valueOf(Registry.field_212619_h.func_177774_c(\u26034.func_206886_c())));
            for (Map.Entry entry : \u26034.func_206871_b().entrySet()) {
                \u26032.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourceLocation : this.field_175242_a.func_147114_u().func_199724_l().func_241837_c().func_199913_a(\u26034.func_206886_c())) {
                \u26032.add("#" + resourceLocation);
            }
        }
        if ((object = this.field_175242_a.field_147125_j) != null) {
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Entity");
            \u26032.add(String.valueOf(Registry.field_212629_r.func_177774_c(((Entity)object).func_200600_R())));
        }
        return \u26032;
    }

    private String func_211534_a(Map.Entry<Property<?>, Comparable<?>> entry) {
        Property<?> property = entry.getKey();
        Comparable<?> \u26032 = entry.getValue();
        String \u26033 = Util.func_200269_a(property, \u26032);
        if (Boolean.TRUE.equals(\u26032)) {
            \u26033 = (Object)((Object)TextFormatting.GREEN) + \u26033;
        } else if (Boolean.FALSE.equals(\u26032)) {
            \u26033 = (Object)((Object)TextFormatting.RED) + \u26033;
        }
        return property.func_177701_a() + ": " + \u26033;
    }

    private void func_238509_a_(MatrixStack matrixStack, FrameTimer frameTimer, int n, int n2, boolean bl) {
        RenderSystem.disableDepthTest();
        int n3 = frameTimer.func_181749_a();
        \u2603 = frameTimer.func_181750_b();
        long[] \u26032 = frameTimer.func_181746_c();
        \u2603 = n3;
        \u2603 = n;
        \u2603 = Math.max(0, \u26032.length - n2);
        \u2603 = \u26032.length - \u2603;
        \u2603 = frameTimer.func_181751_b(\u2603 + \u2603);
        long \u26033 = 0L;
        \u2603 = Integer.MAX_VALUE;
        \u2603 = Integer.MIN_VALUE;
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            \u2603 = (int)(\u26032[frameTimer.func_181751_b(\u2603 + \u2603)] / 1000000L);
            \u2603 = Math.min(\u2603, \u2603);
            \u2603 = Math.max(\u2603, \u2603);
            \u26033 += (long)\u2603;
        }
        \u2603 = this.field_175242_a.func_228018_at_().func_198087_p();
        DebugOverlayGui.func_238467_a_(matrixStack, n, \u2603 - 60, n + \u2603, \u2603, -1873784752);
        BufferBuilder \u26034 = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        \u26034.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f \u26035 = TransformationMatrix.func_227983_a_().func_227988_c_();
        while (\u2603 != \u2603) {
            \u2603 = frameTimer.func_219792_a(\u26032[\u2603], bl ? 30 : 60, bl ? 60 : 20);
            \u2603 = bl ? 100 : 60;
            \u2603 = this.func_181552_c(MathHelper.func_76125_a(\u2603, 0, \u2603), 0, \u2603 / 2, \u2603);
            \u2603 = \u2603 >> 24 & 0xFF;
            \u2603 = \u2603 >> 16 & 0xFF;
            \u2603 = \u2603 >> 8 & 0xFF;
            \u2603 = \u2603 & 0xFF;
            \u26034.func_227888_a_(\u26035, \u2603 + 1, \u2603, 0.0f).func_225586_a_(\u2603, \u2603, \u2603, \u2603).func_181675_d();
            \u26034.func_227888_a_(\u26035, \u2603 + 1, \u2603 - \u2603 + 1, 0.0f).func_225586_a_(\u2603, \u2603, \u2603, \u2603).func_181675_d();
            \u26034.func_227888_a_(\u26035, \u2603, \u2603 - \u2603 + 1, 0.0f).func_225586_a_(\u2603, \u2603, \u2603, \u2603).func_181675_d();
            \u26034.func_227888_a_(\u26035, \u2603, \u2603, 0.0f).func_225586_a_(\u2603, \u2603, \u2603, \u2603).func_181675_d();
            ++\u2603;
            \u2603 = frameTimer.func_181751_b(\u2603 + 1);
        }
        \u26034.func_178977_d();
        WorldVertexBufferUploader.func_181679_a(\u26034);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        if (bl) {
            DebugOverlayGui.func_238467_a_(matrixStack, n + 1, \u2603 - 30 + 1, n + 14, \u2603 - 30 + 10, -1873784752);
            this.field_175241_f.func_238421_b_(matrixStack, "60 FPS", n + 2, \u2603 - 30 + 2, 0xE0E0E0);
            this.func_238465_a_(matrixStack, n, n + \u2603 - 1, \u2603 - 30, -1);
            DebugOverlayGui.func_238467_a_(matrixStack, n + 1, \u2603 - 60 + 1, n + 14, \u2603 - 60 + 10, -1873784752);
            this.field_175241_f.func_238421_b_(matrixStack, "30 FPS", n + 2, \u2603 - 60 + 2, 0xE0E0E0);
            this.func_238465_a_(matrixStack, n, n + \u2603 - 1, \u2603 - 60, -1);
        } else {
            DebugOverlayGui.func_238467_a_(matrixStack, n + 1, \u2603 - 60 + 1, n + 14, \u2603 - 60 + 10, -1873784752);
            this.field_175241_f.func_238421_b_(matrixStack, "20 TPS", n + 2, \u2603 - 60 + 2, 0xE0E0E0);
            this.func_238465_a_(matrixStack, n, n + \u2603 - 1, \u2603 - 60, -1);
        }
        this.func_238465_a_(matrixStack, n, n + \u2603 - 1, \u2603 - 1, -1);
        this.func_238473_b_(matrixStack, n, \u2603 - 60, \u2603, -1);
        this.func_238473_b_(matrixStack, n + \u2603 - 1, \u2603 - 60, \u2603, -1);
        if (bl && this.field_175242_a.field_71474_y.field_74350_i > 0 && this.field_175242_a.field_71474_y.field_74350_i <= 250) {
            this.func_238465_a_(matrixStack, n, n + \u2603 - 1, \u2603 - 1 - (int)(1800.0 / (double)this.field_175242_a.field_71474_y.field_74350_i), -16711681);
        }
        String \u26036 = \u2603 + " ms min";
        String \u26037 = \u26033 / (long)\u2603 + " ms avg";
        String \u26038 = \u2603 + " ms max";
        this.field_175241_f.func_238405_a_(matrixStack, \u26036, n + 2, \u2603 - 60 - this.field_175241_f.field_78288_b, 0xE0E0E0);
        this.field_175241_f.func_238405_a_(matrixStack, \u26037, n + \u2603 / 2 - this.field_175241_f.func_78256_a(\u26037) / 2, \u2603 - 60 - this.field_175241_f.field_78288_b, 0xE0E0E0);
        this.field_175241_f.func_238405_a_(matrixStack, \u26038, n + \u2603 - this.field_175241_f.func_78256_a(\u26038), \u2603 - 60 - this.field_175241_f.field_78288_b, 0xE0E0E0);
        RenderSystem.enableDepthTest();
    }

    private int func_181552_c(int n, int n2, int n3, int n4) {
        if (n < n3) {
            return this.func_181553_a(-16711936, -256, (float)n / (float)n3);
        }
        return this.func_181553_a(-256, -65536, (float)(n - n3) / (float)(n4 - n3));
    }

    private int func_181553_a(int n, int n2, float f) {
        int n3 = n >> 24 & 0xFF;
        \u2603 = n >> 16 & 0xFF;
        \u2603 = n >> 8 & 0xFF;
        \u2603 = n & 0xFF;
        \u2603 = n2 >> 24 & 0xFF;
        \u2603 = n2 >> 16 & 0xFF;
        \u2603 = n2 >> 8 & 0xFF;
        \u2603 = n2 & 0xFF;
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, n3, \u2603), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, \u2603, \u2603), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, \u2603, \u2603), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, \u2603, \u2603), 0, 255);
        return \u2603 << 24 | \u2603 << 16 | \u2603 << 8 | \u2603;
    }

    private static long func_175240_a(long l) {
        return l / 1024L / 1024L;
    }
}

