/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StatsScreen
extends Screen
implements IProgressMeter {
    private static final ITextComponent field_243320_c = new TranslationTextComponent("multiplayer.downloadingStats");
    protected final Screen field_146549_a;
    private CustomStatsList field_146550_h;
    private StatsList field_146551_i;
    private MobStatsList field_146547_s;
    private final StatisticsManager field_146546_t;
    @Nullable
    private ExtendedList<?> field_146545_u;
    private boolean field_146543_v = true;

    public StatsScreen(Screen screen, StatisticsManager statisticsManager) {
        super(new TranslationTextComponent("gui.stats"));
        this.field_146549_a = screen;
        this.field_146546_t = statisticsManager;
    }

    @Override
    protected void func_231160_c_() {
        this.field_146543_v = true;
        this.field_230706_i_.func_147114_u().func_147297_a(new CClientStatusPacket(CClientStatusPacket.State.REQUEST_STATS));
    }

    public void func_193028_a() {
        this.field_146550_h = new CustomStatsList(this.field_230706_i_);
        this.field_146551_i = new StatsList(this.field_230706_i_);
        this.field_146547_s = new MobStatsList(this.field_230706_i_);
    }

    public void func_193029_f() {
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 120, this.field_230709_l_ - 52, 80, 20, new TranslationTextComponent("stat.generalButton"), button -> this.func_213110_a(this.field_146550_h)));
        Button button2 = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ - 52, 80, 20, new TranslationTextComponent("stat.itemsButton"), button -> this.func_213110_a(this.field_146551_i)));
        \u2603 = this.func_230480_a_(new Button(this.field_230708_k_ / 2 + 40, this.field_230709_l_ - 52, 80, 20, new TranslationTextComponent("stat.mobsButton"), button -> this.func_213110_a(this.field_146547_s)));
        this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 28, 200, 20, DialogTexts.field_240632_c_, button -> this.field_230706_i_.func_147108_a(this.field_146549_a)));
        if (this.field_146551_i.func_231039_at__().isEmpty()) {
            button2.field_230693_o_ = false;
        }
        if (this.field_146547_s.func_231039_at__().isEmpty()) {
            \u2603.field_230693_o_ = false;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        if (this.field_146543_v) {
            this.func_230446_a_(matrixStack);
            StatsScreen.func_238472_a_(matrixStack, this.field_230712_o_, field_243320_c, this.field_230708_k_ / 2, this.field_230709_l_ / 2, 0xFFFFFF);
            StatsScreen.func_238471_a_(matrixStack, this.field_230712_o_, field_146510_b_[(int)(Util.func_211177_b() / 150L % (long)field_146510_b_.length)], this.field_230708_k_ / 2, this.field_230709_l_ / 2 + this.field_230712_o_.field_78288_b * 2, 0xFFFFFF);
        } else {
            this.func_213116_d().func_230430_a_(matrixStack, n, n2, f);
            StatsScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
            super.func_230430_a_(matrixStack, n, n2, f);
        }
    }

    @Override
    public void func_193026_g() {
        if (this.field_146543_v) {
            this.func_193028_a();
            this.func_193029_f();
            this.func_213110_a(this.field_146550_h);
            this.field_146543_v = false;
        }
    }

    @Override
    public boolean func_231177_au__() {
        return !this.field_146543_v;
    }

    @Nullable
    public ExtendedList<?> func_213116_d() {
        return this.field_146545_u;
    }

    public void func_213110_a(@Nullable ExtendedList<?> extendedList) {
        this.field_230705_e_.remove(this.field_146550_h);
        this.field_230705_e_.remove(this.field_146551_i);
        this.field_230705_e_.remove(this.field_146547_s);
        if (extendedList != null) {
            this.field_230705_e_.add(0, extendedList);
            this.field_146545_u = extendedList;
        }
    }

    private static String func_238672_b_(Stat<ResourceLocation> stat) {
        return "stat." + stat.func_197920_b().toString().replace(':', '.');
    }

    private int func_195224_b(int n) {
        return 115 + 40 * n;
    }

    private void func_238667_a_(MatrixStack matrixStack, int n, int n2, Item item) {
        this.func_238674_c_(matrixStack, n + 1, n2 + 1, 0, 0);
        RenderSystem.enableRescaleNormal();
        this.field_230707_j_.func_175042_a(item.func_190903_i(), n + 2, n2 + 2);
        RenderSystem.disableRescaleNormal();
    }

    private void func_238674_c_(MatrixStack matrixStack, int n, int n2, int n3, int n4) {
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(field_230664_g_);
        StatsScreen.func_238464_a_(matrixStack, n, n2, this.func_230927_p_(), n3, n4, 18, 18, 128, 128);
    }

    class MobStatsList
    extends ExtendedList<Entry> {
        public MobStatsList(Minecraft minecraft) {
            super(minecraft, StatsScreen.this.field_230708_k_, StatsScreen.this.field_230709_l_, 32, StatsScreen.this.field_230709_l_ - 64, ((StatsScreen)StatsScreen.this).field_230712_o_.field_78288_b * 4);
            for (EntityType entityType : Registry.field_212629_r) {
                if (StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199090_h.func_199076_b(entityType)) <= 0 && StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199091_i.func_199076_b(entityType)) <= 0) continue;
                this.func_230513_b_(new Entry(entityType));
            }
        }

        @Override
        protected void func_230433_a_(MatrixStack matrixStack) {
            StatsScreen.this.func_230446_a_(matrixStack);
        }

        class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final EntityType<?> field_214411_b;
            private final ITextComponent field_243322_c;
            private final ITextComponent field_243323_d;
            private final boolean field_243324_e;
            private final ITextComponent field_243325_f;
            private final boolean field_243326_g;

            public Entry(EntityType<?> entityType) {
                this.field_214411_b = entityType;
                this.field_243322_c = entityType.func_212546_e();
                int n = StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199090_h.func_199076_b(entityType));
                if (n == 0) {
                    this.field_243323_d = new TranslationTextComponent("stat_type.minecraft.killed.none", this.field_243322_c);
                    this.field_243324_e = false;
                } else {
                    this.field_243323_d = new TranslationTextComponent("stat_type.minecraft.killed", n, this.field_243322_c);
                    this.field_243324_e = true;
                }
                \u2603 = StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199091_i.func_199076_b(entityType));
                if (\u2603 == 0) {
                    this.field_243325_f = new TranslationTextComponent("stat_type.minecraft.killed_by.none", this.field_243322_c);
                    this.field_243326_g = false;
                } else {
                    this.field_243325_f = new TranslationTextComponent("stat_type.minecraft.killed_by", this.field_243322_c, \u2603);
                    this.field_243326_g = true;
                }
            }

            @Override
            public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                AbstractGui.func_238475_b_(matrixStack, StatsScreen.this.field_230712_o_, this.field_243322_c, n3 + 2, n2 + 1, 0xFFFFFF);
                AbstractGui.func_238475_b_(matrixStack, StatsScreen.this.field_230712_o_, this.field_243323_d, n3 + 2 + 10, n2 + 1 + ((StatsScreen)StatsScreen.this).field_230712_o_.field_78288_b, this.field_243324_e ? 0x909090 : 0x606060);
                AbstractGui.func_238475_b_(matrixStack, StatsScreen.this.field_230712_o_, this.field_243325_f, n3 + 2 + 10, n2 + 1 + ((StatsScreen)StatsScreen.this).field_230712_o_.field_78288_b * 2, this.field_243326_g ? 0x909090 : 0x606060);
            }
        }
    }

    class StatsList
    extends ExtendedList<Entry> {
        protected final List<StatType<Block>> field_195113_v;
        protected final List<StatType<Item>> field_195114_w;
        private final int[] field_195112_D;
        protected int field_195115_x;
        protected final List<Item> field_195116_y;
        protected final java.util.Comparator<Item> field_195117_z;
        @Nullable
        protected StatType<?> field_195110_A;
        protected int field_195111_B;

        public StatsList(Minecraft minecraft) {
            super(minecraft, StatsScreen.this.field_230708_k_, StatsScreen.this.field_230709_l_, 32, StatsScreen.this.field_230709_l_ - 64, 20);
            this.field_195112_D = new int[]{3, 4, 1, 2, 5, 6};
            this.field_195115_x = -1;
            this.field_195117_z = new Comparator();
            this.field_195113_v = Lists.newArrayList();
            this.field_195113_v.add(Stats.field_188065_ae);
            this.field_195114_w = Lists.newArrayList((Object[])new StatType[]{Stats.field_199088_e, Stats.field_188066_af, Stats.field_75929_E, Stats.field_199089_f, Stats.field_188068_aj});
            this.func_230944_a_(true, 20);
            Set set = Sets.newIdentityHashSet();
            for (Item item : Registry.field_212630_s) {
                boolean bl = false;
                for (StatType<Item> statType : this.field_195114_w) {
                    if (!statType.func_199079_a(item) || StatsScreen.this.field_146546_t.func_77444_a(statType.func_199076_b(item)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(item);
            }
            for (Block block : Registry.field_212618_g) {
                boolean bl = false;
                for (StatType<IItemProvider> statType : this.field_195113_v) {
                    if (!statType.func_199079_a(block) || StatsScreen.this.field_146546_t.func_77444_a(statType.func_199076_b(block)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(block.func_199767_j());
            }
            set.remove(Items.field_190931_a);
            this.field_195116_y = Lists.newArrayList((Iterable)set);
            for (int i = 0; i < this.field_195116_y.size(); ++i) {
                this.func_230513_b_(new Entry());
            }
        }

        @Override
        protected void func_230448_a_(MatrixStack matrixStack, int n, int n2, Tessellator tessellator) {
            int n3;
            if (!this.field_230668_b_.field_71417_B.func_198030_b()) {
                this.field_195115_x = -1;
            }
            for (n3 = 0; n3 < this.field_195112_D.length; ++n3) {
                StatsScreen.this.func_238674_c_(matrixStack, n + StatsScreen.this.func_195224_b(n3) - 18, n2 + 1, 0, this.field_195115_x == n3 ? 0 : 18);
            }
            if (this.field_195110_A != null) {
                n3 = StatsScreen.this.func_195224_b(this.func_195105_b(this.field_195110_A)) - 36;
                \u2603 = this.field_195111_B == 1 ? 2 : 1;
                StatsScreen.this.func_238674_c_(matrixStack, n + n3, n2 + 1, 18 * \u2603, 0);
            }
            for (n3 = 0; n3 < this.field_195112_D.length; ++n3) {
                \u2603 = this.field_195115_x == n3 ? 1 : 0;
                StatsScreen.this.func_238674_c_(matrixStack, n + StatsScreen.this.func_195224_b(n3) - 18 + \u2603, n2 + 1 + \u2603, 18 * this.field_195112_D[n3], 18);
            }
        }

        @Override
        public int func_230949_c_() {
            return 375;
        }

        @Override
        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 140;
        }

        @Override
        protected void func_230433_a_(MatrixStack matrixStack) {
            StatsScreen.this.func_230446_a_(matrixStack);
        }

        @Override
        protected void func_230938_a_(int n, int n2) {
            this.field_195115_x = -1;
            for (\u2603 = 0; \u2603 < this.field_195112_D.length; ++\u2603) {
                \u2603 = n - StatsScreen.this.func_195224_b(\u2603);
                if (\u2603 < -36 || \u2603 > 0) continue;
                this.field_195115_x = \u2603;
                break;
            }
            if (this.field_195115_x >= 0) {
                this.func_195107_a(this.func_195108_d(this.field_195115_x));
                this.field_230668_b_.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187909_gi, 1.0f));
            }
        }

        private StatType<?> func_195108_d(int n) {
            return n < this.field_195113_v.size() ? this.field_195113_v.get(n) : this.field_195114_w.get(n - this.field_195113_v.size());
        }

        private int func_195105_b(StatType<?> statType) {
            int n = this.field_195113_v.indexOf(statType);
            if (n >= 0) {
                return n;
            }
            \u2603 = this.field_195114_w.indexOf(statType);
            if (\u2603 >= 0) {
                return \u2603 + this.field_195113_v.size();
            }
            return -1;
        }

        @Override
        protected void func_230447_a_(MatrixStack matrixStack2, int n, int n2) {
            if (n2 < this.field_230672_i_ || n2 > this.field_230673_j_) {
                return;
            }
            Entry entry = (Entry)this.func_230933_a_(n, n2);
            int \u26032 = (this.field_230670_d_ - this.func_230949_c_()) / 2;
            if (entry != null) {
                if (n < \u26032 + 40 || n > \u26032 + 40 + 20) {
                    return;
                }
                Item item = this.field_195116_y.get(this.func_231039_at__().indexOf(entry));
                this.func_238680_a_(matrixStack2, this.func_200208_a(item), n, n2);
            } else {
                MatrixStack matrixStack2;
                ITextComponent iTextComponent = null;
                int \u26033 = n - \u26032;
                for (int i = 0; i < this.field_195112_D.length; ++i) {
                    \u2603 = StatsScreen.this.func_195224_b(i);
                    if (\u26033 < \u2603 - 18 || \u26033 > \u2603) continue;
                    iTextComponent = this.func_195108_d(i).func_242170_d();
                    break;
                }
                this.func_238680_a_(matrixStack2, iTextComponent, n, n2);
            }
        }

        protected void func_238680_a_(MatrixStack matrixStack, @Nullable ITextComponent iTextComponent, int n, int n2) {
            if (iTextComponent == null) {
                return;
            }
            \u2603 = n + 12;
            \u2603 = n2 - 12;
            \u2603 = StatsScreen.this.field_230712_o_.func_238414_a_(iTextComponent);
            this.func_238468_a_(matrixStack, \u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, \u2603 + 8 + 3, -1073741824, -1073741824);
            RenderSystem.pushMatrix();
            RenderSystem.translatef(0.0f, 0.0f, 400.0f);
            StatsScreen.this.field_230712_o_.func_243246_a(matrixStack, iTextComponent, \u2603, \u2603, -1);
            RenderSystem.popMatrix();
        }

        protected ITextComponent func_200208_a(Item item) {
            return item.func_200296_o();
        }

        protected void func_195107_a(StatType<?> statType) {
            if (statType != this.field_195110_A) {
                this.field_195110_A = statType;
                this.field_195111_B = -1;
            } else if (this.field_195111_B == -1) {
                this.field_195111_B = 1;
            } else {
                this.field_195110_A = null;
                this.field_195111_B = 0;
            }
            this.field_195116_y.sort(this.field_195117_z);
        }

        class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private Entry() {
            }

            @Override
            public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                int n8;
                Item item = ((StatsScreen)StatsScreen.this).field_146551_i.field_195116_y.get(n);
                StatsScreen.this.func_238667_a_(matrixStack, n3 + 40, n2, item);
                for (n8 = 0; n8 < ((StatsScreen)StatsScreen.this).field_146551_i.field_195113_v.size(); ++n8) {
                    Stat<Block> stat = item instanceof BlockItem ? ((StatsScreen)StatsScreen.this).field_146551_i.field_195113_v.get(n8).func_199076_b(((BlockItem)item).func_179223_d()) : null;
                    this.func_238681_a_(matrixStack, stat, n3 + StatsScreen.this.func_195224_b(n8), n2, n % 2 == 0);
                }
                for (n8 = 0; n8 < ((StatsScreen)StatsScreen.this).field_146551_i.field_195114_w.size(); ++n8) {
                    this.func_238681_a_(matrixStack, ((StatsScreen)StatsScreen.this).field_146551_i.field_195114_w.get(n8).func_199076_b(item), n3 + StatsScreen.this.func_195224_b(n8 + ((StatsScreen)StatsScreen.this).field_146551_i.field_195113_v.size()), n2, n % 2 == 0);
                }
            }

            protected void func_238681_a_(MatrixStack matrixStack, @Nullable Stat<?> stat, int n, int n2, boolean bl) {
                String string = stat == null ? "-" : stat.func_75968_a(StatsScreen.this.field_146546_t.func_77444_a(stat));
                AbstractGui.func_238476_c_(matrixStack, StatsScreen.this.field_230712_o_, string, n - StatsScreen.this.field_230712_o_.func_78256_a(string), n2 + 5, bl ? 0xFFFFFF : 0x909090);
            }
        }

        class Comparator
        implements java.util.Comparator<Item> {
            private Comparator() {
            }

            @Override
            public int compare(Item item, Item item2) {
                int \u26033;
                int \u26032;
                if (StatsList.this.field_195110_A == null) {
                    \u26032 = 0;
                    \u26033 = 0;
                } else if (StatsList.this.field_195113_v.contains(StatsList.this.field_195110_A)) {
                    StatType<?> statType = StatsList.this.field_195110_A;
                    \u26032 = item instanceof BlockItem ? StatsScreen.this.field_146546_t.func_199060_a(statType, ((BlockItem)item).func_179223_d()) : -1;
                    \u26033 = item2 instanceof BlockItem ? StatsScreen.this.field_146546_t.func_199060_a(statType, ((BlockItem)item2).func_179223_d()) : -1;
                } else {
                    \u2603 = StatsList.this.field_195110_A;
                    \u26032 = StatsScreen.this.field_146546_t.func_199060_a(\u2603, item);
                    \u26033 = StatsScreen.this.field_146546_t.func_199060_a(\u2603, item2);
                }
                if (\u26032 == \u26033) {
                    return StatsList.this.field_195111_B * Integer.compare(Item.func_150891_b(item), Item.func_150891_b(item2));
                }
                return StatsList.this.field_195111_B * Integer.compare(\u26032, \u26033);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((Item)object, (Item)object2);
            }
        }
    }

    class CustomStatsList
    extends ExtendedList<Entry> {
        public CustomStatsList(Minecraft minecraft) {
            super(minecraft, StatsScreen.this.field_230708_k_, StatsScreen.this.field_230709_l_, 32, StatsScreen.this.field_230709_l_ - 64, 10);
            ObjectArrayList objectArrayList = new ObjectArrayList(Stats.field_199092_j.iterator());
            objectArrayList.sort(Comparator.comparing(stat -> I18n.func_135052_a(StatsScreen.func_238672_b_(stat), new Object[0])));
            for (Stat stat2 : objectArrayList) {
                this.func_230513_b_(new Entry(stat2));
            }
        }

        @Override
        protected void func_230433_a_(MatrixStack matrixStack) {
            StatsScreen.this.func_230446_a_(matrixStack);
        }

        class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final Stat<ResourceLocation> field_214405_b;
            private final ITextComponent field_243321_c;

            private Entry(Stat<ResourceLocation> stat) {
                this.field_214405_b = stat;
                this.field_243321_c = new TranslationTextComponent(StatsScreen.func_238672_b_(stat));
            }

            @Override
            public void func_230432_a_(MatrixStack matrixStack, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                AbstractGui.func_238475_b_(matrixStack, StatsScreen.this.field_230712_o_, this.field_243321_c, n3 + 2, n2 + 1, n % 2 == 0 ? 0xFFFFFF : 0x909090);
                String string = this.field_214405_b.func_75968_a(StatsScreen.this.field_146546_t.func_77444_a(this.field_214405_b));
                AbstractGui.func_238476_c_(matrixStack, StatsScreen.this.field_230712_o_, string, n3 + 2 + 213 - StatsScreen.this.field_230712_o_.func_78256_a(string), n2 + 1, n % 2 == 0 ? 0xFFFFFF : 0x909090);
            }
        }
    }
}

