/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.PlatformDescriptors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GPUWarning
extends ReloadListener<GPUInfo> {
    private static final Logger field_241686_a_ = LogManager.getLogger();
    private static final ResourceLocation field_241687_b_ = new ResourceLocation("gpu_warnlist.json");
    private ImmutableMap<String, String> field_241688_c_ = ImmutableMap.of();
    private boolean field_241689_d_;
    private boolean field_241690_e_;
    private boolean field_241691_f_;

    public boolean func_241692_a_() {
        return !this.field_241688_c_.isEmpty();
    }

    public boolean func_241695_b_() {
        return this.func_241692_a_() && !this.field_241690_e_;
    }

    public void func_241697_d_() {
        this.field_241689_d_ = true;
    }

    public void func_241698_e_() {
        this.field_241690_e_ = true;
    }

    public void func_241699_f_() {
        this.field_241690_e_ = true;
        this.field_241691_f_ = true;
    }

    public boolean func_241700_g_() {
        return this.field_241689_d_ && !this.field_241690_e_;
    }

    public boolean func_241701_h_() {
        return this.field_241691_f_;
    }

    public void func_241702_i_() {
        this.field_241689_d_ = false;
        this.field_241690_e_ = false;
        this.field_241691_f_ = false;
    }

    @Nullable
    public String func_241703_j_() {
        return (String)this.field_241688_c_.get((Object)"renderer");
    }

    @Nullable
    public String func_241704_k_() {
        return (String)this.field_241688_c_.get((Object)"version");
    }

    @Nullable
    public String func_241705_l_() {
        return (String)this.field_241688_c_.get((Object)"vendor");
    }

    @Nullable
    public String func_243499_m() {
        StringBuilder stringBuilder = new StringBuilder();
        this.field_241688_c_.forEach((string, string2) -> stringBuilder.append((String)string).append(": ").append((String)string2));
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    @Override
    protected GPUInfo func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        iProfiler.func_219894_a();
        JsonObject \u26032 = GPUWarning.func_241696_c_(iResourceManager, iProfiler);
        if (\u26032 != null) {
            iProfiler.func_76320_a("compile_regex");
            GPUWarning.func_241693_a_(\u26032.getAsJsonArray("renderer"), arrayList);
            GPUWarning.func_241693_a_(\u26032.getAsJsonArray("version"), \u2603);
            GPUWarning.func_241693_a_(\u26032.getAsJsonArray("vendor"), \u2603);
            iProfiler.func_76319_b();
        }
        iProfiler.func_219897_b();
        return new GPUInfo(arrayList, \u2603, \u2603);
    }

    @Override
    protected void func_212853_a_(GPUInfo gPUInfo, IResourceManager iResourceManager, IProfiler iProfiler) {
        this.field_241688_c_ = gPUInfo.func_241709_a_();
    }

    private static void func_241693_a_(JsonArray jsonArray, List<Pattern> list) {
        jsonArray.forEach(jsonElement -> list.add(Pattern.compile(jsonElement.getAsString(), 2)));
    }

    @Nullable
    private static JsonObject func_241696_c_(IResourceManager iResourceManager, IProfiler iProfiler) {
        iProfiler.func_76320_a("parse_json");
        JsonObject jsonObject = null;
        try (IResource iResource = iResourceManager.func_199002_a(field_241687_b_);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iResource.func_199027_b(), StandardCharsets.UTF_8));){
            jsonObject = new JsonParser().parse((Reader)bufferedReader).getAsJsonObject();
        }
        catch (JsonSyntaxException | IOException throwable) {
            field_241686_a_.warn("Failed to load GPU warnlist");
        }
        iProfiler.func_76319_b();
        return jsonObject;
    }

    @Override
    protected /* synthetic */ Object func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
        return this.func_212854_a_(iResourceManager, iProfiler);
    }

    public static final class GPUInfo {
        private final List<Pattern> field_241706_a_;
        private final List<Pattern> field_241707_b_;
        private final List<Pattern> field_241708_c_;

        private GPUInfo(List<Pattern> list, List<Pattern> list2, List<Pattern> list3) {
            this.field_241706_a_ = list;
            this.field_241707_b_ = list2;
            this.field_241708_c_ = list3;
        }

        private static String func_241711_a_(List<Pattern> list, String string) {
            ArrayList arrayList = Lists.newArrayList();
            for (Pattern pattern : list) {
                Matcher matcher = pattern.matcher(string);
                while (matcher.find()) {
                    arrayList.add(matcher.group());
                }
            }
            return String.join((CharSequence)", ", arrayList);
        }

        private ImmutableMap<String, String> func_241709_a_() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            String \u26032 = GPUInfo.func_241711_a_(this.field_241706_a_, PlatformDescriptors.func_227776_c_());
            if (!\u26032.isEmpty()) {
                builder.put((Object)"renderer", (Object)\u26032);
            }
            if (!(\u2603 = GPUInfo.func_241711_a_(this.field_241707_b_, PlatformDescriptors.func_227777_d_())).isEmpty()) {
                builder.put((Object)"version", (Object)\u2603);
            }
            if (!(\u2603 = GPUInfo.func_241711_a_(this.field_241708_c_, PlatformDescriptors.func_227774_a_())).isEmpty()) {
                builder.put((Object)"vendor", (Object)\u2603);
            }
            return builder.build();
        }
    }
}

