/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ItemOverride {
    private final ResourceLocation field_188028_a;
    private final Map<ResourceLocation, Float> field_188029_b;

    public ItemOverride(ResourceLocation resourceLocation, Map<ResourceLocation, Float> map) {
        this.field_188028_a = resourceLocation;
        this.field_188029_b = map;
    }

    public ResourceLocation func_188026_a() {
        return this.field_188028_a;
    }

    boolean func_239289_a_(ItemStack itemStack, @Nullable ClientWorld clientWorld, @Nullable LivingEntity livingEntity) {
        Item item = itemStack.func_77973_b();
        for (Map.Entry<ResourceLocation, Float> entry : this.field_188029_b.entrySet()) {
            IItemPropertyGetter iItemPropertyGetter = ItemModelsProperties.func_239417_a_(item, entry.getKey());
            if (iItemPropertyGetter != null && !(iItemPropertyGetter.call(itemStack, clientWorld, livingEntity) < entry.getValue().floatValue())) continue;
            return false;
        }
        return true;
    }

    public static class Deserializer
    implements JsonDeserializer<ItemOverride> {
        protected Deserializer() {
        }

        public ItemOverride deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            ResourceLocation \u26032 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "model"));
            Map<ResourceLocation, Float> \u26033 = this.func_188025_a(jsonObject);
            return new ItemOverride(\u26032, \u26033);
        }

        protected Map<ResourceLocation, Float> func_188025_a(JsonObject jsonObject) {
            LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
            JsonObject \u26032 = JSONUtils.func_152754_s(jsonObject, "predicate");
            for (Map.Entry entry : \u26032.entrySet()) {
                linkedHashMap.put(new ResourceLocation((String)entry.getKey()), Float.valueOf(JSONUtils.func_151220_d((JsonElement)entry.getValue(), (String)entry.getKey())));
            }
            return linkedHashMap;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

