/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ClientRecipeBook
extends RecipeBook {
    private static final Logger field_241555_k_ = LogManager.getLogger();
    private Map<RecipeBookCategories, List<RecipeList>> field_197931_e = ImmutableMap.of();
    private List<RecipeList> field_197932_f = ImmutableList.of();

    public void func_243196_a(Iterable<IRecipe<?>> iterable) {
        Map<RecipeBookCategories, List<List<IRecipe<?>>>> map = ClientRecipeBook.func_243201_b(iterable);
        HashMap \u26032 = Maps.newHashMap();
        ImmutableList.Builder \u26033 = ImmutableList.builder();
        map.forEach((recipeBookCategories, list) -> {
            List cfr_ignored_0 = (List)\u26032.put(recipeBookCategories, list.stream().map(RecipeList::new).peek(arg_0 -> ((ImmutableList.Builder)\u26033).add(arg_0)).collect(ImmutableList.toImmutableList()));
        });
        RecipeBookCategories.field_243235_w.forEach((recipeBookCategories2, list) -> {
            List cfr_ignored_0 = (List)\u26032.put(recipeBookCategories2, list.stream().flatMap(recipeBookCategories -> ((List)\u26032.getOrDefault(recipeBookCategories, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList()));
        });
        this.field_197931_e = ImmutableMap.copyOf((Map)\u26032);
        this.field_197932_f = \u26033.build();
    }

    private static Map<RecipeBookCategories, List<List<IRecipe<?>>>> func_243201_b(Iterable<IRecipe<?>> iterable) {
        HashMap hashMap = Maps.newHashMap();
        HashBasedTable \u26032 = HashBasedTable.create();
        for (IRecipe<?> iRecipe : iterable) {
            if (iRecipe.func_192399_d()) continue;
            RecipeBookCategories recipeBookCategories2 = ClientRecipeBook.func_202887_g(iRecipe);
            String \u26033 = iRecipe.func_193358_e();
            if (\u26033.isEmpty()) {
                hashMap.computeIfAbsent(recipeBookCategories2, recipeBookCategories -> Lists.newArrayList()).add(ImmutableList.of(iRecipe));
                continue;
            }
            List \u26034 = (List)\u26032.get((Object)recipeBookCategories2, (Object)\u26033);
            if (\u26034 == null) {
                \u26034 = Lists.newArrayList();
                \u26032.put((Object)recipeBookCategories2, (Object)\u26033, (Object)\u26034);
                hashMap.computeIfAbsent(recipeBookCategories2, recipeBookCategories -> Lists.newArrayList()).add(\u26034);
            }
            \u26034.add(iRecipe);
        }
        return hashMap;
    }

    private static RecipeBookCategories func_202887_g(IRecipe<?> iRecipe) {
        IRecipeType<?> iRecipeType = iRecipe.func_222127_g();
        if (iRecipeType == IRecipeType.field_222149_a) {
            ItemStack itemStack = iRecipe.func_77571_b();
            ItemGroup \u26032 = itemStack.func_77973_b().func_77640_w();
            if (\u26032 == ItemGroup.field_78030_b) {
                return RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
            }
            if (\u26032 == ItemGroup.field_78040_i || \u26032 == ItemGroup.field_78037_j) {
                return RecipeBookCategories.CRAFTING_EQUIPMENT;
            }
            if (\u26032 == ItemGroup.field_78028_d) {
                return RecipeBookCategories.CRAFTING_REDSTONE;
            }
            return RecipeBookCategories.CRAFTING_MISC;
        }
        if (iRecipeType == IRecipeType.field_222150_b) {
            if (iRecipe.func_77571_b().func_77973_b().func_219971_r()) {
                return RecipeBookCategories.FURNACE_FOOD;
            }
            if (iRecipe.func_77571_b().func_77973_b() instanceof BlockItem) {
                return RecipeBookCategories.FURNACE_BLOCKS;
            }
            return RecipeBookCategories.FURNACE_MISC;
        }
        if (iRecipeType == IRecipeType.field_222151_c) {
            if (iRecipe.func_77571_b().func_77973_b() instanceof BlockItem) {
                return RecipeBookCategories.BLAST_FURNACE_BLOCKS;
            }
            return RecipeBookCategories.BLAST_FURNACE_MISC;
        }
        if (iRecipeType == IRecipeType.field_222152_d) {
            return RecipeBookCategories.SMOKER_FOOD;
        }
        if (iRecipeType == IRecipeType.field_222154_f) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (iRecipeType == IRecipeType.field_222153_e) {
            return RecipeBookCategories.CAMPFIRE;
        }
        if (iRecipeType == IRecipeType.field_234827_g_) {
            return RecipeBookCategories.SMITHING;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> Registry.field_218367_H.func_177774_c(iRecipe.func_222127_g());
        supplierArray[1] = iRecipe::func_199560_c;
        field_241555_k_.warn("Unknown recipe category: {}/{}", supplierArray);
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeList> func_199642_d() {
        return this.field_197932_f;
    }

    public List<RecipeList> func_202891_a(RecipeBookCategories recipeBookCategories) {
        return this.field_197931_e.getOrDefault((Object)recipeBookCategories, Collections.emptyList());
    }
}

