/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeModifierManager {
    private static final Logger field_233774_a_ = LogManager.getLogger();
    private final Map<Attribute, ModifiableAttributeInstance> field_233775_b_ = Maps.newHashMap();
    private final Set<ModifiableAttributeInstance> field_233776_c_ = Sets.newHashSet();
    private final AttributeModifierMap field_233777_d_;

    public AttributeModifierManager(AttributeModifierMap attributeModifierMap) {
        this.field_233777_d_ = attributeModifierMap;
    }

    private void func_233783_a_(ModifiableAttributeInstance modifiableAttributeInstance) {
        if (modifiableAttributeInstance.func_111123_a().func_111111_c()) {
            this.field_233776_c_.add(modifiableAttributeInstance);
        }
    }

    public Set<ModifiableAttributeInstance> func_233778_a_() {
        return this.field_233776_c_;
    }

    public Collection<ModifiableAttributeInstance> func_233789_b_() {
        return this.field_233775_b_.values().stream().filter(modifiableAttributeInstance -> modifiableAttributeInstance.func_111123_a().func_111111_c()).collect(Collectors.toList());
    }

    @Nullable
    public ModifiableAttributeInstance func_233779_a_(Attribute attribute2) {
        return this.field_233775_b_.computeIfAbsent(attribute2, attribute -> this.field_233777_d_.func_233806_a_(this::func_233783_a_, (Attribute)attribute));
    }

    public boolean func_233790_b_(Attribute attribute) {
        return this.field_233775_b_.get(attribute) != null || this.field_233777_d_.func_233809_c_(attribute);
    }

    public boolean func_233782_a_(Attribute attribute, UUID uUID) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233775_b_.get(attribute);
        return modifiableAttributeInstance != null ? modifiableAttributeInstance.func_111127_a(uUID) != null : this.field_233777_d_.func_233808_b_(attribute, uUID);
    }

    public double func_233795_c_(Attribute attribute) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233775_b_.get(attribute);
        return modifiableAttributeInstance != null ? modifiableAttributeInstance.func_111126_e() : this.field_233777_d_.func_233804_a_(attribute);
    }

    public double func_233797_d_(Attribute attribute) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233775_b_.get(attribute);
        return modifiableAttributeInstance != null ? modifiableAttributeInstance.func_111125_b() : this.field_233777_d_.func_233807_b_(attribute);
    }

    public double func_233791_b_(Attribute attribute, UUID uUID) {
        ModifiableAttributeInstance modifiableAttributeInstance = this.field_233775_b_.get(attribute);
        return modifiableAttributeInstance != null ? modifiableAttributeInstance.func_111127_a(uUID).func_111164_d() : this.field_233777_d_.func_233805_a_(attribute, uUID);
    }

    public void func_233785_a_(Multimap<Attribute, AttributeModifier> multimap) {
        multimap.asMap().forEach((attribute, collection) -> {
            ModifiableAttributeInstance modifiableAttributeInstance = this.field_233775_b_.get(attribute);
            if (modifiableAttributeInstance != null) {
                collection.forEach(modifiableAttributeInstance::func_111124_b);
            }
        });
    }

    public void func_233793_b_(Multimap<Attribute, AttributeModifier> multimap) {
        multimap.forEach((attribute, attributeModifier) -> {
            ModifiableAttributeInstance modifiableAttributeInstance = this.func_233779_a_((Attribute)attribute);
            if (modifiableAttributeInstance != null) {
                modifiableAttributeInstance.func_111124_b((AttributeModifier)attributeModifier);
                modifiableAttributeInstance.func_233767_b_((AttributeModifier)attributeModifier);
            }
        });
    }

    public void func_233784_a_(AttributeModifierManager attributeModifierManager) {
        attributeModifierManager.field_233775_b_.values().forEach(modifiableAttributeInstance -> {
            \u2603 = this.func_233779_a_(modifiableAttributeInstance.func_111123_a());
            if (\u2603 != null) {
                \u2603.func_233763_a_((ModifiableAttributeInstance)modifiableAttributeInstance);
            }
        });
    }

    public ListNBT func_233794_c_() {
        ListNBT listNBT = new ListNBT();
        for (ModifiableAttributeInstance modifiableAttributeInstance : this.field_233775_b_.values()) {
            listNBT.add(modifiableAttributeInstance.func_233772_g_());
        }
        return listNBT;
    }

    public void func_233788_a_(ListNBT listNBT) {
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT = listNBT.func_150305_b(i);
            String \u26032 = compoundNBT.func_74779_i("Name");
            Util.func_215077_a(Registry.field_239692_aP_.func_241873_b(ResourceLocation.func_208304_a(\u26032)), attribute -> {
                ModifiableAttributeInstance modifiableAttributeInstance = this.func_233779_a_((Attribute)attribute);
                if (modifiableAttributeInstance != null) {
                    modifiableAttributeInstance.func_233765_a_(compoundNBT);
                }
            }, () -> field_233774_a_.warn("Ignoring unknown attribute '{}'", (Object)\u26032));
        }
    }
}

