/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.loot.LootType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class LootTypesManager {
    public static <E, T extends LootType<E>> LootTypeRegistryWrapper<E, T> func_237389_a_(Registry<T> registry, String string, String string2, Function<E, T> function) {
        return new LootTypeRegistryWrapper(registry, string, string2, function);
    }

    public static interface ISerializer<T> {
        public JsonElement func_237397_a_(T var1, JsonSerializationContext var2);

        public T func_237396_a_(JsonElement var1, JsonDeserializationContext var2);
    }

    static class Serializer<E, T extends LootType<E>>
    implements JsonDeserializer<E>,
    JsonSerializer<E> {
        private final Registry<T> field_237398_a_;
        private final String field_237399_b_;
        private final String field_237400_c_;
        private final Function<E, T> field_237401_d_;
        @Nullable
        private final Pair<T, ISerializer<? extends E>> field_237402_e_;

        private Serializer(Registry<T> registry, String string, String string2, Function<E, T> function, @Nullable Pair<T, ISerializer<? extends E>> pair) {
            this.field_237398_a_ = registry;
            this.field_237399_b_ = string;
            this.field_237400_c_ = string2;
            this.field_237401_d_ = function;
            this.field_237402_e_ = pair;
        }

        public E deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, this.field_237399_b_);
                ResourceLocation \u26032 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, this.field_237400_c_));
                LootType \u26033 = (LootType)this.field_237398_a_.func_82594_a(\u26032);
                if (\u26033 == null) {
                    throw new JsonSyntaxException("Unknown type '" + \u26032 + "'");
                }
                return (E)\u26033.func_237408_a_().func_230423_a_(jsonObject, jsonDeserializationContext);
            }
            if (this.field_237402_e_ == null) {
                throw new UnsupportedOperationException("Object " + jsonElement + " can't be deserialized");
            }
            return (E)((ISerializer)this.field_237402_e_.getSecond()).func_237396_a_(jsonElement, jsonDeserializationContext);
        }

        public JsonElement serialize(E e, Type type, JsonSerializationContext jsonSerializationContext) {
            LootType lootType = (LootType)this.field_237401_d_.apply(e);
            if (this.field_237402_e_ != null && this.field_237402_e_.getFirst() == lootType) {
                return ((ISerializer)this.field_237402_e_.getSecond()).func_237397_a_(e, jsonSerializationContext);
            }
            if (lootType == null) {
                throw new JsonSyntaxException("Unknown type: " + e);
            }
            JsonObject \u26032 = new JsonObject();
            \u26032.addProperty(this.field_237400_c_, this.field_237398_a_.func_177774_c(lootType).toString());
            lootType.func_237408_a_().func_230424_a_(\u26032, e, jsonSerializationContext);
            return \u26032;
        }
    }

    public static class LootTypeRegistryWrapper<E, T extends LootType<E>> {
        private final Registry<T> field_237390_a_;
        private final String field_237391_b_;
        private final String field_237392_c_;
        private final Function<E, T> field_237393_d_;
        @Nullable
        private Pair<T, ISerializer<? extends E>> field_237394_e_;

        private LootTypeRegistryWrapper(Registry<T> registry, String string, String string2, Function<E, T> function) {
            this.field_237390_a_ = registry;
            this.field_237391_b_ = string;
            this.field_237392_c_ = string2;
            this.field_237393_d_ = function;
        }

        public Object func_237395_a_() {
            return new Serializer(this.field_237390_a_, this.field_237391_b_, this.field_237392_c_, this.field_237393_d_, this.field_237394_e_);
        }
    }
}

