/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.ArrayUtils;

public class LongArrayNBT
extends CollectionNBT<LongNBT> {
    public static final INBTType<LongArrayNBT> field_229696_a_ = new INBTType<LongArrayNBT>(){

        @Override
        public LongArrayNBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            nBTSizeTracker.func_152450_a(192L);
            int n2 = dataInput.readInt();
            nBTSizeTracker.func_152450_a(64L * (long)n2);
            long[] \u26032 = new long[n2];
            for (\u2603 = 0; \u2603 < n2; ++\u2603) {
                \u26032[\u2603] = dataInput.readLong();
            }
            return new LongArrayNBT(\u26032);
        }

        @Override
        public String func_225648_a_() {
            return "LONG[]";
        }

        @Override
        public String func_225650_b_() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ INBT func_225649_b_(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
            return this.func_225649_b_(dataInput, n, nBTSizeTracker);
        }
    };
    private long[] field_193587_b;

    public LongArrayNBT(long[] lArray) {
        this.field_193587_b = lArray;
    }

    public LongArrayNBT(LongSet longSet) {
        this.field_193587_b = longSet.toLongArray();
    }

    public LongArrayNBT(List<Long> list) {
        this(LongArrayNBT.func_193586_a(list));
    }

    private static long[] func_193586_a(List<Long> list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Long l = list.get(i);
            lArray[i] = l == null ? 0L : l;
        }
        return lArray;
    }

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.field_193587_b.length);
        for (long l : this.field_193587_b) {
            dataOutput.writeLong(l);
        }
    }

    @Override
    public byte func_74732_a() {
        return 12;
    }

    public INBTType<LongArrayNBT> func_225647_b_() {
        return field_229696_a_;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[L;");
        for (int i = 0; i < this.field_193587_b.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_193587_b[i]).append('L');
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public LongArrayNBT func_74737_b() {
        long[] lArray = new long[this.field_193587_b.length];
        System.arraycopy(this.field_193587_b, 0, lArray, 0, this.field_193587_b.length);
        return new LongArrayNBT(lArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof LongArrayNBT && Arrays.equals(this.field_193587_b, ((LongArrayNBT)object).field_193587_b);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.field_193587_b);
    }

    @Override
    public ITextComponent func_199850_a(String string, int n) {
        IFormattableTextComponent iFormattableTextComponent;
        IFormattableTextComponent iFormattableTextComponent2 = new StringTextComponent("L").func_240699_a_(field_197641_e);
        iFormattableTextComponent = new StringTextComponent("[").func_230529_a_(iFormattableTextComponent2).func_240702_b_(";");
        for (int i = 0; i < this.field_193587_b.length; ++i) {
            IFormattableTextComponent iFormattableTextComponent3 = new StringTextComponent(String.valueOf(this.field_193587_b[i])).func_240699_a_(field_197640_d);
            iFormattableTextComponent.func_240702_b_(" ").func_230529_a_(iFormattableTextComponent3).func_230529_a_(iFormattableTextComponent2);
            if (i == this.field_193587_b.length - 1) continue;
            iFormattableTextComponent.func_240702_b_(",");
        }
        iFormattableTextComponent.func_240702_b_("]");
        return iFormattableTextComponent;
    }

    public long[] func_197652_h() {
        return this.field_193587_b;
    }

    @Override
    public int size() {
        return this.field_193587_b.length;
    }

    @Override
    public LongNBT get(int n) {
        return LongNBT.func_229698_a_(this.field_193587_b[n]);
    }

    @Override
    public LongNBT set(int n, LongNBT longNBT) {
        long l = this.field_193587_b[n];
        this.field_193587_b[n] = longNBT.func_150291_c();
        return LongNBT.func_229698_a_(l);
    }

    @Override
    public void add(int n, LongNBT longNBT) {
        this.field_193587_b = ArrayUtils.add((long[])this.field_193587_b, (int)n, (long)longNBT.func_150291_c());
    }

    @Override
    public boolean func_218659_a(int n, INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            this.field_193587_b[n] = ((NumberNBT)iNBT).func_150291_c();
            return true;
        }
        return false;
    }

    @Override
    public boolean func_218660_b(int n, INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            this.field_193587_b = ArrayUtils.add((long[])this.field_193587_b, (int)n, (long)((NumberNBT)iNBT).func_150291_c());
            return true;
        }
        return false;
    }

    @Override
    public LongNBT remove(int n) {
        long l = this.field_193587_b[n];
        this.field_193587_b = ArrayUtils.remove((long[])this.field_193587_b, (int)n);
        return LongNBT.func_229698_a_(l);
    }

    @Override
    public byte func_230528_d__() {
        return 4;
    }

    @Override
    public void clear() {
        this.field_193587_b = new long[0];
    }

    @Override
    public /* synthetic */ INBT remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, INBT iNBT) {
        this.add(n, (LongNBT)iNBT);
    }

    @Override
    public /* synthetic */ INBT set(int n, INBT iNBT) {
        return this.set(n, (LongNBT)iNBT);
    }

    @Override
    public /* synthetic */ INBT func_74737_b() {
        return this.func_74737_b();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (LongNBT)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (LongNBT)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

