/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.concurrent;

import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public interface ITaskQueue<T, F> {
    @Nullable
    public F func_212827_a_();

    public boolean func_212828_a_(T var1);

    public boolean func_219946_b();

    public static final class Priority
    implements ITaskQueue<RunnableWithPriority, Runnable> {
        private final List<Queue<Runnable>> field_219949_a;

        public Priority(int n2) {
            this.field_219949_a = IntStream.range(0, n2).mapToObj(n -> Queues.newConcurrentLinkedQueue()).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public Runnable func_212827_a_() {
            for (Queue<Runnable> queue : this.field_219949_a) {
                Runnable runnable = queue.poll();
                if (runnable == null) continue;
                return runnable;
            }
            return null;
        }

        @Override
        public boolean func_212828_a_(RunnableWithPriority runnableWithPriority) {
            int n = runnableWithPriority.func_219950_a();
            this.field_219949_a.get(n).add(runnableWithPriority);
            return true;
        }

        @Override
        public boolean func_219946_b() {
            return this.field_219949_a.stream().allMatch(Collection::isEmpty);
        }

        @Override
        @Nullable
        public /* synthetic */ Object func_212827_a_() {
            return this.func_212827_a_();
        }
    }

    public static final class RunnableWithPriority
    implements Runnable {
        private final int field_219951_a;
        private final Runnable field_219952_b;

        public RunnableWithPriority(int n, Runnable runnable) {
            this.field_219951_a = n;
            this.field_219952_b = runnable;
        }

        @Override
        public void run() {
            this.field_219952_b.run();
        }

        public int func_219950_a() {
            return this.field_219951_a;
        }
    }

    public static final class Single<T>
    implements ITaskQueue<T, T> {
        private final Queue<T> field_219947_a;

        public Single(Queue<T> queue) {
            this.field_219947_a = queue;
        }

        @Override
        @Nullable
        public T func_212827_a_() {
            return this.field_219947_a.poll();
        }

        @Override
        public boolean func_212828_a_(T t) {
            return this.field_219947_a.add(t);
        }

        @Override
        public boolean func_219946_b() {
            return this.field_219947_a.isEmpty();
        }
    }
}

