/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.filter;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.text.filter.IChatFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChatFilterClient
implements AutoCloseable {
    private static final Logger field_244549_a = LogManager.getLogger();
    private static final AtomicInteger field_244550_b = new AtomicInteger(1);
    private static final ThreadFactory field_244551_c = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + field_244550_b.getAndIncrement());
        return thread;
    };
    private final URL field_244552_d;
    private final URL field_244553_e;
    private final URL field_244554_f;
    private final String field_244555_g;
    private final int field_244556_h;
    private final String field_244557_i;
    private final IIgnoreTest field_244558_j;
    private final ExecutorService field_244559_k;

    private void func_244568_a(GameProfile gameProfile, URL uRL, Executor executor) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server", this.field_244557_i);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("user_id", gameProfile.getId().toString());
        jsonObject.addProperty("user_display_name", gameProfile.getName());
        executor.execute(() -> {
            try {
                this.func_244573_b(jsonObject, uRL);
            }
            catch (Exception exception) {
                field_244549_a.warn("Failed to send join/leave packet to {} for player {}", (Object)uRL, (Object)gameProfile, (Object)exception);
            }
        });
    }

    private CompletableFuture<Optional<String>> func_244567_a(GameProfile gameProfile, String string, IIgnoreTest iIgnoreTest, Executor executor) {
        if (string.isEmpty()) {
            return CompletableFuture.completedFuture(Optional.of(""));
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("rule", (Number)this.field_244556_h);
        jsonObject.addProperty("server", this.field_244557_i);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("player", gameProfile.getId().toString());
        jsonObject.addProperty("player_display_name", gameProfile.getName());
        jsonObject.addProperty("text", string);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject jsonObject2 = this.func_244564_a(jsonObject, this.field_244552_d);
                boolean \u26032 = JSONUtils.func_151209_a(jsonObject2, "response", false);
                if (\u26032) {
                    return Optional.of(string);
                }
                String \u26033 = JSONUtils.func_151219_a(jsonObject2, "hashed", null);
                if (\u26033 == null) {
                    return Optional.empty();
                }
                int \u26034 = JSONUtils.func_151214_t(jsonObject2, "hashes").size();
                return iIgnoreTest.shouldIgnore(\u26033, \u26034) ? Optional.empty() : Optional.of(\u26033);
            }
            catch (Exception exception) {
                field_244549_a.warn("Failed to validate message '{}'", (Object)string, (Object)exception);
                return Optional.empty();
            }
        }, executor);
    }

    @Override
    public void close() {
        this.field_244559_k.shutdownNow();
    }

    private void func_244569_a(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject func_244564_a(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.func_244575_c(jsonObject, uRL);
        Throwable throwable = null;
        try (InputStream \u26032 = httpURLConnection.getInputStream();){
            JsonObject jsonObject2;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject3 = new JsonObject();
                return jsonObject3;
            }
            try {
                jsonObject2 = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(\u26032))).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                try {
                    this.func_244569_a(\u26032);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            this.func_244569_a(\u26032);
            return jsonObject2;
        }
    }

    private void func_244573_b(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.func_244575_c(jsonObject, uRL);
        try (InputStream \u26032 = httpURLConnection.getInputStream();){
            this.func_244569_a(\u26032);
        }
    }

    private HttpURLConnection func_244575_c(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(2000);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("Authorization", "Basic " + this.field_244555_g);
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.func_215069_a().getName());
        try (OutputStreamWriter \u26032 = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)\u26032);){
            Streams.write((JsonElement)jsonObject, (JsonWriter)jsonWriter);
        }
        int \u26033 = httpURLConnection.getResponseCode();
        if (\u26033 < 200 || \u26033 >= 300) {
            throw new ConnectionException(\u26033 + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    public IChatFilter func_244566_a(GameProfile gameProfile) {
        return new ProfileFilter(gameProfile);
    }

    @FunctionalInterface
    public static interface IIgnoreTest {
        public static final IIgnoreTest field_244577_a = (string, n) -> false;
        public static final IIgnoreTest field_244578_b = (string, n) -> string.length() == n;

        public boolean shouldIgnore(String var1, int var2);
    }

    class ProfileFilter
    implements IChatFilter {
        private final GameProfile field_244585_b;
        private final Executor field_244586_c;

        private ProfileFilter(GameProfile gameProfile) {
            this.field_244585_b = gameProfile;
            DelegatedTaskExecutor<Runnable> delegatedTaskExecutor = DelegatedTaskExecutor.func_213144_a(ChatFilterClient.this.field_244559_k, "chat stream for " + gameProfile.getName());
            this.field_244586_c = delegatedTaskExecutor::func_212871_a_;
        }

        @Override
        public void func_244800_a() {
            ChatFilterClient.this.func_244568_a(this.field_244585_b, ChatFilterClient.this.field_244553_e, this.field_244586_c);
        }

        @Override
        public void func_244434_b() {
            ChatFilterClient.this.func_244568_a(this.field_244585_b, ChatFilterClient.this.field_244554_f, this.field_244586_c);
        }

        @Override
        public CompletableFuture<Optional<List<String>>> func_244433_a(List<String> list2) {
            List list3 = (List)list2.stream().map(string -> ChatFilterClient.this.func_244567_a(this.field_244585_b, string, ChatFilterClient.this.field_244558_j, this.field_244586_c)).collect(ImmutableList.toImmutableList());
            return ((CompletableFuture)Util.func_215079_b(list3).thenApply(list -> Optional.of(list.stream().map(optional -> optional.orElse("")).collect(ImmutableList.toImmutableList())))).exceptionally(throwable -> Optional.empty());
        }

        @Override
        public CompletableFuture<Optional<String>> func_244432_a(String string) {
            return ChatFilterClient.this.func_244567_a(this.field_244585_b, string, ChatFilterClient.this.field_244558_j, this.field_244586_c);
        }
    }

    public static class ConnectionException
    extends RuntimeException {
        private ConnectionException(String string) {
            super(string);
        }
    }
}

