/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;

public class BiomeAmbience {
    public static final Codec<BiomeAmbience> field_235204_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fog_color").forGetter(biomeAmbience -> biomeAmbience.field_235205_b_), (App)Codec.INT.fieldOf("water_color").forGetter(biomeAmbience -> biomeAmbience.field_235206_c_), (App)Codec.INT.fieldOf("water_fog_color").forGetter(biomeAmbience -> biomeAmbience.field_235207_d_), (App)Codec.INT.fieldOf("sky_color").forGetter(biomeAmbience -> biomeAmbience.field_242523_e), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(biomeAmbience -> biomeAmbience.field_242524_f), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(biomeAmbience -> biomeAmbience.field_242525_g), (App)GrassColorModifier.field_242542_d.optionalFieldOf("grass_color_modifier", (Object)GrassColorModifier.NONE).forGetter(biomeAmbience -> biomeAmbience.field_242526_h), (App)ParticleEffectAmbience.field_235041_a_.optionalFieldOf("particle").forGetter(biomeAmbience -> biomeAmbience.field_235208_e_), (App)SoundEvent.field_232678_a_.optionalFieldOf("ambient_sound").forGetter(biomeAmbience -> biomeAmbience.field_235209_f_), (App)MoodSoundAmbience.field_235026_a_.optionalFieldOf("mood_sound").forGetter(biomeAmbience -> biomeAmbience.field_235210_g_), (App)SoundAdditionsAmbience.field_235018_a_.optionalFieldOf("additions_sound").forGetter(biomeAmbience -> biomeAmbience.field_235211_h_), (App)BackgroundMusicSelector.field_232656_a_.optionalFieldOf("music").forGetter(biomeAmbience -> biomeAmbience.field_235212_i_)).apply((Applicative)instance, BiomeAmbience::new));
    private final int field_235205_b_;
    private final int field_235206_c_;
    private final int field_235207_d_;
    private final int field_242523_e;
    private final Optional<Integer> field_242524_f;
    private final Optional<Integer> field_242525_g;
    private final GrassColorModifier field_242526_h;
    private final Optional<ParticleEffectAmbience> field_235208_e_;
    private final Optional<SoundEvent> field_235209_f_;
    private final Optional<MoodSoundAmbience> field_235210_g_;
    private final Optional<SoundAdditionsAmbience> field_235211_h_;
    private final Optional<BackgroundMusicSelector> field_235212_i_;

    private BiomeAmbience(int n, int n2, int n3, int n4, Optional<Integer> optional, Optional<Integer> optional2, GrassColorModifier grassColorModifier, Optional<ParticleEffectAmbience> optional3, Optional<SoundEvent> optional4, Optional<MoodSoundAmbience> optional5, Optional<SoundAdditionsAmbience> optional6, Optional<BackgroundMusicSelector> optional7) {
        this.field_235205_b_ = n;
        this.field_235206_c_ = n2;
        this.field_235207_d_ = n3;
        this.field_242523_e = n4;
        this.field_242524_f = optional;
        this.field_242525_g = optional2;
        this.field_242526_h = grassColorModifier;
        this.field_235208_e_ = optional3;
        this.field_235209_f_ = optional4;
        this.field_235210_g_ = optional5;
        this.field_235211_h_ = optional6;
        this.field_235212_i_ = optional7;
    }

    public int func_235213_a_() {
        return this.field_235205_b_;
    }

    public int func_235216_b_() {
        return this.field_235206_c_;
    }

    public int func_235218_c_() {
        return this.field_235207_d_;
    }

    public int func_242527_d() {
        return this.field_242523_e;
    }

    public Optional<Integer> func_242528_e() {
        return this.field_242524_f;
    }

    public Optional<Integer> func_242529_f() {
        return this.field_242525_g;
    }

    public GrassColorModifier func_242531_g() {
        return this.field_242526_h;
    }

    public Optional<ParticleEffectAmbience> func_235220_d_() {
        return this.field_235208_e_;
    }

    public Optional<SoundEvent> func_235222_e_() {
        return this.field_235209_f_;
    }

    public Optional<MoodSoundAmbience> func_235224_f_() {
        return this.field_235210_g_;
    }

    public Optional<SoundAdditionsAmbience> func_235226_g_() {
        return this.field_235211_h_;
    }

    public Optional<BackgroundMusicSelector> func_235228_h_() {
        return this.field_235212_i_;
    }

    public static enum GrassColorModifier implements IStringSerializable
    {
        NONE("none"){

            @Override
            public int func_241853_a(double d, double d2, int n) {
                return n;
            }
        }
        ,
        DARK_FOREST("dark_forest"){

            @Override
            public int func_241853_a(double d, double d2, int n) {
                return (n & 0xFEFEFE) + 2634762 >> 1;
            }
        }
        ,
        SWAMP("swamp"){

            @Override
            public int func_241853_a(double d, double d2, int n) {
                double d3 = Biome.field_180281_af.func_215464_a(d * 0.0225, d2 * 0.0225, false);
                if (d3 < -0.1) {
                    return 5011004;
                }
                return 6975545;
            }
        };

        private final String field_242543_e;
        public static final Codec<GrassColorModifier> field_242542_d;
        private static final Map<String, GrassColorModifier> field_242544_f;

        public abstract int func_241853_a(double var1, double var3, int var5);

        private GrassColorModifier(String string2) {
            this.field_242543_e = string2;
        }

        public String func_242547_b() {
            return this.field_242543_e;
        }

        @Override
        public String func_176610_l() {
            return this.field_242543_e;
        }

        public static GrassColorModifier func_242546_a(String string) {
            return field_242544_f.get(string);
        }

        static {
            field_242542_d = IStringSerializable.func_233023_a_(GrassColorModifier::values, GrassColorModifier::func_242546_a);
            field_242544_f = Arrays.stream(GrassColorModifier.values()).collect(Collectors.toMap(GrassColorModifier::func_242547_b, grassColorModifier -> grassColorModifier));
        }
    }

    public static class Builder {
        private OptionalInt field_235230_a_ = OptionalInt.empty();
        private OptionalInt field_235231_b_ = OptionalInt.empty();
        private OptionalInt field_235232_c_ = OptionalInt.empty();
        private OptionalInt field_242533_d = OptionalInt.empty();
        private Optional<Integer> field_242534_e = Optional.empty();
        private Optional<Integer> field_242535_f = Optional.empty();
        private GrassColorModifier field_242536_g = GrassColorModifier.NONE;
        private Optional<ParticleEffectAmbience> field_235233_d_ = Optional.empty();
        private Optional<SoundEvent> field_235234_e_ = Optional.empty();
        private Optional<MoodSoundAmbience> field_235235_f_ = Optional.empty();
        private Optional<SoundAdditionsAmbience> field_235236_g_ = Optional.empty();
        private Optional<BackgroundMusicSelector> field_235237_h_ = Optional.empty();

        public Builder func_235239_a_(int n) {
            this.field_235230_a_ = OptionalInt.of(n);
            return this;
        }

        public Builder func_235246_b_(int n) {
            this.field_235231_b_ = OptionalInt.of(n);
            return this;
        }

        public Builder func_235248_c_(int n) {
            this.field_235232_c_ = OptionalInt.of(n);
            return this;
        }

        public Builder func_242539_d(int n) {
            this.field_242533_d = OptionalInt.of(n);
            return this;
        }

        public Builder func_242540_e(int n) {
            this.field_242534_e = Optional.of(n);
            return this;
        }

        public Builder func_242541_f(int n) {
            this.field_242535_f = Optional.of(n);
            return this;
        }

        public Builder func_242537_a(GrassColorModifier grassColorModifier) {
            this.field_242536_g = grassColorModifier;
            return this;
        }

        public Builder func_235244_a_(ParticleEffectAmbience particleEffectAmbience) {
            this.field_235233_d_ = Optional.of(particleEffectAmbience);
            return this;
        }

        public Builder func_235241_a_(SoundEvent soundEvent) {
            this.field_235234_e_ = Optional.of(soundEvent);
            return this;
        }

        public Builder func_235243_a_(MoodSoundAmbience moodSoundAmbience) {
            this.field_235235_f_ = Optional.of(moodSoundAmbience);
            return this;
        }

        public Builder func_235242_a_(SoundAdditionsAmbience soundAdditionsAmbience) {
            this.field_235236_g_ = Optional.of(soundAdditionsAmbience);
            return this;
        }

        public Builder func_235240_a_(BackgroundMusicSelector backgroundMusicSelector) {
            this.field_235237_h_ = Optional.of(backgroundMusicSelector);
            return this;
        }

        public BiomeAmbience func_235238_a_() {
            return new BiomeAmbience(this.field_235230_a_.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.field_235231_b_.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.field_235232_c_.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.field_242533_d.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.field_242534_e, this.field_242535_f, this.field_242536_g, this.field_235233_d_, this.field_235234_e_, this.field_235235_f_, this.field_235236_g_, this.field_235237_h_);
        }
    }
}

