/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.storage.ChunkLoaderUtil;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilSaveConverter {
    private static final Logger field_151480_b = LogManager.getLogger();

    static boolean func_237330_a_(SaveFormat.LevelSave levelSave, IProgressUpdate iProgressUpdate) {
        iProgressUpdate.func_73718_a(0);
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        File \u26032 = levelSave.func_237291_a_(World.field_234918_g_);
        File \u26033 = levelSave.func_237291_a_(World.field_234919_h_);
        File \u26034 = levelSave.func_237291_a_(World.field_234920_i_);
        field_151480_b.info("Scanning folders...");
        AnvilSaveConverter.func_215789_a(\u26032, arrayList);
        if (\u26033.exists()) {
            AnvilSaveConverter.func_215789_a(\u26033, \u2603);
        }
        if (\u26034.exists()) {
            AnvilSaveConverter.func_215789_a(\u26034, \u2603);
        }
        int \u26035 = arrayList.size() + \u2603.size() + \u2603.size();
        field_151480_b.info("Total conversion count is {}", (Object)\u26035);
        DynamicRegistries.Impl \u26036 = DynamicRegistries.func_239770_b_();
        WorldSettingsImport<INBT> \u26037 = WorldSettingsImport.func_244335_a(NBTDynamicOps.field_210820_a, IResourceManager.Instance.INSTANCE, \u26036);
        IServerConfiguration \u26038 = levelSave.func_237284_a_(\u26037, DatapackCodec.field_234880_a_);
        long \u26039 = \u26038 != null ? \u26038.func_230418_z_().func_236221_b_() : 0L;
        MutableRegistry<Biome> \u260310 = \u26036.func_243612_b(Registry.field_239720_u_);
        BiomeProvider \u260311 = \u26038 != null && \u26038.func_230418_z_().func_236228_i_() ? new SingleBiomeProvider(\u260310.func_243576_d(Biomes.field_76772_c)) : new OverworldBiomeProvider(\u26039, false, false, \u260310);
        AnvilSaveConverter.func_242983_a(\u26036, new File(\u26032, "region"), arrayList, \u260311, 0, \u26035, iProgressUpdate);
        AnvilSaveConverter.func_242983_a(\u26036, new File(\u26033, "region"), \u2603, new SingleBiomeProvider(\u260310.func_243576_d(Biomes.field_235254_j_)), arrayList.size(), \u26035, iProgressUpdate);
        AnvilSaveConverter.func_242983_a(\u26036, new File(\u26034, "region"), \u2603, new SingleBiomeProvider(\u260310.func_243576_d(Biomes.field_76779_k)), arrayList.size() + \u2603.size(), \u26035, iProgressUpdate);
        AnvilSaveConverter.func_237329_a_(levelSave);
        levelSave.func_237287_a_(\u26036, \u26038);
        return true;
    }

    private static void func_237329_a_(SaveFormat.LevelSave levelSave) {
        File file = levelSave.func_237285_a_(FolderName.field_237249_e_).toFile();
        if (!file.exists()) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
            return;
        }
        \u2603 = new File(file.getParent(), "level.dat_mcr");
        if (!file.renameTo(\u2603)) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
        }
    }

    private static void func_242983_a(DynamicRegistries.Impl impl, File file, Iterable<File> iterable, BiomeProvider biomeProvider, int n, int n2, IProgressUpdate iProgressUpdate) {
        for (File file2 : iterable) {
            AnvilSaveConverter.func_242982_a(impl, file, file2, biomeProvider, n, n2, iProgressUpdate);
            int n3 = (int)Math.round(100.0 * (double)(++n) / (double)n2);
            iProgressUpdate.func_73718_a(n3);
        }
    }

    private static void func_242982_a(DynamicRegistries.Impl impl, File file, File file2, BiomeProvider biomeProvider, int n3, int n2, IProgressUpdate iProgressUpdate) {
        String string = file2.getName();
        try (RegionFile regionFile = new RegionFile(file2, file, true);){
            regionFile2 = new RegionFile(new File(file, string.substring(0, string.length() - ".mcr".length()) + ".mca"), file, true);
            Throwable throwable = null;
            try {
                for (int i = 0; i < 32; ++i) {
                    int n3;
                    for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                        Object object;
                        ChunkPos chunkPos = new ChunkPos(i, \u2603);
                        if (!regionFile.func_222667_d(chunkPos) || regionFile2.func_222667_d(chunkPos)) continue;
                        try {
                            object = regionFile.func_222666_a(chunkPos);
                            Throwable throwable2 = null;
                            try {
                                if (object == null) {
                                    field_151480_b.warn("Failed to fetch input stream for chunk {}", (Object)chunkPos);
                                    continue;
                                }
                                CompoundNBT compoundNBT = CompressedStreamTools.func_74794_a((DataInput)object);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (object != null) {
                                    if (throwable2 != null) {
                                        try {
                                            ((FilterInputStream)object).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                    } else {
                                        ((FilterInputStream)object).close();
                                    }
                                }
                            }
                        }
                        catch (IOException iOException) {
                            field_151480_b.warn("Failed to read data for chunk {}", (Object)chunkPos, (Object)iOException);
                            continue;
                        }
                        object = compoundNBT.func_74775_l("Level");
                        ChunkLoaderUtil.AnvilConverterData \u26032 = ChunkLoaderUtil.func_76691_a((CompoundNBT)object);
                        CompoundNBT \u26033 = new CompoundNBT();
                        CompoundNBT \u26034 = new CompoundNBT();
                        \u26033.func_218657_a("Level", \u26034);
                        ChunkLoaderUtil.func_242708_a(impl, \u26032, \u26034, biomeProvider);
                        try (DataOutputStream \u26035 = regionFile2.func_222661_c(chunkPos);){
                            CompressedStreamTools.func_74800_a(\u26033, \u26035);
                            continue;
                        }
                    }
                    \u2603 = (int)Math.round(100.0 * (double)(n3 * 1024) / (double)(n2 * 1024));
                    \u2603 = (int)Math.round(100.0 * (double)((i + 1) * 32 + n3 * 1024) / (double)(n2 * 1024));
                    if (\u2603 <= \u2603) continue;
                    iProgressUpdate.func_73718_a(\u2603);
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                RegionFile regionFile2;
                if (regionFile2 != null) {
                    if (throwable != null) {
                        try {
                            regionFile2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        regionFile2.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            field_151480_b.error("Failed to upgrade region file {}", (Object)file2, (Object)iOException);
        }
    }

    private static void func_215789_a(File file2, Collection<File> collection) {
        File file3 = new File(file2, "region");
        File[] \u26032 = file3.listFiles((file, string) -> string.endsWith(".mcr"));
        if (\u26032 != null) {
            Collections.addAll(collection, \u26032);
        }
    }
}

