/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnchantingTableBlock
extends ContainerBlock {
    protected static final VoxelShape field_196322_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);

    public EnchantingTableBlock(AbstractBlock.Properties p_i48408_1_) {
        super(p_i48408_1_);
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return field_196322_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        super.func_180655_c(p_180655_1_, p_180655_2_, p_180655_3_, p_180655_4_);
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (p_180655_4_.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = p_180655_3_.func_177982_a(i, k, j);
                    if (!(p_180655_2_.func_180495_p(blockpos).getEnchantPowerBonus((IWorldReader)((Object)p_180655_2_), blockpos) > 0.0f)) continue;
                    if (!p_180655_2_.func_175623_d(p_180655_3_.func_177982_a(i / 2, 0, j / 2))) continue block1;
                    p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)p_180655_3_.func_177958_n() + 0.5, (double)p_180655_3_.func_177956_o() + 2.0, (double)p_180655_3_.func_177952_p() + 0.5, (double)((float)i + p_180655_4_.nextFloat()) - 0.5, (float)k - p_180655_4_.nextFloat() - 1.0f, (double)((float)j + p_180655_4_.nextFloat()) - 0.5);
                }
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new EnchantingTableTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        p_225533_4_.func_213829_a(p_225533_1_.func_215699_b(p_225533_2_, p_225533_3_));
        return ActionResultType.CONSUME;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState p_220052_1_, World p_220052_2_, BlockPos p_220052_3_) {
        TileEntity tileentity = p_220052_2_.func_175625_s(p_220052_3_);
        if (tileentity instanceof EnchantingTableTileEntity) {
            ITextComponent itextcomponent = ((INameable)tileentity).func_145748_c_();
            return new SimpleNamedContainerProvider((p_220147_2_, p_220147_3_, p_220147_4_) -> new EnchantmentContainer(p_220147_2_, p_220147_3_, IWorldPosCallable.func_221488_a((World)p_220052_2_, (BlockPos)p_220052_3_)), itextcomponent);
        }
        return null;
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        TileEntity tileentity;
        if (p_180633_5_.func_82837_s() && (tileentity = p_180633_1_.func_175625_s(p_180633_2_)) instanceof EnchantingTableTileEntity) {
            ((EnchantingTableTileEntity)tileentity).func_200229_a(p_180633_5_.func_200301_q());
        }
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }
}

