/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeEffectInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectInstance
implements Comparable<EffectInstance>,
IForgeEffectInstance {
    private static final Logger field_180155_a = LogManager.getLogger();
    private final Effect field_188420_b;
    private int field_76460_b;
    private int field_76461_c;
    private boolean field_82723_d;
    private boolean field_82724_e;
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_100013_f;
    private boolean field_188421_h;
    private boolean field_205349_i;
    @Nullable
    private EffectInstance field_230115_j_;
    private List<ItemStack> curativeItems;

    public EffectInstance(Effect p_i46811_1_) {
        this(p_i46811_1_, 0, 0);
    }

    public EffectInstance(Effect p_i46812_1_, int p_i46812_2_) {
        this(p_i46812_1_, p_i46812_2_, 0);
    }

    public EffectInstance(Effect p_i46813_1_, int p_i46813_2_, int p_i46813_3_) {
        this(p_i46813_1_, p_i46813_2_, p_i46813_3_, false, true);
    }

    public EffectInstance(Effect p_i46814_1_, int p_i46814_2_, int p_i46814_3_, boolean p_i46814_4_, boolean p_i46814_5_) {
        this(p_i46814_1_, p_i46814_2_, p_i46814_3_, p_i46814_4_, p_i46814_5_, p_i46814_5_);
    }

    public EffectInstance(Effect p_i48980_1_, int p_i48980_2_, int p_i48980_3_, boolean p_i48980_4_, boolean p_i48980_5_, boolean p_i48980_6_) {
        this(p_i48980_1_, p_i48980_2_, p_i48980_3_, p_i48980_4_, p_i48980_5_, p_i48980_6_, null);
    }

    public EffectInstance(Effect p_i230050_1_, int p_i230050_2_, int p_i230050_3_, boolean p_i230050_4_, boolean p_i230050_5_, boolean p_i230050_6_, @Nullable EffectInstance p_i230050_7_) {
        this.field_188420_b = p_i230050_1_;
        this.field_76460_b = p_i230050_2_;
        this.field_76461_c = p_i230050_3_;
        this.field_82724_e = p_i230050_4_;
        this.field_188421_h = p_i230050_5_;
        this.field_205349_i = p_i230050_6_;
        this.field_230115_j_ = p_i230050_7_;
    }

    public EffectInstance(EffectInstance p_i1577_1_) {
        this.field_188420_b = p_i1577_1_.field_188420_b;
        this.func_230117_a_(p_i1577_1_);
    }

    void func_230117_a_(EffectInstance p_230117_1_) {
        this.field_76460_b = p_230117_1_.field_76460_b;
        this.field_76461_c = p_230117_1_.field_76461_c;
        this.field_82724_e = p_230117_1_.field_82724_e;
        this.field_188421_h = p_230117_1_.field_188421_h;
        this.field_205349_i = p_230117_1_.field_205349_i;
        this.curativeItems = p_230117_1_.curativeItems == null ? null : new ArrayList<ItemStack>(p_230117_1_.curativeItems);
    }

    public boolean func_199308_a(EffectInstance p_199308_1_) {
        if (this.field_188420_b != p_199308_1_.field_188420_b) {
            field_180155_a.warn("This method should only be called for matching effects!");
        }
        boolean flag = false;
        if (p_199308_1_.field_76461_c > this.field_76461_c) {
            if (p_199308_1_.field_76460_b < this.field_76460_b) {
                EffectInstance effectinstance = this.field_230115_j_;
                this.field_230115_j_ = new EffectInstance(this);
                this.field_230115_j_.field_230115_j_ = effectinstance;
            }
            this.field_76461_c = p_199308_1_.field_76461_c;
            this.field_76460_b = p_199308_1_.field_76460_b;
            flag = true;
        } else if (p_199308_1_.field_76460_b > this.field_76460_b) {
            if (p_199308_1_.field_76461_c == this.field_76461_c) {
                this.field_76460_b = p_199308_1_.field_76460_b;
                flag = true;
            } else if (this.field_230115_j_ == null) {
                this.field_230115_j_ = new EffectInstance(p_199308_1_);
            } else {
                this.field_230115_j_.func_199308_a(p_199308_1_);
            }
        }
        if (!p_199308_1_.field_82724_e && this.field_82724_e || flag) {
            this.field_82724_e = p_199308_1_.field_82724_e;
            flag = true;
        }
        if (p_199308_1_.field_188421_h != this.field_188421_h) {
            this.field_188421_h = p_199308_1_.field_188421_h;
            flag = true;
        }
        if (p_199308_1_.field_205349_i != this.field_205349_i) {
            this.field_205349_i = p_199308_1_.field_205349_i;
            flag = true;
        }
        return flag;
    }

    public Effect func_188419_a() {
        return this.field_188420_b == null ? null : (Effect)((Object)this.field_188420_b.delegate.get());
    }

    public int func_76459_b() {
        return this.field_76460_b;
    }

    public int func_76458_c() {
        return this.field_76461_c;
    }

    public boolean func_82720_e() {
        return this.field_82724_e;
    }

    public boolean func_188418_e() {
        return this.field_188421_h;
    }

    public boolean func_205348_f() {
        return this.field_205349_i;
    }

    public boolean func_76455_a(LivingEntity p_76455_1_, Runnable p_76455_2_) {
        if (this.field_76460_b > 0) {
            if (this.field_188420_b.func_76397_a(this.field_76460_b, this.field_76461_c)) {
                this.func_76457_b(p_76455_1_);
            }
            this.func_76454_e();
            if (this.field_76460_b == 0 && this.field_230115_j_ != null) {
                this.func_230117_a_(this.field_230115_j_);
                this.field_230115_j_ = this.field_230115_j_.field_230115_j_;
                p_76455_2_.run();
            }
        }
        return this.field_76460_b > 0;
    }

    private int func_76454_e() {
        if (this.field_230115_j_ != null) {
            this.field_230115_j_.func_76454_e();
        }
        return --this.field_76460_b;
    }

    public void func_76457_b(LivingEntity p_76457_1_) {
        if (this.field_76460_b > 0) {
            this.field_188420_b.func_76394_a(p_76457_1_, this.field_76461_c);
        }
    }

    public String func_76453_d() {
        return this.field_188420_b.func_76393_a();
    }

    public String toString() {
        String s = this.field_76461_c > 0 ? this.func_76453_d() + " x " + (this.field_76461_c + 1) + ", Duration: " + this.field_76460_b : this.func_76453_d() + ", Duration: " + this.field_76460_b;
        if (this.field_82723_d) {
            s = s + ", Splash: true";
        }
        if (!this.field_188421_h) {
            s = s + ", Particles: false";
        }
        if (!this.field_205349_i) {
            s = s + ", Show Icon: false";
        }
        return s;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof EffectInstance)) {
            return false;
        }
        EffectInstance effectinstance = (EffectInstance)p_equals_1_;
        return this.field_76460_b == effectinstance.field_76460_b && this.field_76461_c == effectinstance.field_76461_c && this.field_82723_d == effectinstance.field_82723_d && this.field_82724_e == effectinstance.field_82724_e && ((Object)((Object)this.field_188420_b)).equals((Object)effectinstance.field_188420_b);
    }

    public int hashCode() {
        int i = ((Object)((Object)this.field_188420_b)).hashCode();
        i = 31 * i + this.field_76460_b;
        i = 31 * i + this.field_76461_c;
        i = 31 * i + (this.field_82723_d ? 1 : 0);
        return 31 * i + (this.field_82724_e ? 1 : 0);
    }

    public CompoundNBT func_82719_a(CompoundNBT p_82719_1_) {
        p_82719_1_.func_74774_a("Id", (byte)Effect.func_188409_a(this.func_188419_a()));
        this.func_230119_c_(p_82719_1_);
        return p_82719_1_;
    }

    private void func_230119_c_(CompoundNBT p_230119_1_) {
        p_230119_1_.func_74774_a("Amplifier", (byte)this.func_76458_c());
        p_230119_1_.func_74768_a("Duration", this.func_76459_b());
        p_230119_1_.func_74757_a("Ambient", this.func_82720_e());
        p_230119_1_.func_74757_a("ShowParticles", this.func_188418_e());
        p_230119_1_.func_74757_a("ShowIcon", this.func_205348_f());
        if (this.field_230115_j_ != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            this.field_230115_j_.func_82719_a(compoundnbt);
            p_230119_1_.func_218657_a("HiddenEffect", compoundnbt);
        }
        this.writeCurativeItems(p_230119_1_);
    }

    public static EffectInstance func_82722_b(CompoundNBT p_82722_0_) {
        int i = p_82722_0_.func_74771_c("Id") & 0xFF;
        Effect effect = Effect.func_188412_a(i);
        return effect == null ? null : EffectInstance.func_230116_a_(effect, p_82722_0_);
    }

    private static EffectInstance func_230116_a_(Effect p_230116_0_, CompoundNBT p_230116_1_) {
        byte i = p_230116_1_.func_74771_c("Amplifier");
        int j = p_230116_1_.func_74762_e("Duration");
        boolean flag = p_230116_1_.func_74767_n("Ambient");
        boolean flag1 = true;
        if (p_230116_1_.func_150297_b("ShowParticles", 1)) {
            flag1 = p_230116_1_.func_74767_n("ShowParticles");
        }
        boolean flag2 = flag1;
        if (p_230116_1_.func_150297_b("ShowIcon", 1)) {
            flag2 = p_230116_1_.func_74767_n("ShowIcon");
        }
        EffectInstance effectinstance = null;
        if (p_230116_1_.func_150297_b("HiddenEffect", 10)) {
            effectinstance = EffectInstance.func_230116_a_(p_230116_0_, p_230116_1_.func_74775_l("HiddenEffect"));
        }
        return EffectInstance.readCurativeItems(new EffectInstance(p_230116_0_, j, i < 0 ? (byte)0 : i, flag, flag1, flag2, effectinstance), p_230116_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_100012_b(boolean p_100012_1_) {
        this.field_100013_f = p_100012_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_100011_g() {
        return this.field_100013_f;
    }

    @Override
    public int compareTo(EffectInstance p_compareTo_1_) {
        int i = 32147;
        return !(this.func_76459_b() > 32147 && p_compareTo_1_.func_76459_b() > 32147 || this.func_82720_e() && p_compareTo_1_.func_82720_e()) ? ComparisonChain.start().compare(Boolean.valueOf(this.func_82720_e()), Boolean.valueOf(p_compareTo_1_.func_82720_e())).compare(this.func_76459_b(), p_compareTo_1_.func_76459_b()).compare(this.func_188419_a().getGuiSortColor(this), p_compareTo_1_.func_188419_a().getGuiSortColor(this)).result() : ComparisonChain.start().compare(Boolean.valueOf(this.func_82720_e()), Boolean.valueOf(p_compareTo_1_.func_82720_e())).compare(this.func_188419_a().getGuiSortColor(this), p_compareTo_1_.func_188419_a().getGuiSortColor(this)).result();
    }

    public List<ItemStack> getCurativeItems() {
        if (this.curativeItems == null) {
            this.curativeItems = this.func_188419_a().getCurativeItems();
        }
        return this.curativeItems;
    }

    public void setCurativeItems(List<ItemStack> curativeItems) {
        this.curativeItems = curativeItems;
    }

    private static EffectInstance readCurativeItems(EffectInstance effect, CompoundNBT nbt) {
        if (nbt.func_150297_b("CurativeItems", 9)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ListNBT list = nbt.func_150295_c("CurativeItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add(ItemStack.func_199557_a(list.func_150305_b(i)));
            }
            effect.setCurativeItems(items);
        }
        return effect;
    }
}

