/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.SerializableTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeChunk;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chunk
extends CapabilityProvider<Chunk>
implements IChunk,
IForgeChunk {
    private static final Logger field_150817_t = LogManager.getLogger();
    @Nullable
    public static final ChunkSection field_186036_a = null;
    private final ChunkSection[] field_76652_q = new ChunkSection[16];
    private BiomeContainer field_76651_r;
    private final Map<BlockPos, CompoundNBT> field_201618_i = Maps.newHashMap();
    private boolean field_76636_d;
    private final World field_76637_e;
    private final Map<Heightmap.Type, Heightmap> field_76634_f = Maps.newEnumMap(Heightmap.Type.class);
    private final UpgradeData field_196967_n;
    private final Map<BlockPos, TileEntity> field_150816_i = Maps.newHashMap();
    private final ClassInheritanceMultiMap<Entity>[] field_76645_j;
    private final Map<Structure<?>, StructureStart<?>> field_201619_q = Maps.newHashMap();
    private final Map<Structure<?>, LongSet> field_201620_r = Maps.newHashMap();
    private final ShortList[] field_201622_t = new ShortList[16];
    private ITickList<Block> field_201621_s;
    private ITickList<Fluid> field_205325_u;
    private boolean field_76644_m;
    private long field_76641_n;
    private volatile boolean field_76643_l;
    private long field_111204_q;
    @Nullable
    private Supplier<ChunkHolder.LocationType> field_217329_u;
    @Nullable
    private Consumer<Chunk> field_217330_v;
    private final ChunkPos field_212816_F;
    private volatile boolean field_217331_x;

    public Chunk(World p_i225780_1_, ChunkPos p_i225780_2_, BiomeContainer p_i225780_3_) {
        this(p_i225780_1_, p_i225780_2_, p_i225780_3_, UpgradeData.field_196994_a, (ITickList<Block>)EmptyTickList.func_205388_a(), (ITickList<Fluid>)EmptyTickList.func_205388_a(), 0L, null, null);
    }

    public Chunk(World p_i225781_1_, ChunkPos p_i225781_2_, BiomeContainer p_i225781_3_, UpgradeData p_i225781_4_, ITickList<Block> p_i225781_5_, ITickList<Fluid> p_i225781_6_, long p_i225781_7_, @Nullable ChunkSection[] p_i225781_9_, @Nullable Consumer<Chunk> p_i225781_10_) {
        super(Chunk.class);
        this.field_76645_j = new ClassInheritanceMultiMap[16];
        this.field_76637_e = p_i225781_1_;
        this.field_212816_F = p_i225781_2_;
        this.field_196967_n = p_i225781_4_;
        for (Heightmap.Type heightmap$type : Heightmap.Type.values()) {
            if (!ChunkStatus.field_222617_m.func_222595_h().contains(heightmap$type)) continue;
            this.field_76634_f.put(heightmap$type, new Heightmap((IChunk)this, heightmap$type));
        }
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76645_j[i] = new ClassInheritanceMultiMap(Entity.class);
        }
        this.field_76651_r = p_i225781_3_;
        this.field_201621_s = p_i225781_5_;
        this.field_205325_u = p_i225781_6_;
        this.field_111204_q = p_i225781_7_;
        this.field_217330_v = p_i225781_10_;
        if (p_i225781_9_ != null) {
            if (this.field_76652_q.length == p_i225781_9_.length) {
                System.arraycopy(p_i225781_9_, 0, this.field_76652_q, 0, this.field_76652_q.length);
            } else {
                field_150817_t.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)p_i225781_9_.length, (Object)this.field_76652_q.length);
            }
        }
        this.gatherCapabilities();
    }

    public Chunk(World p_i49947_1_, ChunkPrimer p_i49947_2_) {
        this(p_i49947_1_, p_i49947_2_.func_76632_l(), p_i49947_2_.func_225549_i_(), p_i49947_2_.func_196966_y(), (ITickList<Block>)p_i49947_2_.func_205218_i_(), (ITickList<Fluid>)p_i49947_2_.func_212247_j(), p_i49947_2_.func_177416_w(), p_i49947_2_.func_76587_i(), null);
        for (CompoundNBT compoundnbt : p_i49947_2_.func_201652_l()) {
            EntityType.func_220335_a(compoundnbt, p_i49947_1_, p_217325_1_ -> {
                this.func_76612_a((Entity)((Object)p_217325_1_));
                return p_217325_1_;
            });
        }
        for (TileEntity tileentity : p_i49947_2_.func_201627_k().values()) {
            this.func_150813_a(tileentity);
        }
        this.field_201618_i.putAll(p_i49947_2_.func_201632_q());
        for (int i = 0; i < p_i49947_2_.func_201614_D().length; ++i) {
            this.field_201622_t[i] = p_i49947_2_.func_201614_D()[i];
        }
        this.func_201612_a(p_i49947_2_.func_201609_c());
        this.func_201606_b(p_i49947_2_.func_201604_d());
        for (Map.Entry<Heightmap.Type, Heightmap> entry : p_i49947_2_.func_217311_f()) {
            if (!ChunkStatus.field_222617_m.func_222595_h().contains(entry.getKey())) continue;
            this.func_217303_b(entry.getKey()).func_202268_a(entry.getValue().func_202269_a());
        }
        this.func_217305_b(p_i49947_2_.func_217310_r());
        this.field_76643_l = true;
    }

    @Override
    public Heightmap func_217303_b(Heightmap.Type p_217303_1_) {
        return this.field_76634_f.computeIfAbsent(p_217303_1_, p_217319_1_ -> new Heightmap((IChunk)this, p_217319_1_));
    }

    @Override
    public Set<BlockPos> func_203066_o() {
        HashSet set = Sets.newHashSet(this.field_201618_i.keySet());
        set.addAll(this.field_150816_i.keySet());
        return set;
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_76652_q;
    }

    @Override
    public BlockState func_180495_p(BlockPos p_180495_1_) {
        int i = p_180495_1_.func_177958_n();
        int j = p_180495_1_.func_177956_o();
        int k = p_180495_1_.func_177952_p();
        if (this.field_76637_e.func_234925_Z_()) {
            BlockState blockstate = null;
            if (j == 60) {
                blockstate = Blocks.field_180401_cv.func_176223_P();
            }
            if (j == 70) {
                blockstate = DebugChunkGenerator.func_177461_b(i, k);
            }
            return blockstate == null ? Blocks.field_150350_a.func_176223_P() : blockstate;
        }
        try {
            ChunkSection chunksection;
            if (j >= 0 && j >> 4 < this.field_76652_q.length && !ChunkSection.func_222628_a((ChunkSection)(chunksection = this.field_76652_q[j >> 4]))) {
                return chunksection.func_177485_a(i & 0xF, j & 0xF, k & 0xF);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting block state");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being got");
            crashreportcategory.func_189529_a("Location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_184876_a(i, j, k)));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public FluidState func_204610_c(BlockPos p_204610_1_) {
        return this.func_205751_b(p_204610_1_.func_177958_n(), p_204610_1_.func_177956_o(), p_204610_1_.func_177952_p());
    }

    public FluidState func_205751_b(int p_205751_1_, int p_205751_2_, int p_205751_3_) {
        try {
            ChunkSection chunksection;
            if (p_205751_2_ >= 0 && p_205751_2_ >> 4 < this.field_76652_q.length && !ChunkSection.func_222628_a((ChunkSection)(chunksection = this.field_76652_q[p_205751_2_ >> 4]))) {
                return chunksection.func_206914_b(p_205751_1_ & 0xF, p_205751_2_ & 0xF, p_205751_3_ & 0xF);
            }
            return Fluids.field_204541_a.func_207188_f();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting fluid state");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being got");
            crashreportcategory.func_189529_a("Location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_184876_a(p_205751_1_, p_205751_2_, p_205751_3_)));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public BlockState func_177436_a(BlockPos p_177436_1_, BlockState p_177436_2_, boolean p_177436_3_) {
        TileEntity tileentity;
        int i = p_177436_1_.func_177958_n() & 0xF;
        int j = p_177436_1_.func_177956_o();
        int k = p_177436_1_.func_177952_p() & 0xF;
        ChunkSection chunksection = this.field_76652_q[j >> 4];
        if (chunksection == field_186036_a) {
            if (p_177436_2_.func_196958_f()) {
                return null;
            }
            this.field_76652_q[j >> 4] = chunksection = new ChunkSection(j >> 4 << 4);
        }
        boolean flag = chunksection.func_76663_a();
        BlockState blockstate = chunksection.func_222629_a(i, j & 0xF, k, p_177436_2_);
        if (blockstate == p_177436_2_) {
            return null;
        }
        Block block = p_177436_2_.func_177230_c();
        Block block1 = blockstate.func_177230_c();
        this.field_76634_f.get(Heightmap.Type.MOTION_BLOCKING).func_202270_a(i, j, k, p_177436_2_);
        this.field_76634_f.get(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(i, j, k, p_177436_2_);
        this.field_76634_f.get(Heightmap.Type.OCEAN_FLOOR).func_202270_a(i, j, k, p_177436_2_);
        this.field_76634_f.get(Heightmap.Type.WORLD_SURFACE).func_202270_a(i, j, k, p_177436_2_);
        boolean flag1 = chunksection.func_76663_a();
        if (flag != flag1) {
            this.field_76637_e.func_72863_F().func_212863_j_().func_215567_a(p_177436_1_, flag1);
        }
        if (!this.field_76637_e.field_72995_K) {
            blockstate.func_196947_b(this.field_76637_e, p_177436_1_, p_177436_2_, p_177436_3_);
        } else if ((block1 != block || !p_177436_2_.hasTileEntity()) && blockstate.hasTileEntity()) {
            this.field_76637_e.func_175713_t(p_177436_1_);
        }
        if (!chunksection.func_177485_a(i, j & 0xF, k).func_203425_a(block)) {
            return null;
        }
        if (blockstate.hasTileEntity() && (tileentity = this.func_177424_a(p_177436_1_, CreateEntityType.CHECK)) != null) {
            tileentity.func_145836_u();
        }
        if (!this.field_76637_e.field_72995_K && !this.field_76637_e.captureBlockSnapshots) {
            p_177436_2_.func_215705_a(this.field_76637_e, p_177436_1_, blockstate, p_177436_3_);
        }
        if (p_177436_2_.hasTileEntity()) {
            TileEntity tileentity1 = this.func_177424_a(p_177436_1_, CreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = p_177436_2_.createTileEntity((IBlockReader)((Object)this.field_76637_e));
                this.field_76637_e.func_175690_a(p_177436_1_, tileentity1);
            } else {
                tileentity1.func_145836_u();
            }
        }
        this.field_76643_l = true;
        return blockstate;
    }

    @Nullable
    public WorldLightManager func_217307_e() {
        return this.field_76637_e.func_72863_F().func_212863_j_();
    }

    @Override
    public void func_76612_a(Entity p_76612_1_) {
        int k;
        this.field_76644_m = true;
        int i = MathHelper.func_76128_c((double)(p_76612_1_.func_226277_ct_() / 16.0));
        int j = MathHelper.func_76128_c((double)(p_76612_1_.func_226281_cx_() / 16.0));
        if (i != this.field_212816_F.field_77276_a || j != this.field_212816_F.field_77275_b) {
            field_150817_t.warn("Wrong location! ({}, {}) should be ({}, {}), {}", (Object)i, (Object)j, (Object)this.field_212816_F.field_77276_a, (Object)this.field_212816_F.field_77275_b, (Object)p_76612_1_);
            p_76612_1_.field_70128_L = true;
        }
        if ((k = MathHelper.func_76128_c((double)(p_76612_1_.func_226278_cu_() / 16.0))) < 0) {
            k = 0;
        }
        if (k >= this.field_76645_j.length) {
            k = this.field_76645_j.length - 1;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EnteringChunk(p_76612_1_, this.field_212816_F.field_77276_a, this.field_212816_F.field_77275_b, p_76612_1_.field_70176_ah, p_76612_1_.field_70164_aj));
        p_76612_1_.field_70175_ag = true;
        p_76612_1_.field_70176_ah = this.field_212816_F.field_77276_a;
        p_76612_1_.field_70162_ai = k;
        p_76612_1_.field_70164_aj = this.field_212816_F.field_77275_b;
        this.field_76645_j[k].add((Object)p_76612_1_);
        this.func_76630_e();
    }

    @Override
    public void func_201607_a(Heightmap.Type p_201607_1_, long[] p_201607_2_) {
        this.field_76634_f.get(p_201607_1_).func_202268_a(p_201607_2_);
    }

    public void func_76622_b(Entity p_76622_1_) {
        this.func_76608_a(p_76622_1_, p_76622_1_.field_70162_ai);
    }

    public void func_76608_a(Entity p_76608_1_, int p_76608_2_) {
        if (p_76608_2_ < 0) {
            p_76608_2_ = 0;
        }
        if (p_76608_2_ >= this.field_76645_j.length) {
            p_76608_2_ = this.field_76645_j.length - 1;
        }
        this.field_76645_j[p_76608_2_].remove((Object)p_76608_1_);
        this.func_76630_e();
    }

    @Override
    public int func_201576_a(Heightmap.Type p_201576_1_, int p_201576_2_, int p_201576_3_) {
        return this.field_76634_f.get(p_201576_1_).func_202273_a(p_201576_2_ & 0xF, p_201576_3_ & 0xF) - 1;
    }

    @Nullable
    private TileEntity func_177422_i(BlockPos p_177422_1_) {
        BlockState blockstate = this.func_180495_p(p_177422_1_);
        Block block = blockstate.func_177230_c();
        return !blockstate.hasTileEntity() ? null : blockstate.createTileEntity((IBlockReader)((Object)this.field_76637_e));
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos p_175625_1_) {
        return this.func_177424_a(p_175625_1_, CreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity func_177424_a(BlockPos p_177424_1_, CreateEntityType p_177424_2_) {
        TileEntity tileentity1;
        CompoundNBT compoundnbt;
        TileEntity tileentity = this.field_150816_i.get(p_177424_1_);
        if (tileentity != null && tileentity.func_145837_r()) {
            this.field_150816_i.remove(p_177424_1_);
            tileentity = null;
        }
        if (tileentity == null && (compoundnbt = this.field_201618_i.remove(p_177424_1_)) != null && (tileentity1 = this.func_212815_a(p_177424_1_, compoundnbt)) != null) {
            return tileentity1;
        }
        if (tileentity == null && p_177424_2_ == CreateEntityType.IMMEDIATE) {
            tileentity = this.func_177422_i(p_177424_1_);
            this.field_76637_e.func_175690_a(p_177424_1_, tileentity);
        }
        return tileentity;
    }

    public void func_150813_a(TileEntity p_150813_1_) {
        this.func_177426_a(p_150813_1_.func_174877_v(), p_150813_1_);
        if (this.field_76636_d || this.field_76637_e.func_201670_d()) {
            this.field_76637_e.func_175690_a(p_150813_1_.func_174877_v(), p_150813_1_);
        }
    }

    @Override
    public void func_177426_a(BlockPos p_177426_1_, TileEntity p_177426_2_) {
        if (this.func_180495_p(p_177426_1_).hasTileEntity()) {
            p_177426_2_.func_226984_a_(this.field_76637_e, p_177426_1_);
            p_177426_2_.func_145829_t();
            TileEntity tileentity = this.field_150816_i.put(p_177426_1_.func_185334_h(), p_177426_2_);
            if (tileentity != null && tileentity != p_177426_2_) {
                tileentity.func_145843_s();
            }
        }
    }

    @Override
    public void func_201591_a(CompoundNBT p_201591_1_) {
        this.field_201618_i.put(new BlockPos(p_201591_1_.func_74762_e("x"), p_201591_1_.func_74762_e("y"), p_201591_1_.func_74762_e("z")), p_201591_1_);
    }

    @Override
    @Nullable
    public CompoundNBT func_223134_j(BlockPos p_223134_1_) {
        TileEntity tileentity = this.func_175625_s(p_223134_1_);
        if (tileentity != null && !tileentity.func_145837_r()) {
            try {
                CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
                compoundnbt1.func_74757_a("keepPacked", false);
                return compoundnbt1;
            }
            catch (Exception e) {
                LogManager.getLogger().error("A TileEntity type {} has thrown an exception trying to write state. It will not persist, Report this to the mod author", (Object)((Object)((Object)tileentity)).getClass().getName(), (Object)e);
                return null;
            }
        }
        CompoundNBT compoundnbt = this.field_201618_i.get(p_223134_1_);
        if (compoundnbt != null) {
            compoundnbt = compoundnbt.func_74737_b();
            compoundnbt.func_74757_a("keepPacked", true);
        }
        return compoundnbt;
    }

    @Override
    public void func_177425_e(BlockPos p_177425_1_) {
        TileEntity tileentity;
        if ((this.field_76636_d || this.field_76637_e.func_201670_d()) && (tileentity = this.field_150816_i.remove(p_177425_1_)) != null) {
            tileentity.func_145843_s();
        }
    }

    public void func_217318_w() {
        if (this.field_217330_v != null) {
            this.field_217330_v.accept(this);
            this.field_217330_v = null;
        }
    }

    public void func_76630_e() {
        this.field_76643_l = true;
    }

    public void func_177414_a(@Nullable Entity p_177414_1_, AxisAlignedBB p_177414_2_, List<Entity> p_177414_3_, @Nullable Predicate<? super Entity> p_177414_4_) {
        int i = MathHelper.func_76128_c((double)((p_177414_2_.field_72338_b - this.field_76637_e.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((p_177414_2_.field_72337_e + this.field_76637_e.getMaxEntityRadius()) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(this.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(this.field_76645_j.length - 1));
        for (int k = i; k <= j; ++k) {
            ClassInheritanceMultiMap<Entity> classinheritancemultimap = this.field_76645_j[k];
            List list = classinheritancemultimap.func_241289_a_();
            int l = list.size();
            for (int i1 = 0; i1 < l; ++i1) {
                Entity entity = (Entity)((Object)list.get(i1));
                if (!entity.func_174813_aQ().func_72326_a(p_177414_2_) || entity == p_177414_1_ || p_177414_4_ != null && !p_177414_4_.test(entity)) continue;
                p_177414_3_.add(entity);
            }
        }
    }

    public <T extends Entity> void func_217313_a(@Nullable EntityType<?> p_217313_1_, AxisAlignedBB p_217313_2_, List<? super T> p_217313_3_, Predicate<? super T> p_217313_4_) {
        int i = MathHelper.func_76128_c((double)((p_217313_2_.field_72338_b - this.field_76637_e.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((p_217313_2_.field_72337_e + this.field_76637_e.getMaxEntityRadius()) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(this.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(this.field_76645_j.length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity entity : this.field_76645_j[k].func_219790_a(Entity.class)) {
                if (p_217313_1_ != null && entity.func_200600_R() != p_217313_1_ || !entity.func_174813_aQ().func_72326_a(p_217313_2_) || !p_217313_4_.test(entity)) continue;
                p_217313_3_.add((T)((Object)entity));
            }
        }
    }

    public <T extends Entity> void func_177430_a(Class<? extends T> p_177430_1_, AxisAlignedBB p_177430_2_, List<T> p_177430_3_, @Nullable Predicate<? super T> p_177430_4_) {
        int i = MathHelper.func_76128_c((double)((p_177430_2_.field_72338_b - this.field_76637_e.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((p_177430_2_.field_72337_e + this.field_76637_e.getMaxEntityRadius()) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(this.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(this.field_76645_j.length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity t : this.field_76645_j[k].func_219790_a(p_177430_1_)) {
                if (!t.func_174813_aQ().func_72326_a(p_177430_2_) || p_177430_4_ != null && !p_177430_4_.test(t)) continue;
                p_177430_3_.add((T)((Object)t));
            }
        }
    }

    public boolean func_76621_g() {
        return false;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_212816_F;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_227073_a_(@Nullable BiomeContainer p_227073_1_, PacketBuffer p_227073_2_, CompoundNBT p_227073_3_, int p_227073_4_) {
        boolean flag = p_227073_1_ != null;
        Predicate<BlockPos> predicate = flag ? p_217315_0_ -> true : p_217323_1_ -> (p_227073_4_ & 1 << (p_217323_1_.func_177956_o() >> 4)) != 0;
        Sets.newHashSet(this.field_150816_i.keySet()).stream().filter(predicate).forEach(this.field_76637_e::func_175713_t);
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            tileEntity.func_145836_u();
            tileEntity.func_195044_w();
        }
        for (int i = 0; i < this.field_76652_q.length; ++i) {
            ChunkSection chunksection = this.field_76652_q[i];
            if ((p_227073_4_ & 1 << i) == 0) {
                if (!flag || chunksection == field_186036_a) continue;
                this.field_76652_q[i] = field_186036_a;
                continue;
            }
            if (chunksection == field_186036_a) {
                this.field_76652_q[i] = chunksection = new ChunkSection(i << 4);
            }
            chunksection.func_222634_a(p_227073_2_);
        }
        if (p_227073_1_ != null) {
            this.field_76651_r = p_227073_1_;
        }
        for (Heightmap.Type heightmap$type : Heightmap.Type.values()) {
            String s = heightmap$type.func_203500_b();
            if (!p_227073_3_.func_150297_b(s, 12)) continue;
            this.func_201607_a(heightmap$type, p_227073_3_.func_197645_o(s));
        }
        for (TileEntity tileentity : this.field_150816_i.values()) {
            tileentity.func_145836_u();
        }
    }

    @Override
    public BiomeContainer func_225549_i_() {
        return this.field_76651_r;
    }

    public void func_177417_c(boolean p_177417_1_) {
        this.field_76636_d = p_177417_1_;
    }

    public World func_177412_p() {
        return this.field_76637_e;
    }

    @Override
    public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f() {
        return Collections.unmodifiableSet(this.field_76634_f.entrySet());
    }

    public Map<BlockPos, TileEntity> func_177434_r() {
        return this.field_150816_i;
    }

    public ClassInheritanceMultiMap<Entity>[] func_177429_s() {
        return this.field_76645_j;
    }

    @Override
    public CompoundNBT func_201579_g(BlockPos p_201579_1_) {
        return this.field_201618_i.get(p_201579_1_);
    }

    @Override
    public Stream<BlockPos> func_217304_m() {
        return StreamSupport.stream(BlockPos.func_191531_b((int)this.field_212816_F.func_180334_c(), (int)0, (int)this.field_212816_F.func_180333_d(), (int)this.field_212816_F.func_180332_e(), (int)255, (int)this.field_212816_F.func_180330_f()).spliterator(), false).filter(p_217312_1_ -> this.func_180495_p((BlockPos)p_217312_1_).getLightValue((IBlockReader)((Object)this.func_177412_p()), (BlockPos)p_217312_1_) != 0);
    }

    @Override
    public ITickList<Block> func_205218_i_() {
        return this.field_201621_s;
    }

    @Override
    public ITickList<Fluid> func_212247_j() {
        return this.field_205325_u;
    }

    @Override
    public void func_177427_f(boolean p_177427_1_) {
        this.field_76643_l = p_177427_1_;
    }

    @Override
    public boolean func_201593_f() {
        return this.field_76643_l || this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n;
    }

    public void func_177409_g(boolean p_177409_1_) {
        this.field_76644_m = p_177409_1_;
    }

    @Override
    public void func_177432_b(long p_177432_1_) {
        this.field_76641_n = p_177432_1_;
    }

    @Nullable
    public StructureStart<?> func_230342_a_(Structure<?> p_230342_1_) {
        return this.field_201619_q.get(p_230342_1_);
    }

    public void func_230344_a_(Structure<?> p_230344_1_, StructureStart<?> p_230344_2_) {
        this.field_201619_q.put(p_230344_1_, p_230344_2_);
    }

    @Override
    public Map<Structure<?>, StructureStart<?>> func_201609_c() {
        return this.field_201619_q;
    }

    @Override
    public void func_201612_a(Map<Structure<?>, StructureStart<?>> p_201612_1_) {
        this.field_201619_q.clear();
        this.field_201619_q.putAll(p_201612_1_);
    }

    public LongSet func_230346_b_(Structure<?> p_230346_1_) {
        return this.field_201620_r.computeIfAbsent(p_230346_1_, p_235961_0_ -> new LongOpenHashSet());
    }

    public void func_230343_a_(Structure<?> p_230343_1_, long p_230343_2_) {
        this.field_201620_r.computeIfAbsent(p_230343_1_, p_235960_0_ -> new LongOpenHashSet()).add(p_230343_2_);
    }

    public Map<Structure<?>, LongSet> func_201604_d() {
        return this.field_201620_r;
    }

    public void func_201606_b(Map<Structure<?>, LongSet> p_201606_1_) {
        this.field_201620_r.clear();
        this.field_201620_r.putAll(p_201606_1_);
    }

    @Override
    public long func_177416_w() {
        return this.field_111204_q;
    }

    @Override
    public void func_177415_c(long p_177415_1_) {
        this.field_111204_q = p_177415_1_;
    }

    public void func_201595_A() {
        ChunkPos chunkpos = this.func_76632_l();
        for (int i = 0; i < this.field_201622_t.length; ++i) {
            if (this.field_201622_t[i] == null) continue;
            for (Short oshort : this.field_201622_t[i]) {
                BlockPos blockpos = ChunkPrimer.func_201635_a(oshort, i, chunkpos);
                BlockState blockstate = this.func_180495_p(blockpos);
                BlockState blockstate1 = Block.func_199770_b(blockstate, this.field_76637_e, blockpos);
                this.field_76637_e.func_180501_a(blockpos, blockstate1, 20);
            }
            this.field_201622_t[i].clear();
        }
        this.func_222879_B();
        for (BlockPos blockpos1 : Sets.newHashSet(this.field_201618_i.keySet())) {
            this.func_175625_s(blockpos1);
        }
        this.field_201618_i.clear();
        this.field_196967_n.func_196990_a(this);
    }

    @Nullable
    private TileEntity func_212815_a(BlockPos p_212815_1_, CompoundNBT p_212815_2_) {
        TileEntity tileentity;
        BlockState blockstate = this.func_180495_p(p_212815_1_);
        if ("DUMMY".equals(p_212815_2_.func_74779_i("id"))) {
            if (blockstate.hasTileEntity()) {
                tileentity = blockstate.createTileEntity((IBlockReader)((Object)this.field_76637_e));
            } else {
                tileentity = null;
                field_150817_t.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)p_212815_1_, (Object)blockstate);
            }
        } else {
            tileentity = TileEntity.func_235657_b_(blockstate, p_212815_2_);
        }
        if (tileentity != null) {
            tileentity.func_226984_a_(this.field_76637_e, p_212815_1_);
            this.func_150813_a(tileentity);
        } else {
            field_150817_t.warn("Tried to load a block entity for block {} but failed at location {}", (Object)blockstate, (Object)p_212815_1_);
        }
        return tileentity;
    }

    @Override
    public UpgradeData func_196966_y() {
        return this.field_196967_n;
    }

    @Override
    public ShortList[] func_201614_D() {
        return this.field_201622_t;
    }

    public void func_222879_B() {
        if (this.field_201621_s instanceof ChunkPrimerTickList) {
            ((ChunkPrimerTickList)this.field_201621_s).func_205381_a(this.field_76637_e.func_205220_G_(), p_222881_1_ -> this.func_180495_p((BlockPos)p_222881_1_).func_177230_c());
            this.field_201621_s = EmptyTickList.func_205388_a();
        } else if (this.field_201621_s instanceof SerializableTickList) {
            ((SerializableTickList)this.field_201621_s).func_234855_a_(this.field_76637_e.func_205220_G_());
            this.field_201621_s = EmptyTickList.func_205388_a();
        }
        if (this.field_205325_u instanceof ChunkPrimerTickList) {
            ((ChunkPrimerTickList)this.field_205325_u).func_205381_a(this.field_76637_e.func_205219_F_(), p_222878_1_ -> this.func_204610_c((BlockPos)p_222878_1_).func_206886_c());
            this.field_205325_u = EmptyTickList.func_205388_a();
        } else if (this.field_205325_u instanceof SerializableTickList) {
            ((SerializableTickList)this.field_205325_u).func_234855_a_(this.field_76637_e.func_205219_F_());
            this.field_205325_u = EmptyTickList.func_205388_a();
        }
    }

    public void func_222880_a(ServerWorld p_222880_1_) {
        if (this.field_201621_s == EmptyTickList.func_205388_a()) {
            this.field_201621_s = new SerializableTickList(arg_0 -> Registry.field_212618_g.func_177774_c(arg_0), p_222880_1_.func_205220_G_().func_223188_a(this.field_212816_F, true, false), p_222880_1_.func_82737_E());
            this.func_177427_f(true);
        }
        if (this.field_205325_u == EmptyTickList.func_205388_a()) {
            this.field_205325_u = new SerializableTickList(arg_0 -> Registry.field_212619_h.func_177774_c(arg_0), p_222880_1_.func_205219_F_().func_223188_a(this.field_212816_F, true, false), p_222880_1_.func_82737_E());
            this.func_177427_f(true);
        }
    }

    @Override
    public ChunkStatus func_201589_g() {
        return ChunkStatus.field_222617_m;
    }

    public ChunkHolder.LocationType func_217321_u() {
        return this.field_217329_u == null ? ChunkHolder.LocationType.BORDER : this.field_217329_u.get();
    }

    public void func_217314_a(Supplier<ChunkHolder.LocationType> p_217314_1_) {
        this.field_217329_u = p_217314_1_;
    }

    @Override
    public boolean func_217310_r() {
        return this.field_217331_x;
    }

    @Override
    public void func_217305_b(boolean p_217305_1_) {
        this.field_217331_x = p_217305_1_;
        this.func_177427_f(true);
    }

    @Deprecated
    @Nullable
    public final CompoundNBT writeCapsToNBT() {
        return this.serializeCaps();
    }

    @Deprecated
    public final void readCapsFromNBT(CompoundNBT tag) {
        this.deserializeCaps(tag);
    }

    @Override
    public World getWorldForge() {
        return this.func_177412_p();
    }

    public static enum CreateEntityType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }
}

