/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.patch;

import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class GamePatch {
    protected static ClassNode readClass(ClassReader reader) {
        if (reader == null) {
            return null;
        }
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    protected FieldNode findField(ClassNode node, Predicate<FieldNode> predicate) {
        return node.fields.stream().filter(predicate).findAny().orElse(null);
    }

    protected List<FieldNode> findFields(ClassNode node, Predicate<FieldNode> predicate) {
        return node.fields.stream().filter(predicate).collect(Collectors.toList());
    }

    protected MethodNode findMethod(ClassNode node, Predicate<MethodNode> predicate) {
        return node.methods.stream().filter(predicate).findAny().orElse(null);
    }

    protected AbstractInsnNode findInsn(MethodNode node, Predicate<AbstractInsnNode> predicate, boolean last) {
        if (last) {
            for (int i = node.instructions.size() - 1; i >= 0; --i) {
                AbstractInsnNode insn = node.instructions.get(i);
                if (!predicate.test(insn)) continue;
                return insn;
            }
        } else {
            for (int i = 0; i < node.instructions.size(); ++i) {
                AbstractInsnNode insn = node.instructions.get(i);
                if (!predicate.test(insn)) continue;
                return insn;
            }
        }
        return null;
    }

    protected void moveAfter(ListIterator<AbstractInsnNode> it, int opcode) {
        AbstractInsnNode node;
        while (it.hasNext() && (node = it.next()).getOpcode() != opcode) {
        }
    }

    protected void moveBefore(ListIterator<AbstractInsnNode> it, int opcode) {
        this.moveAfter(it, opcode);
        it.previous();
    }

    protected void moveAfter(ListIterator<AbstractInsnNode> it, AbstractInsnNode targetNode) {
        AbstractInsnNode node;
        while (it.hasNext() && (node = it.next()) != targetNode) {
        }
    }

    protected void moveBefore(ListIterator<AbstractInsnNode> it, AbstractInsnNode targetNode) {
        this.moveAfter(it, targetNode);
        it.previous();
    }

    protected void moveBeforeType(ListIterator<AbstractInsnNode> it, int nodeType) {
        AbstractInsnNode node;
        while (it.hasPrevious() && (node = it.previous()).getType() != nodeType) {
        }
    }

    protected boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    protected boolean isPublicStatic(int access) {
        return (access & 0xF) == 9;
    }

    protected boolean isPublicInstance(int access) {
        return (access & 0xF) == 1;
    }

    public abstract void process(FabricLauncher var1, Function<String, ClassReader> var2, Consumer<ClassNode> var3);
}

